#define XOR_CONFIG_REG				0x0
#define XOR_ACTIVE_REG				0x4
#define XOR_NEXTDESC_REG			0x8
#define XOR_CURRDESC_REG			0xC
#define XOR_BYTECOUNT_REG			0x10
#define XOR_DESTPOINT_REG			0x14
#define XOR_BLOCKSIZE_REG			0x18
#define XOR_MEMINITVAL0_REG			0x1C
#define XOR_MEMINITVAL1_REG			0x20
#define XOR_MEMINITVAL2_REG			0x24
#define XOR_MEMINITVAL3_REG			0x28
#define XOR_INTCAUSE_REG			0x2C
#define XOR_INTENABLE_REG			0x30
#define XOR_ERRCAUSE_REG			0x34
#define XOR_ERRADDR_REG				0x38
#define XOR_ACCESSPRO_REG			0x3C

/* XOR_CONFIG_REG */
#define XEXCR_OPERATION_MODE_OFFS	(0)
#define XEXCR_OPERATION_MODE_MASK	(7 << XEXCR_OPERATION_MODE_OFFS)
#define XEXCR_OPERATION_MODE_XOR	(0 << XEXCR_OPERATION_MODE_OFFS)
#define XEXCR_OPERATION_MODE_DMA	(2 << XEXCR_OPERATION_MODE_OFFS)
#define XEXCR_OPERATION_MODE_MEM_INIT	(4 << XEXCR_OPERATION_MODE_OFFS)

#define XEXCR_SRC_BURST_LIMIT_OFFS	(4)
#define XEXCR_SRC_BURST_LIMIT_MASK	(7 << XEXCR_SRC_BURST_LIMIT_OFFS)
#define XEXCR_DST_BURST_LIMIT_OFFS	(8)
#define XEXCR_DST_BURST_LIMIT_MASK	(7 << XEXCR_DST_BURST_LIMIT_OFFS)
#define XEXCR_DRD_RES_SWP_OFFS		(12)
#define XEXCR_DRD_RES_SWP_MASK		(1 << XEXCR_DRD_RES_SWP_OFFS)
#define XEXCR_DWR_REQ_SWP_OFFS		(13)
#define XEXCR_DWR_REQ_SWP_MASK		(1 << XEXCR_DWR_REQ_SWP_OFFS)
#define XEXCR_DES_SWP_OFFS		(14)
#define XEXCR_DES_SWP_MASK		(1 << XEXCR_DES_SWP_OFFS)
#define XEXCR_REG_ACC_PROTECT_OFFS	(15)
#define XEXCR_REG_ACC_PROTECT_MASK	(1 << XEXCR_REG_ACC_PROTECT_OFFS)

/* XOR_ACTIVE_REG */
#define XEXACTR_XESTART_OFFS		(0)
#define XEXACTR_XESTART_MASK		(1 << XEXACTR_XESTART_OFFS)
#define XEXACTR_XESTOP_OFFS		(1)
#define XEXACTR_XESTOP_MASK		(1 << XEXACTR_XESTOP_OFFS)
#define XEXACTR_XEPAUSE_OFFS		(2)
#define XEXACTR_XEPAUSE_MASK		(1 << XEXACTR_XEPAUSE_OFFS)
#define XEXACTR_XERESTART_OFFS		(3)
#define XEXACTR_XERESTART_MASK		(1 << XEXACTR_XERESTART_OFFS)
#define XEXACTR_XESTATUS_OFFS		(4)
#define XEXACTR_XESTATUS_MASK		(3 << XEXACTR_XESTATUS_OFFS)
#define XEXACTR_XESTATUS_IDLE		(0 << XEXACTR_XESTATUS_OFFS)
#define XEXACTR_XESTATUS_ACTIVE		(1 << XEXACTR_XESTATUS_OFFS)
#define XEXACTR_XESTATUS_PAUSED		(2 << XEXACTR_XESTATUS_OFFS)

/* XOR_NEXTDESC_REG */
#define XEXNDPR_NEXT_DESC_PTR_OFFS	(0)
#define XEXNDPR_NEXT_DESC_PTR_MASK	\
			(0xFFFFFFFF << XEXNDPR_NEXT_DESC_PTR_OFFS)

/* XOR_CURRDESC_REG */
#define XEXCDPR_CURRENT_DESC_PTR_OFFS	(0)
#define XEXCDPR_CURRENT_DESC_PTR_MASK	\
			(0xFFFFFFFF << XEXCDPR_CURRENT_DESC_PTR_OFFS)

/* XOR_BYTECOUNT_REG */
#define XEXBCR_BYTE_CNT_OFFS		(0)
#define XEXBCR_BYTE_CNT_MASK		(0xFFFFFFFF << XEXBCR_BYTE_CNT_OFFS)

/* XOR_DESTPOINT_REG */
#define XEXDPR_DST_PTR_OFFS		(0)
#define XEXDPR_DST_PTR_MASK		(0xFFFFFFFF << XEXDPR_DST_PTR_OFFS)
#define XEXDPR_DST_PTR_XOR_MASK		(0x3F)
#define XEXDPR_DST_PTR_DMA_MASK		(0x1F)
#define XEXDPR_DST_PTR_CRC_MASK		(0x1F)

/* XOR_BLOCKSIZE_REG */
#define XEXBSR_BLOCK_SIZE_OFFS		(0)
#define XEXBSR_BLOCK_SIZE_MASK		(0xFFFFFFFF << XEXBSR_BLOCK_SIZE_OFFS)
#define XEXBSR_BLOCK_SIZE_MIN_VALUE	(128)
#define XEXBSR_BLOCK_SIZE_MAX_VALUE	(0xFFFFFFFF)

/* XOR_INTCAUSE_REG */
#define END_OF_DESC			(1 << 0)
#define END_OF_CHAIN			(1 << 1)
#define ENINE_STOPED			(1 << 2)
#define ENINE_PAUSED			(1 << 3)
#define ACCESS_FORBID			(1 << 4)
#define WRITE_FORBID			(1 << 5)
#define OWN_BIT_ERROR			(1 << 6)
#define AXI_BUS_ERROR			(1 << 7)
#define XOR_INT_MASK			0xff

/* XOR_ERRCAUSE_REG */
#define READ_ERROR_ADDR			0x4
#define WRITE_ERROR_ADDR		0x5
#define ACCESS_RESERVED_ADDR		(1 << 6)
#define ACCESS_PROTECTED_ADDR		(1 << 7)

/* XOR_ERRADDR_REG */
#define XEEAR_ERR_ADDR_OFFS		(0)
#define XEEAR_ERR_ADDR_MASK		(0xFFFFFFFF << XEEAR_ERR_ADDR_OFFS)
