/*
 * Shared Atheros AR9170 Header
 *
 * PHY register map
 *
 * Copyright (c) 2008-2009 Atheros Communications Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __CARL9170_SHARED_PHY_H
#define __CARL9170_SHARED_PHY_H

#define	AR9170_PHY_REG_BASE			(0x1bc000 + 0x9800)
#define	AR9170_PHY_REG(_n)			(AR9170_PHY_REG_BASE + \
						 ((_n) << 2))

#define	AR9170_PHY_REG_TEST			(AR9170_PHY_REG_BASE + 0x0000)
#define		AR9170_PHY_TEST_AGC_CLR			0x10000000
#define		AR9170_PHY_TEST_RFSILENT_BB		0x00002000

#define	AR9170_PHY_REG_TURBO			(AR9170_PHY_REG_BASE + 0x0004)
#define		AR9170_PHY_TURBO_FC_TURBO_MODE		0x00000001
#define		AR9170_PHY_TURBO_FC_TURBO_SHORT		0x00000002
#define		AR9170_PHY_TURBO_FC_DYN2040_EN		0x00000004
#define		AR9170_PHY_TURBO_FC_DYN2040_PRI_ONLY	0x00000008
#define		AR9170_PHY_TURBO_FC_DYN2040_PRI_CH	0x00000010
/* For 25 MHz channel spacing -- not used but supported by hw */
#define		AR9170_PHY_TURBO_FC_DYN2040_EXT_CH	0x00000020
#define		AR9170_PHY_TURBO_FC_HT_EN		0x00000040
#define		AR9170_PHY_TURBO_FC_SHORT_GI_40		0x00000080
#define		AR9170_PHY_TURBO_FC_WALSH		0x00000100
#define		AR9170_PHY_TURBO_FC_SINGLE_HT_LTF1	0x00000200
#define		AR9170_PHY_TURBO_FC_ENABLE_DAC_FIFO	0x00000800

#define	AR9170_PHY_REG_TEST2			(AR9170_PHY_REG_BASE + 0x0008)

#define	AR9170_PHY_REG_TIMING2			(AR9170_PHY_REG_BASE + 0x0010)
#define		AR9170_PHY_TIMING2_USE_FORCE		0x00001000
#define		AR9170_PHY_TIMING2_FORCE		0x00000fff
#define		AR9170_PHY_TIMING2_FORCE_S			 0

#define	AR9170_PHY_REG_TIMING3			(AR9170_PHY_REG_BASE + 0x0014)
#define		AR9170_PHY_TIMING3_DSC_EXP		0x0001e000
#define		AR9170_PHY_TIMING3_DSC_EXP_S		13
#define		AR9170_PHY_TIMING3_DSC_MAN		0xfffe0000
#define		AR9170_PHY_TIMING3_DSC_MAN_S		17

#define	AR9170_PHY_REG_CHIP_ID			(AR9170_PHY_REG_BASE + 0x0018)
#define		AR9170_PHY_CHIP_ID_REV_0		0x80
#define		AR9170_PHY_CHIP_ID_REV_1		0x81
#define		AR9170_PHY_CHIP_ID_9160_REV_0		0xb0

#define	AR9170_PHY_REG_ACTIVE			(AR9170_PHY_REG_BASE + 0x001c)
#define		AR9170_PHY_ACTIVE_EN			0x00000001
#define		AR9170_PHY_ACTIVE_DIS			0x00000000

#define	AR9170_PHY_REG_RF_CTL2			(AR9170_PHY_REG_BASE + 0x0024)
#define		AR9170_PHY_RF_CTL2_TX_END_DATA_START	0x000000ff
#define		AR9170_PHY_RF_CTL2_TX_END_DATA_START_S	0
#define		AR9170_PHY_RF_CTL2_TX_END_PA_ON		0x0000ff00
#define		AR9170_PHY_RF_CTL2_TX_END_PA_ON_S	8

#define	AR9170_PHY_REG_RF_CTL3                  (AR9170_PHY_REG_BASE + 0x0028)
#define		AR9170_PHY_RF_CTL3_TX_END_TO_A2_RX_ON	0x00ff0000
#define		AR9170_PHY_RF_CTL3_TX_END_TO_A2_RX_ON_S	16

#define	AR9170_PHY_REG_ADC_CTL			(AR9170_PHY_REG_BASE + 0x002c)
#define		AR9170_PHY_ADC_CTL_OFF_INBUFGAIN	0x00000003
#define		AR9170_PHY_ADC_CTL_OFF_INBUFGAIN_S	0
#define		AR9170_PHY_ADC_CTL_OFF_PWDDAC		0x00002000
#define		AR9170_PHY_ADC_CTL_OFF_PWDBANDGAP	0x00004000
#define		AR9170_PHY_ADC_CTL_OFF_PWDADC		0x00008000
#define		AR9170_PHY_ADC_CTL_ON_INBUFGAIN		0x00030000
#define		AR9170_PHY_ADC_CTL_ON_INBUFGAIN_S	16

#define	AR9170_PHY_REG_ADC_SERIAL_CTL		(AR9170_PHY_REG_BASE + 0x0030)
#define		AR9170_PHY_ADC_SCTL_SEL_INTERNAL_ADDAC	0x00000000
#define		AR9170_PHY_ADC_SCTL_SEL_EXTERNAL_RADIO	0x00000001

#define	AR9170_PHY_REG_RF_CTL4			(AR9170_PHY_REG_BASE + 0x0034)
#define		AR9170_PHY_RF_CTL4_TX_END_XPAB_OFF	0xff000000
#define		AR9170_PHY_RF_CTL4_TX_END_XPAB_OFF_S	24
#define		AR9170_PHY_RF_CTL4_TX_END_XPAA_OFF	0x00ff0000
#define		AR9170_PHY_RF_CTL4_TX_END_XPAA_OFF_S	16
#define		AR9170_PHY_RF_CTL4_FRAME_XPAB_ON	0x0000ff00
#define		AR9170_PHY_RF_CTL4_FRAME_XPAB_ON_S	8
#define		AR9170_PHY_RF_CTL4_FRAME_XPAA_ON	0x000000ff
#define		AR9170_PHY_RF_CTL4_FRAME_XPAA_ON_S	0

#define	AR9170_PHY_REG_TSTDAC_CONST		(AR9170_PHY_REG_BASE + 0x003c)

#define	AR9170_PHY_REG_SETTLING			(AR9170_PHY_REG_BASE + 0x0044)
#define		AR9170_PHY_SETTLING_SWITCH		0x00003f80
#define		AR9170_PHY_SETTLING_SWITCH_S		7

#define	AR9170_PHY_REG_RXGAIN			(AR9170_PHY_REG_BASE + 0x0048)
#define	AR9170_PHY_REG_RXGAIN_CHAIN_2		(AR9170_PHY_REG_BASE + 0x2048)
#define		AR9170_PHY_RXGAIN_TXRX_ATTEN		0x0003f000
#define		AR9170_PHY_RXGAIN_TXRX_ATTEN_S		12
#define		AR9170_PHY_RXGAIN_TXRX_RF_MAX		0x007c0000
#define		AR9170_PHY_RXGAIN_TXRX_RF_MAX_S		18

#define	AR9170_PHY_REG_DESIRED_SZ		(AR9170_PHY_REG_BASE + 0x0050)
#define		AR9170_PHY_DESIRED_SZ_ADC		0x000000ff
#define		AR9170_PHY_DESIRED_SZ_ADC_S		0
#define		AR9170_PHY_DESIRED_SZ_PGA		0x0000ff00
#define		AR9170_PHY_DESIRED_SZ_PGA_S		8
#define		AR9170_PHY_DESIRED_SZ_TOT_DES		0x0ff00000
#define		AR9170_PHY_DESIRED_SZ_TOT_DES_S		20

#define	AR9170_PHY_REG_FIND_SIG			(AR9170_PHY_REG_BASE + 0x0058)
#define		AR9170_PHY_FIND_SIG_FIRSTEP		0x0003f000
#define		AR9170_PHY_FIND_SIG_FIRSTEP_S		12
#define		AR9170_PHY_FIND_SIG_FIRPWR		0x03fc0000
#define		AR9170_PHY_FIND_SIG_FIRPWR_S		18

#define	AR9170_PHY_REG_AGC_CTL1			(AR9170_PHY_REG_BASE + 0x005c)
#define		AR9170_PHY_AGC_CTL1_COARSE_LOW		0x00007f80
#define		AR9170_PHY_AGC_CTL1_COARSE_LOW_S	7
#define		AR9170_PHY_AGC_CTL1_COARSE_HIGH		0x003f8000
#define		AR9170_PHY_AGC_CTL1_COARSE_HIGH_S	15

#define	AR9170_PHY_REG_AGC_CONTROL		(AR9170_PHY_REG_BASE + 0x0060)
#define		AR9170_PHY_AGC_CONTROL_CAL		0x00000001
#define		AR9170_PHY_AGC_CONTROL_NF		0x00000002
#define		AR9170_PHY_AGC_CONTROL_ENABLE_NF	0x00008000
#define		AR9170_PHY_AGC_CONTROL_FLTR_CAL		0x00010000
#define		AR9170_PHY_AGC_CONTROL_NO_UPDATE_NF	0x00020000

#define	AR9170_PHY_REG_CCA			(AR9170_PHY_REG_BASE + 0x0064)
#define		AR9170_PHY_CCA_MIN_PWR			0x0ff80000
#define		AR9170_PHY_CCA_MIN_PWR_S		19
#define		AR9170_PHY_CCA_THRESH62			0x0007f000
#define		AR9170_PHY_CCA_THRESH62_S		12

#define	AR9170_PHY_REG_SFCORR			(AR9170_PHY_REG_BASE + 0x0068)
#define		AR9170_PHY_SFCORR_M2COUNT_THR		0x0000001f
#define		AR9170_PHY_SFCORR_M2COUNT_THR_S		0
#define		AR9170_PHY_SFCORR_M1_THRESH		0x00fe0000
#define		AR9170_PHY_SFCORR_M1_THRESH_S		17
#define		AR9170_PHY_SFCORR_M2_THRESH		0x7f000000
#define		AR9170_PHY_SFCORR_M2_THRESH_S		24

#define	AR9170_PHY_REG_SFCORR_LOW		(AR9170_PHY_REG_BASE + 0x006c)
#define		AR9170_PHY_SFCORR_LOW_USE_SELF_CORR_LOW	0x00000001
#define		AR9170_PHY_SFCORR_LOW_M2COUNT_THR_LOW	0x00003f00
#define		AR9170_PHY_SFCORR_LOW_M2COUNT_THR_LOW_S	8
#define		AR9170_PHY_SFCORR_LOW_M1_THRESH_LOW	0x001fc000
#define		AR9170_PHY_SFCORR_LOW_M1_THRESH_LOW_S	14
#define		AR9170_PHY_SFCORR_LOW_M2_THRESH_LOW	0x0fe00000
#define		AR9170_PHY_SFCORR_LOW_M2_THRESH_LOW_S	21

#define	AR9170_PHY_REG_SLEEP_CTR_CONTROL	(AR9170_PHY_REG_BASE + 0x0070)
#define	AR9170_PHY_REG_SLEEP_CTR_LIMIT		(AR9170_PHY_REG_BASE + 0x0074)
#define	AR9170_PHY_REG_SLEEP_SCAL		(AR9170_PHY_REG_BASE + 0x0078)

#define	AR9170_PHY_REG_PLL_CTL			(AR9170_PHY_REG_BASE + 0x007c)
#define		AR9170_PHY_PLL_CTL_40			0xaa
#define		AR9170_PHY_PLL_CTL_40_5413		0x04
#define		AR9170_PHY_PLL_CTL_44			0xab
#define		AR9170_PHY_PLL_CTL_44_2133		0xeb
#define		AR9170_PHY_PLL_CTL_40_2133		0xea

#define	AR9170_PHY_REG_BIN_MASK_1		(AR9170_PHY_REG_BASE + 0x0100)
#define	AR9170_PHY_REG_BIN_MASK_2		(AR9170_PHY_REG_BASE + 0x0104)
#define	AR9170_PHY_REG_BIN_MASK_3		(AR9170_PHY_REG_BASE + 0x0108)
#define	AR9170_PHY_REG_MASK_CTL			(AR9170_PHY_REG_BASE + 0x010c)

/* analogue power on time (100ns) */
#define	AR9170_PHY_REG_RX_DELAY			(AR9170_PHY_REG_BASE + 0x0114)
#define	AR9170_PHY_REG_SEARCH_START_DELAY	(AR9170_PHY_REG_BASE + 0x0118)
#define		AR9170_PHY_RX_DELAY_DELAY		0x00003fff

#define	AR9170_PHY_REG_TIMING_CTRL4(_i)		(AR9170_PHY_REG_BASE + \
						(0x0120 + ((_i) << 12)))
#define		AR9170_PHY_TIMING_CTRL4_IQCORR_Q_Q_COFF		0x01f
#define		AR9170_PHY_TIMING_CTRL4_IQCORR_Q_Q_COFF_S	0
#define		AR9170_PHY_TIMING_CTRL4_IQCORR_Q_I_COFF		0x7e0
#define		AR9170_PHY_TIMING_CTRL4_IQCORR_Q_I_COFF_S	5
#define		AR9170_PHY_TIMING_CTRL4_IQCORR_ENABLE		0x800
#define		AR9170_PHY_TIMING_CTRL4_IQCAL_LOG_COUNT_MAX	0xf000
#define		AR9170_PHY_TIMING_CTRL4_IQCAL_LOG_COUNT_MAX_S	12
#define		AR9170_PHY_TIMING_CTRL4_DO_IQCAL		0x10000
#define		AR9170_PHY_TIMING_CTRL4_ENABLE_SPUR_RSSI	0x80000000
#define		AR9170_PHY_TIMING_CTRL4_ENABLE_SPUR_FILTER	0x40000000
#define		AR9170_PHY_TIMING_CTRL4_ENABLE_CHAN_MASK	0x20000000
#define		AR9170_PHY_TIMING_CTRL4_ENABLE_PILOT_MASK	0x10000000

#define	AR9170_PHY_REG_TIMING5			(AR9170_PHY_REG_BASE + 0x0124)
#define		AR9170_PHY_TIMING5_CYCPWR_THR1		0x000000fe
#define		AR9170_PHY_TIMING5_CYCPWR_THR1_S	1

#define	AR9170_PHY_REG_POWER_TX_RATE1		(AR9170_PHY_REG_BASE + 0x0134)
#define	AR9170_PHY_REG_POWER_TX_RATE2		(AR9170_PHY_REG_BASE + 0x0138)
#define	AR9170_PHY_REG_POWER_TX_RATE_MAX	(AR9170_PHY_REG_BASE + 0x013c)
#define		AR9170_PHY_POWER_TX_RATE_MAX_TPC_ENABLE	0x00000040

#define	AR9170_PHY_REG_FRAME_CTL		(AR9170_PHY_REG_BASE + 0x0144)
#define		AR9170_PHY_FRAME_CTL_TX_CLIP		0x00000038
#define		AR9170_PHY_FRAME_CTL_TX_CLIP_S		3

#define	AR9170_PHY_REG_SPUR_REG			(AR9170_PHY_REG_BASE + 0x014c)
#define		AR9170_PHY_SPUR_REG_MASK_RATE_CNTL	(0xff << 18)
#define		AR9170_PHY_SPUR_REG_MASK_RATE_CNTL_S	18
#define		AR9170_PHY_SPUR_REG_ENABLE_MASK_PPM	0x20000
#define		AR9170_PHY_SPUR_REG_MASK_RATE_SELECT	(0xff << 9)
#define		AR9170_PHY_SPUR_REG_MASK_RATE_SELECT_S	9
#define		AR9170_PHY_SPUR_REG_ENABLE_VIT_SPUR_RSSI	0x100
#define		AR9170_PHY_SPUR_REG_SPUR_RSSI_THRESH	0x7f
#define		AR9170_PHY_SPUR_REG_SPUR_RSSI_THRESH_S	0

#define	AR9170_PHY_REG_RADAR_EXT		(AR9170_PHY_REG_BASE + 0x0140)
#define		AR9170_PHY_RADAR_EXT_ENA		0x00004000

#define	AR9170_PHY_REG_RADAR_0			(AR9170_PHY_REG_BASE + 0x0154)
#define		AR9170_PHY_RADAR_0_ENA			0x00000001
#define		AR9170_PHY_RADAR_0_FFT_ENA		0x80000000
/* inband pulse threshold */
#define		AR9170_PHY_RADAR_0_INBAND		0x0000003e
#define		AR9170_PHY_RADAR_0_INBAND_S		1
/* pulse RSSI threshold */
#define		AR9170_PHY_RADAR_0_PRSSI		0x00000fc0
#define		AR9170_PHY_RADAR_0_PRSSI_S		6
/* pulse height threshold */
#define		AR9170_PHY_RADAR_0_HEIGHT		0x0003f000
#define		AR9170_PHY_RADAR_0_HEIGHT_S		12
/* radar RSSI threshold */
#define		AR9170_PHY_RADAR_0_RRSSI		0x00fc0000
#define		AR9170_PHY_RADAR_0_RRSSI_S		18
/* radar firepower threshold */
#define		AR9170_PHY_RADAR_0_FIRPWR		0x7f000000
#define		AR9170_PHY_RADAR_0_FIRPWR_S		24

#define	AR9170_PHY_REG_RADAR_1			(AR9170_PHY_REG_BASE + 0x0158)
#define		AR9170_PHY_RADAR_1_RELPWR_ENA		0x00800000
#define		AR9170_PHY_RADAR_1_USE_FIR128		0x00400000
#define		AR9170_PHY_RADAR_1_RELPWR_THRESH	0x003f0000
#define		AR9170_PHY_RADAR_1_RELPWR_THRESH_S	16
#define		AR9170_PHY_RADAR_1_BLOCK_CHECK		0x00008000
#define		AR9170_PHY_RADAR_1_MAX_RRSSI		0x00004000
#define		AR9170_PHY_RADAR_1_RELSTEP_CHECK	0x00002000
#define		AR9170_PHY_RADAR_1_RELSTEP_THRESH	0x00001f00
#define		AR9170_PHY_RADAR_1_RELSTEP_THRESH_S	8
#define		AR9170_PHY_RADAR_1_MAXLEN		0x000000ff
#define		AR9170_PHY_RADAR_1_MAXLEN_S		0

#define	AR9170_PHY_REG_SWITCH_CHAIN_0		(AR9170_PHY_REG_BASE + 0x0160)
#define	AR9170_PHY_REG_SWITCH_CHAIN_2		(AR9170_PHY_REG_BASE + 0x2160)

#define	AR9170_PHY_REG_SWITCH_COM		(AR9170_PHY_REG_BASE + 0x0164)

#define	AR9170_PHY_REG_CCA_THRESHOLD		(AR9170_PHY_REG_BASE + 0x0168)

#define	AR9170_PHY_REG_SIGMA_DELTA		(AR9170_PHY_REG_BASE + 0x016c)
#define		AR9170_PHY_SIGMA_DELTA_ADC_SEL		0x00000003
#define		AR9170_PHY_SIGMA_DELTA_ADC_SEL_S	0
#define		AR9170_PHY_SIGMA_DELTA_FILT2		0x000000f8
#define		AR9170_PHY_SIGMA_DELTA_FILT2_S		3
#define		AR9170_PHY_SIGMA_DELTA_FILT1		0x00001f00
#define		AR9170_PHY_SIGMA_DELTA_FILT1_S		8
#define		AR9170_PHY_SIGMA_DELTA_ADC_CLIP		0x01ffe000
#define		AR9170_PHY_SIGMA_DELTA_ADC_CLIP_S	13

#define	AR9170_PHY_REG_RESTART			(AR9170_PHY_REG_BASE + 0x0170)
#define		AR9170_PHY_RESTART_DIV_GC		0x001c0000
#define		AR9170_PHY_RESTART_DIV_GC_S		18

#define	AR9170_PHY_REG_RFBUS_REQ		(AR9170_PHY_REG_BASE + 0x017c)
#define		AR9170_PHY_RFBUS_REQ_EN			0x00000001

#define	AR9170_PHY_REG_TIMING7			(AR9170_PHY_REG_BASE + 0x0180)
#define	AR9170_PHY_REG_TIMING8			(AR9170_PHY_REG_BASE + 0x0184)
#define		AR9170_PHY_TIMING8_PILOT_MASK_2		0x000fffff
#define		AR9170_PHY_TIMING8_PILOT_MASK_2_S	0

#define	AR9170_PHY_REG_BIN_MASK2_1		(AR9170_PHY_REG_BASE + 0x0188)
#define	AR9170_PHY_REG_BIN_MASK2_2		(AR9170_PHY_REG_BASE + 0x018c)
#define	AR9170_PHY_REG_BIN_MASK2_3		(AR9170_PHY_REG_BASE + 0x0190)
#define	AR9170_PHY_REG_BIN_MASK2_4		(AR9170_PHY_REG_BASE + 0x0194)
#define		AR9170_PHY_BIN_MASK2_4_MASK_4		0x00003fff
#define		AR9170_PHY_BIN_MASK2_4_MASK_4_S		0

#define	AR9170_PHY_REG_TIMING9			(AR9170_PHY_REG_BASE + 0x0198)
#define	AR9170_PHY_REG_TIMING10			(AR9170_PHY_REG_BASE + 0x019c)
#define		AR9170_PHY_TIMING10_PILOT_MASK_2	0x000fffff
#define		AR9170_PHY_TIMING10_PILOT_MASK_2_S	0

#define	AR9170_PHY_REG_TIMING11			(AR9170_PHY_REG_BASE + 0x01a0)
#define		AR9170_PHY_TIMING11_SPUR_DELTA_PHASE	0x000fffff
#define		AR9170_PHY_TIMING11_SPUR_DELTA_PHASE_S	0
#define		AR9170_PHY_TIMING11_SPUR_FREQ_SD	0x3ff00000
#define		AR9170_PHY_TIMING11_SPUR_FREQ_SD_S	20
#define		AR9170_PHY_TIMING11_USE_SPUR_IN_AGC	0x40000000
#define		AR9170_PHY_TIMING11_USE_SPUR_IN_SELFCOR	0x80000000

#define	AR9170_PHY_REG_RX_CHAINMASK		(AR9170_PHY_REG_BASE + 0x01a4)
#define	AR9170_PHY_REG_NEW_ADC_DC_GAIN_CORR(_i)	(AR9170_PHY_REG_BASE + \
						 0x01b4 + ((_i) << 12))
#define		AR9170_PHY_NEW_ADC_GAIN_CORR_ENABLE		0x40000000
#define		AR9170_PHY_NEW_ADC_DC_OFFSET_CORR_ENABLE	0x80000000

#define	AR9170_PHY_REG_MULTICHAIN_GAIN_CTL	(AR9170_PHY_REG_BASE + 0x01ac)
#define		AR9170_PHY_9285_ANT_DIV_CTL_ALL		0x7f000000
#define		AR9170_PHY_9285_ANT_DIV_CTL		0x01000000
#define		AR9170_PHY_9285_ANT_DIV_CTL_S		24
#define		AR9170_PHY_9285_ANT_DIV_ALT_LNACONF	0x06000000
#define		AR9170_PHY_9285_ANT_DIV_ALT_LNACONF_S	25
#define		AR9170_PHY_9285_ANT_DIV_MAIN_LNACONF	0x18000000
#define		AR9170_PHY_9285_ANT_DIV_MAIN_LNACONF_S	27
#define		AR9170_PHY_9285_ANT_DIV_ALT_GAINTB	0x20000000
#define		AR9170_PHY_9285_ANT_DIV_ALT_GAINTB_S	29
#define		AR9170_PHY_9285_ANT_DIV_MAIN_GAINTB	0x40000000
#define		AR9170_PHY_9285_ANT_DIV_MAIN_GAINTB_S	30
#define		AR9170_PHY_9285_ANT_DIV_LNA1		2
#define		AR9170_PHY_9285_ANT_DIV_LNA2		1
#define		AR9170_PHY_9285_ANT_DIV_LNA1_PLUS_LNA2	3
#define		AR9170_PHY_9285_ANT_DIV_LNA1_MINUS_LNA2	0
#define		AR9170_PHY_9285_ANT_DIV_GAINTB_0	0
#define		AR9170_PHY_9285_ANT_DIV_GAINTB_1	1

#define	AR9170_PHY_REG_EXT_CCA0			(AR9170_PHY_REG_BASE + 0x01b8)
#define		AR9170_PHY_REG_EXT_CCA0_THRESH62	0x000000ff
#define		AR9170_PHY_REG_EXT_CCA0_THRESH62_S	0

#define	AR9170_PHY_REG_EXT_CCA			(AR9170_PHY_REG_BASE + 0x01bc)
#define		AR9170_PHY_EXT_CCA_CYCPWR_THR1		0x0000fe00
#define		AR9170_PHY_EXT_CCA_CYCPWR_THR1_S	9
#define		AR9170_PHY_EXT_CCA_THRESH62		0x007f0000
#define		AR9170_PHY_EXT_CCA_THRESH62_S		16
#define		AR9170_PHY_EXT_CCA_MIN_PWR		0xff800000
#define		AR9170_PHY_EXT_CCA_MIN_PWR_S		23

#define	AR9170_PHY_REG_SFCORR_EXT		(AR9170_PHY_REG_BASE + 0x01c0)
#define		AR9170_PHY_SFCORR_EXT_M1_THRESH		0x0000007f
#define		AR9170_PHY_SFCORR_EXT_M1_THRESH_S	0
#define		AR9170_PHY_SFCORR_EXT_M2_THRESH		0x00003f80
#define		AR9170_PHY_SFCORR_EXT_M2_THRESH_S	7
#define		AR9170_PHY_SFCORR_EXT_M1_THRESH_LOW	0x001fc000
#define		AR9170_PHY_SFCORR_EXT_M1_THRESH_LOW_S	14
#define		AR9170_PHY_SFCORR_EXT_M2_THRESH_LOW	0x0fe00000
#define		AR9170_PHY_SFCORR_EXT_M2_THRESH_LOW_S	21
#define		AR9170_PHY_SFCORR_SPUR_SUBCHNL_SD_S	28

#define	AR9170_PHY_REG_HALFGI			(AR9170_PHY_REG_BASE + 0x01d0)
#define		AR9170_PHY_HALFGI_DSC_MAN		0x0007fff0
#define		AR9170_PHY_HALFGI_DSC_MAN_S		4
#define		AR9170_PHY_HALFGI_DSC_EXP		0x0000000f
#define		AR9170_PHY_HALFGI_DSC_EXP_S		0

#define	AR9170_PHY_REG_CHANNEL_MASK_01_30	(AR9170_PHY_REG_BASE + 0x01d4)
#define	AR9170_PHY_REG_CHANNEL_MASK_31_60	(AR9170_PHY_REG_BASE + 0x01d8)

#define	AR9170_PHY_REG_CHAN_INFO_MEMORY		(AR9170_PHY_REG_BASE + 0x01dc)
#define		AR9170_PHY_CHAN_INFO_MEMORY_CAPTURE_MASK	0x0001

#define	AR9170_PHY_REG_HEAVY_CLIP_ENABLE	(AR9170_PHY_REG_BASE + 0x01e0)
#define	AR9170_PHY_REG_HEAVY_CLIP_FACTOR_RIFS	(AR9170_PHY_REG_BASE + 0x01ec)
#define		AR9170_PHY_RIFS_INIT_DELAY		0x03ff0000

#define	AR9170_PHY_REG_CALMODE			(AR9170_PHY_REG_BASE + 0x01f0)
#define		AR9170_PHY_CALMODE_IQ			0x00000000
#define		AR9170_PHY_CALMODE_ADC_GAIN		0x00000001
#define		AR9170_PHY_CALMODE_ADC_DC_PER		0x00000002
#define		AR9170_PHY_CALMODE_ADC_DC_INIT		0x00000003

#define	AR9170_PHY_REG_REFCLKDLY		(AR9170_PHY_REG_BASE + 0x01f4)
#define	AR9170_PHY_REG_REFCLKPD			(AR9170_PHY_REG_BASE + 0x01f8)

#define	AR9170_PHY_REG_CAL_MEAS_0(_i)		(AR9170_PHY_REG_BASE + \
						 0x0410 + ((_i) << 12))
#define	AR9170_PHY_REG_CAL_MEAS_1(_i)		(AR9170_PHY_REG_BASE + \
						 0x0414 \ + ((_i) << 12))
#define	AR9170_PHY_REG_CAL_MEAS_2(_i)		(AR9170_PHY_REG_BASE + \
						 0x0418 + ((_i) << 12))
#define	AR9170_PHY_REG_CAL_MEAS_3(_i)		(AR9170_PHY_REG_BASE + \
						 0x041c + ((_i) << 12))

#define	AR9170_PHY_REG_CURRENT_RSSI		(AR9170_PHY_REG_BASE + 0x041c)

#define	AR9170_PHY_REG_RFBUS_GRANT		(AR9170_PHY_REG_BASE + 0x0420)
#define		AR9170_PHY_RFBUS_GRANT_EN		0x00000001

#define	AR9170_PHY_REG_CHAN_INFO_GAIN_DIFF	(AR9170_PHY_REG_BASE + 0x04f4)
#define		AR9170_PHY_CHAN_INFO_GAIN_DIFF_UPPER_LIMIT	320

#define	AR9170_PHY_REG_CHAN_INFO_GAIN		(AR9170_PHY_REG_BASE + 0x04fc)

#define	AR9170_PHY_REG_MODE			(AR9170_PHY_REG_BASE + 0x0a00)
#define		AR9170_PHY_MODE_ASYNCFIFO		0x80
#define		AR9170_PHY_MODE_AR2133			0x08
#define		AR9170_PHY_MODE_AR5111			0x00
#define		AR9170_PHY_MODE_AR5112			0x08
#define		AR9170_PHY_MODE_DYNAMIC			0x04
#define		AR9170_PHY_MODE_RF2GHZ			0x02
#define		AR9170_PHY_MODE_RF5GHZ			0x00
#define		AR9170_PHY_MODE_CCK			0x01
#define		AR9170_PHY_MODE_OFDM			0x00
#define		AR9170_PHY_MODE_DYN_CCK_DISABLE		0x100

#define	AR9170_PHY_REG_CCK_TX_CTRL		(AR9170_PHY_REG_BASE + 0x0a04)
#define		AR9170_PHY_CCK_TX_CTRL_JAPAN			0x00000010
#define		AR9170_PHY_CCK_TX_CTRL_TX_DAC_SCALE_CCK         0x0000000c
#define		AR9170_PHY_CCK_TX_CTRL_TX_DAC_SCALE_CCK_S       2

#define	AR9170_PHY_REG_CCK_DETECT		(AR9170_PHY_REG_BASE + 0x0a08)
#define		AR9170_PHY_CCK_DETECT_WEAK_SIG_THR_CCK		0x0000003f
#define		AR9170_PHY_CCK_DETECT_WEAK_SIG_THR_CCK_S	0
/* [12:6] settling time for antenna switch */
#define		AR9170_PHY_CCK_DETECT_ANT_SWITCH_TIME		0x00001fc0
#define		AR9170_PHY_CCK_DETECT_ANT_SWITCH_TIME_S		6
#define		AR9170_PHY_CCK_DETECT_BB_ENABLE_ANT_FAST_DIV	0x2000
#define		AR9170_PHY_CCK_DETECT_BB_ENABLE_ANT_FAST_DIV_S	13

#define	AR9170_PHY_REG_GAIN_2GHZ		(AR9170_PHY_REG_BASE + 0x0a0c)
#define	AR9170_PHY_REG_GAIN_2GHZ_CHAIN_2	(AR9170_PHY_REG_BASE + 0x2a0c)
#define		AR9170_PHY_GAIN_2GHZ_RXTX_MARGIN	0x00fc0000
#define		AR9170_PHY_GAIN_2GHZ_RXTX_MARGIN_S	18
#define		AR9170_PHY_GAIN_2GHZ_BSW_MARGIN		0x00003c00
#define		AR9170_PHY_GAIN_2GHZ_BSW_MARGIN_S	10
#define		AR9170_PHY_GAIN_2GHZ_BSW_ATTEN		0x0000001f
#define		AR9170_PHY_GAIN_2GHZ_BSW_ATTEN_S	0
#define		AR9170_PHY_GAIN_2GHZ_XATTEN2_MARGIN	0x003e0000
#define		AR9170_PHY_GAIN_2GHZ_XATTEN2_MARGIN_S	17
#define		AR9170_PHY_GAIN_2GHZ_XATTEN1_MARGIN	0x0001f000
#define		AR9170_PHY_GAIN_2GHZ_XATTEN1_MARGIN_S	12
#define		AR9170_PHY_GAIN_2GHZ_XATTEN2_DB		0x00000fc0
#define		AR9170_PHY_GAIN_2GHZ_XATTEN2_DB_S	6
#define		AR9170_PHY_GAIN_2GHZ_XATTEN1_DB		0x0000003f
#define		AR9170_PHY_GAIN_2GHZ_XATTEN1_DB_S	0

#define	AR9170_PHY_REG_CCK_RXCTRL4		(AR9170_PHY_REG_BASE + 0x0a1c)
#define		AR9170_PHY_CCK_RXCTRL4_FREQ_EST_SHORT	0x01f80000
#define		AR9170_PHY_CCK_RXCTRL4_FREQ_EST_SHORT_S	19

#define	AR9170_PHY_REG_DAG_CTRLCCK		(AR9170_PHY_REG_BASE + 0x0a28)
#define		AR9170_REG_DAG_CTRLCCK_EN_RSSI_THR	0x00000200
#define		AR9170_REG_DAG_CTRLCCK_RSSI_THR		0x0001fc00
#define		AR9170_REG_DAG_CTRLCCK_RSSI_THR_S	10

#define	AR9170_PHY_REG_FORCE_CLKEN_CCK		(AR9170_PHY_REG_BASE + 0x0a2c)
#define		AR9170_FORCE_CLKEN_CCK_MRC_MUX		0x00000040

#define	AR9170_PHY_REG_POWER_TX_RATE3		(AR9170_PHY_REG_BASE + 0x0a34)
#define	AR9170_PHY_REG_POWER_TX_RATE4		(AR9170_PHY_REG_BASE + 0x0a38)

#define	AR9170_PHY_REG_SCRM_SEQ_XR		(AR9170_PHY_REG_BASE + 0x0a3c)
#define	AR9170_PHY_REG_HEADER_DETECT_XR		(AR9170_PHY_REG_BASE + 0x0a40)
#define	AR9170_PHY_REG_CHIRP_DETECTED_XR	(AR9170_PHY_REG_BASE + 0x0a44)
#define	AR9170_PHY_REG_BLUETOOTH		(AR9170_PHY_REG_BASE + 0x0a54)

#define	AR9170_PHY_REG_TPCRG1			(AR9170_PHY_REG_BASE + 0x0a58)
#define		AR9170_PHY_TPCRG1_NUM_PD_GAIN		0x0000c000
#define		AR9170_PHY_TPCRG1_NUM_PD_GAIN_S		14
#define		AR9170_PHY_TPCRG1_PD_GAIN_1		0x00030000
#define		AR9170_PHY_TPCRG1_PD_GAIN_1_S		16
#define		AR9170_PHY_TPCRG1_PD_GAIN_2		0x000c0000
#define		AR9170_PHY_TPCRG1_PD_GAIN_2_S		18
#define		AR9170_PHY_TPCRG1_PD_GAIN_3		0x00300000
#define		AR9170_PHY_TPCRG1_PD_GAIN_3_S		20
#define		AR9170_PHY_TPCRG1_PD_CAL_ENABLE		0x00400000
#define		AR9170_PHY_TPCRG1_PD_CAL_ENABLE_S	22

#define	AR9170_PHY_REG_TX_PWRCTRL4		(AR9170_PHY_REG_BASE + 0x0a64)
#define		AR9170_PHY_TX_PWRCTRL_PD_AVG_VALID	0x00000001
#define		AR9170_PHY_TX_PWRCTRL_PD_AVG_VALID_S	0
#define		AR9170_PHY_TX_PWRCTRL_PD_AVG_OUT	0x000001fe
#define		AR9170_PHY_TX_PWRCTRL_PD_AVG_OUT_S	1

#define	AR9170_PHY_REG_ANALOG_SWAP		(AR9170_PHY_REG_BASE + 0x0a68)
#define		AR9170_PHY_ANALOG_SWAP_AB		0x0001
#define		AR9170_PHY_ANALOG_SWAP_ALT_CHAIN	0x00000040

#define	AR9170_PHY_REG_TPCRG5			(AR9170_PHY_REG_BASE + 0x0a6c)
#define		AR9170_PHY_TPCRG5_PD_GAIN_OVERLAP	0x0000000f
#define		AR9170_PHY_TPCRG5_PD_GAIN_OVERLAP_S	0
#define		AR9170_PHY_TPCRG5_PD_GAIN_BOUNDARY_1	0x000003f0
#define		AR9170_PHY_TPCRG5_PD_GAIN_BOUNDARY_1_S	4
#define		AR9170_PHY_TPCRG5_PD_GAIN_BOUNDARY_2	0x0000fc00
#define		AR9170_PHY_TPCRG5_PD_GAIN_BOUNDARY_2_S	10
#define		AR9170_PHY_TPCRG5_PD_GAIN_BOUNDARY_3    0x003f0000
#define		AR9170_PHY_TPCRG5_PD_GAIN_BOUNDARY_3_S  16
#define		AR9170_PHY_TPCRG5_PD_GAIN_BOUNDARY_4    0x0fc00000
#define		AR9170_PHY_TPCRG5_PD_GAIN_BOUNDARY_4_S  22

#define	AR9170_PHY_REG_TX_PWRCTRL6_0		(AR9170_PHY_REG_BASE + 0x0a70)
#define	AR9170_PHY_REG_TX_PWRCTRL6_1		(AR9170_PHY_REG_BASE + 0x1a70)
#define		AR9170_PHY_TX_PWRCTRL_ERR_EST_MODE	0x03000000
#define		AR9170_PHY_TX_PWRCTRL_ERR_EST_MODE_S	24

#define	AR9170_PHY_REG_TX_PWRCTRL7		(AR9170_PHY_REG_BASE + 0x0a74)
#define		AR9170_PHY_TX_PWRCTRL_INIT_TX_GAIN	0x01f80000
#define		AR9170_PHY_TX_PWRCTRL_INIT_TX_GAIN_S	19

#define	AR9170_PHY_REG_TX_PWRCTRL9		(AR9170_PHY_REG_BASE + 0x0a7c)
#define		AR9170_PHY_TX_DESIRED_SCALE_CCK		0x00007c00
#define		AR9170_PHY_TX_DESIRED_SCALE_CCK_S	10
#define		AR9170_PHY_TX_PWRCTRL9_RES_DC_REMOVAL	0x80000000
#define		AR9170_PHY_TX_PWRCTRL9_RES_DC_REMOVAL_S	31

#define	AR9170_PHY_REG_TX_GAIN_TBL1		(AR9170_PHY_REG_BASE + 0x0b00)
#define		AR9170_PHY_TX_GAIN			0x0007f000
#define		AR9170_PHY_TX_GAIN_S			12

/* Carrier leak calibration control, do it after AGC calibration */
#define	AR9170_PHY_REG_CL_CAL_CTL		(AR9170_PHY_REG_BASE + 0x0b58)
#define		AR9170_PHY_CL_CAL_ENABLE		0x00000002
#define		AR9170_PHY_CL_CAL_PARALLEL_CAL_ENABLE	0x00000001

#define	AR9170_PHY_REG_POWER_TX_RATE5		(AR9170_PHY_REG_BASE + 0x0b8c)
#define	AR9170_PHY_REG_POWER_TX_RATE6		(AR9170_PHY_REG_BASE + 0x0b90)

#define	AR9170_PHY_REG_CH0_TX_PWRCTRL11		(AR9170_PHY_REG_BASE + 0x0b98)
#define	AR9170_PHY_REG_CH1_TX_PWRCTRL11		(AR9170_PHY_REG_BASE + 0x1b98)
#define		AR9170_PHY_TX_CHX_PWRCTRL_OLPC_TEMP_COMP	0x0000fc00
#define		AR9170_PHY_TX_CHX_PWRCTRL_OLPC_TEMP_COMP_S	10

#define	AR9170_PHY_REG_CAL_CHAINMASK		(AR9170_PHY_REG_BASE + 0x0b9c)
#define	AR9170_PHY_REG_VIT_MASK2_M_46_61	(AR9170_PHY_REG_BASE + 0x0ba0)
#define	AR9170_PHY_REG_MASK2_M_31_45		(AR9170_PHY_REG_BASE + 0x0ba4)
#define	AR9170_PHY_REG_MASK2_M_16_30		(AR9170_PHY_REG_BASE + 0x0ba8)
#define	AR9170_PHY_REG_MASK2_M_00_15		(AR9170_PHY_REG_BASE + 0x0bac)
#define	AR9170_PHY_REG_PILOT_MASK_01_30		(AR9170_PHY_REG_BASE + 0x0bb0)
#define	AR9170_PHY_REG_PILOT_MASK_31_60		(AR9170_PHY_REG_BASE + 0x0bb4)
#define	AR9170_PHY_REG_MASK2_P_15_01		(AR9170_PHY_REG_BASE + 0x0bb8)
#define	AR9170_PHY_REG_MASK2_P_30_16		(AR9170_PHY_REG_BASE + 0x0bbc)
#define	AR9170_PHY_REG_MASK2_P_45_31		(AR9170_PHY_REG_BASE + 0x0bc0)
#define	AR9170_PHY_REG_MASK2_P_61_45		(AR9170_PHY_REG_BASE + 0x0bc4)
#define	AR9170_PHY_REG_POWER_TX_SUB		(AR9170_PHY_REG_BASE + 0x0bc8)
#define	AR9170_PHY_REG_POWER_TX_RATE7		(AR9170_PHY_REG_BASE + 0x0bcc)
#define	AR9170_PHY_REG_POWER_TX_RATE8		(AR9170_PHY_REG_BASE + 0x0bd0)
#define	AR9170_PHY_REG_POWER_TX_RATE9		(AR9170_PHY_REG_BASE + 0x0bd4)
#define	AR9170_PHY_REG_XPA_CFG			(AR9170_PHY_REG_BASE + 0x0bd8)
#define		AR9170_PHY_FORCE_XPA_CFG		0x000000001
#define		AR9170_PHY_FORCE_XPA_CFG_S		0

#define	AR9170_PHY_REG_CH1_CCA			(AR9170_PHY_REG_BASE + 0x1064)
#define		AR9170_PHY_CH1_CCA_MIN_PWR		0x0ff80000
#define		AR9170_PHY_CH1_CCA_MIN_PWR_S		19

#define	AR9170_PHY_REG_CH2_CCA			(AR9170_PHY_REG_BASE + 0x2064)
#define		AR9170_PHY_CH2_CCA_MIN_PWR		0x0ff80000
#define		AR9170_PHY_CH2_CCA_MIN_PWR_S		19

#define	AR9170_PHY_REG_CH1_EXT_CCA		(AR9170_PHY_REG_BASE + 0x11bc)
#define		AR9170_PHY_CH1_EXT_CCA_MIN_PWR		0xff800000
#define		AR9170_PHY_CH1_EXT_CCA_MIN_PWR_S	23

#define	AR9170_PHY_REG_CH2_EXT_CCA		(AR9170_PHY_REG_BASE + 0x21bc)
#define		AR9170_PHY_CH2_EXT_CCA_MIN_PWR		0xff800000
#define		AR9170_PHY_CH2_EXT_CCA_MIN_PWR_S	23

#endif	/* __CARL9170_SHARED_PHY_H */
