/*
 * This header provides constants for the reset controller
 * based peripheral powerdown requests on the STMicroelectronics
 * STI8416 SoC.
 */
#ifndef _DT_BINDINGS_RESET_CONTROLLER_STI8416
#define _DT_BINDINGS_RESET_CONTROLLER_STI8416

/* Reset defines */
#define STI8416_FC7_USB3_1_PHY_USB2_CALIB_RESET	0
#define STI8416_FC7_USB3_1_PHY_USB2_RESET	1
#define STI8416_FC7_USB3_1_RESET		2
#define STI8416_FC7_USB2_1_PHY_CALIB_RESET	3
#define STI8416_FC7_USB2_1_PHY_RESET		4
#define STI8416_FC7_USB2_1_RESET		5
#define STI8416_FC7_PCIE_SATA_0_MIPHY_RESET	6
#define STI8416_FC7_SATA_0_PMALIVE_RESET	7
#define STI8416_FC7_SATA_0_RESET		8
#define STI8416_FC7_PCIE_0_RESET		9
#define STI8416_FC7_PCIE_SATA_0_HARDRESET	10
#define STI8416_FC7_PCIE_SATA_1_MIPHY_RESET	11
#define STI8416_FC7_SATA_1_PMALIVE_RESET	12
#define STI8416_FC7_SATA_1_RESET		13
#define STI8416_FC7_PCIE_1_RESET		14
#define STI8416_FC7_PCIE_SATA_1_HARDRESET	15
#define STI8416_FC7_PCIE_2_MIPHY_RESET		16
#define STI8416_FC7_PCIE_2_SOFTRESET		17
#define STI8416_FC7_PCIE_2_HARDRESET		18
#define STI8416_FC7_MEDIALB_RESET		19
#define STI8416_FC8_FP2_SOFTRESET		20
#define STI8416_FC8_GMAC_SOFTRESET		21
#define STI8416_FC11_USB3_1_PHY_USB2_CALIB_RESET	22
#define STI8416_FC11_USB3_1_PHY_USB2_RESET	23
#define STI8416_FC11_USB3_1_RESET		24
#define STI8416_FC11_USB2_1_PHY_CALIB_RESET	25
#define STI8416_FC11_USB2_1_PHY_RESET		26
#define STI8416_FC11_USB2_1_RESET		27
#define STI8416_FC11_FLASH_PHY_RESET		28
#define STI8416_FC11_FLASH_SUBSYSTEM_RESET	29
#define STI8416_FC11_SDEMMC0_PHY_RESET		30
#define STI8416_FC11_SDEMMC0_HARD_RESET		31
#define STI8416_FC11_SDEMMC1_PHY_RESET		32
#define STI8416_FC11_SDEMMC1_HARD_RESET		33
#define STI8416_FC1_IRB_SOFTRESET		34
#define STI8416_FC1_KEYSCAN_SOFTRESET		35
#define STI8416_FC1_UART0_SOFTRESET		36
#define STI8416_FC1_UART1_SOFTRESET		37

/* PowerDown defines */
#define STI8416_FC7_USB3_CLKEN_POWERDOWN	0
#define STI8416_FC7_USB2_CLKEN_POWERDOWN	1
#define STI8416_FC7_SATA_0_CLKEN_POWERDOWN	2
#define STI8416_FC7_PCIE_0_CLKEN_POWERDOWN	3
#define STI8416_FC7_SATA_1_CLKEN_POWERDOWN	4
#define STI8416_FC7_PCIE_1_CLKEN_POWERDOWN	5
#define STI8416_FC7_PCIE_2_CLKEN_POWERDOWN	6
#define STI8416_FC7_MEDIALB_POWERDOWN		7
#define STI8416_FC8_GMAC0_POWERDOWN		8
#define STI8416_FC8_CLKEN_FP2_0_POWERDOWN	9
#define STI8416_FC11_USB3_CLKEN_POWERDOWN	10
#define STI8416_FC11_USB2_CLKEN_POWERDOWN	11
#define STI8416_FC11_FLASH_CLKEN_POWERDOWN	12
#define STI8416_FC11_SDEMMC0_CLKEN_POWERDOWN	13
#define STI8416_FC11_SDEMMC1_CLKEN_POWERDOWN	14

#endif /* _DT_BINDINGS_RESET_CONTROLLER_STI8416 */
