#ifndef __HI_IRQS_H__
#define __HI_IRQS_H__

#define IRQ_LOCALTIMER		(29)
#define HISI_GIC_IRQ_START	(32)

#define INTNR_WATCHDOG		(HISI_GIC_IRQ_START + 0)

#define INTNR_TIMER_0		(HISI_GIC_IRQ_START + 1)	/* 33 */
#define INTNR_TIMER_1		(HISI_GIC_IRQ_START + 1)
#define INTNR_TIMER_2		(HISI_GIC_IRQ_START + 2)	/* 34 */
#define INTNR_TIMER_3		(HISI_GIC_IRQ_START + 2)
#define INTNR_TIMER_4		(HISI_GIC_IRQ_START + 3)	/* 35 */
#define INTNR_TIMER_5		(HISI_GIC_IRQ_START + 3)
#define INTNR_TIMER_6		(HISI_GIC_IRQ_START + 4)	/* 36 */
#define INTNR_TIMER_7		(HISI_GIC_IRQ_START + 4)

#define INTNR_UART0		(HISI_GIC_IRQ_START + 6)	/* 38 */
#define INTNR_UART1		(HISI_GIC_IRQ_START + 7)	/* 39 */
#define INTNR_UART2		(HISI_GIC_IRQ_START + 8)	/* 40 */
#define INTNR_UART3		(HISI_GIC_IRQ_START + 20)	/* 52 */

#define INTNR_I2C0		(HISI_GIC_IRQ_START + 12)	/* 44 */
#define INTNR_I2C1		(HISI_GIC_IRQ_START + 56)	/* 88 */

#define INTNR_COMMTX0		(HISI_GIC_IRQ_START + 23)	/* 55 */
#define INTNR_COMMRX0		(HISI_GIC_IRQ_START + 24)	/* 56 */
#define INTNR_COMMTX1		(HISI_GIC_IRQ_START + 52)	/* 84 */
#define INTNR_COMMRX1		(HISI_GIC_IRQ_START + 53)	/* 85 */

#define INTNR_A9_PMU_INT0	(HISI_GIC_IRQ_START + 25)	/* 57 */
#define INTNR_A9_PMU_INT1	(HISI_GIC_IRQ_START + 54)	/* 86 */

#define INTNR_ETH		(HISI_GIC_IRQ_START + 51)	/* 83 */

#define INTNR_GPIO_0		(HISI_GIC_IRQ_START + 57)	/* 89 */
#define INTNR_GPIO_1		(HISI_GIC_IRQ_START + 57)
#define INTNR_GPIO_2		(HISI_GIC_IRQ_START + 57)
#define INTNR_GPIO_3		(HISI_GIC_IRQ_START + 57)
#define INTNR_GPIO_4		(HISI_GIC_IRQ_START + 57)
#define INTNR_GPIO_5		(HISI_GIC_IRQ_START + 58)	/* 90 */
#define INTNR_GPIO_6		(HISI_GIC_IRQ_START + 58)
#define INTNR_GPIO_7		(HISI_GIC_IRQ_START + 58)
#define INTNR_GPIO_8		(HISI_GIC_IRQ_START + 58)
#define INTNR_GPIO_9		(HISI_GIC_IRQ_START + 58)
#define INTNR_GPIO_10		(HISI_GIC_IRQ_START + 59)	/* 91 */
#define INTNR_GPIO_11		(HISI_GIC_IRQ_START + 59)
#define INTNR_GPIO_12		(HISI_GIC_IRQ_START + 59)
#define INTNR_GPIO_13		(HISI_GIC_IRQ_START + 59)
#define INTNR_GPIO_14		(HISI_GIC_IRQ_START + 59)
#define INTNR_GPIO_15		(HISI_GIC_IRQ_START + 60)	/* 92 */
#define INTNR_GPIO_16		(HISI_GIC_IRQ_START + 60)
#define INTNR_GPIO_17		(HISI_GIC_IRQ_START + 60)
#define INTNR_GPIO_18		(HISI_GIC_IRQ_START + 60)
#define INTNR_GPIO_19		(HISI_GIC_IRQ_START + 60)
#define INTNR_GPIO_20		(HISI_GIC_IRQ_START + 61)	/* 93 */
#define INTNR_GPIO_21		(HISI_GIC_IRQ_START + 61)
#define INTNR_GPIO_22		(HISI_GIC_IRQ_START + 61)

#define INTNR_L2CACHE_CHK0_INT	(HISI_GIC_IRQ_START + 72)
#define INTNR_L2CACHE_CHK1_INT	(HISI_GIC_IRQ_START + 73)
#define INTNR_L2CACHE_INT_COMB	(HISI_GIC_IRQ_START + 74)

#define NR_IRQS			(HISI_GIC_IRQ_START + 128)

#define MAX_GIC_NR		1

#endif /* __HI_IRQS_H__ */
