#ifndef MY_ABC_HERE
#define MY_ABC_HERE
#endif
 
#ifndef _ASMARM_PAGE_H
#define _ASMARM_PAGE_H

#if defined(MY_ABC_HERE) && defined(CONFIG_ARM_PAGE_SIZE_LARGE)
#define PAGE_SHIFT		CONFIG_ARM_PAGE_SIZE_LARGE_SHIFT
#elif defined(MY_DEF_HERE)
#ifdef CONFIG_MV_8KB_SW_PAGE_SIZE_SUPPORT
#define PAGE_SHIFT		13
#define MV_PAGE_SIZE_STR	"8KB SW Page Size"
#elif defined(CONFIG_MV_16KB_SW_PAGE_SIZE_SUPPORT)
#define PAGE_SHIFT		14
#define MV_PAGE_SIZE_STR	"16KB SW Page Size"
#elif defined(CONFIG_MV_32KB_SW_PAGE_SIZE_SUPPORT)
#define PAGE_SHIFT		15
#define MV_PAGE_SIZE_STR	"32KB SW Page Size"
#elif defined(CONFIG_MV_64KB_SW_PAGE_SIZE_SUPPORT)
#define PAGE_SHIFT		16
#define MV_PAGE_SIZE_STR	"64KB SW Page Size"
#elif defined(CONFIG_MV_64KB_MMU_PAGE_SIZE_SUPPORT)
#define PAGE_SHIFT		16
#define MV_PAGE_SIZE_STR	"64KB MMU Page Size"
#else
#define PAGE_SHIFT		12
#endif
#else
#define PAGE_SHIFT		12
#endif
#define PAGE_SIZE		(_AC(1,UL) << PAGE_SHIFT)
#define PAGE_MASK		(~((1 << PAGE_SHIFT) - 1))

#if defined(MY_ABC_HERE)
 
#define HW_PAGE_SHIFT		12
#define HW_PAGE_SIZE		(1 << HW_PAGE_SHIFT)
#define HW_PAGE_MASK		(~(HW_PAGE_SIZE-1))
#define HW_PAGES_PER_PAGE	(1 << (PAGE_SHIFT - HW_PAGE_SHIFT))
#endif  

#ifndef __ASSEMBLY__

#ifndef CONFIG_MMU

#include <asm/page-nommu.h>

#else

#include <asm/glue.h>

#undef _USER
#undef MULTI_USER

#ifdef CONFIG_CPU_COPY_V4WT
# ifdef _USER
#  define MULTI_USER 1
# else
#  define _USER v4wt
# endif
#endif

#ifdef CONFIG_CPU_COPY_V4WB
# ifdef _USER
#  define MULTI_USER 1
# else
#  define _USER v4wb
# endif
#endif

#ifdef CONFIG_CPU_COPY_FEROCEON
# ifdef _USER
#  define MULTI_USER 1
# else
#  define _USER feroceon
# endif
#endif

#ifdef CONFIG_CPU_COPY_FA
# ifdef _USER
#  define MULTI_USER 1
# else
#  define _USER fa
# endif
#endif

#ifdef CONFIG_CPU_SA1100
# ifdef _USER
#  define MULTI_USER 1
# else
#  define _USER v4_mc
# endif
#endif

#ifdef CONFIG_CPU_XSCALE
# ifdef _USER
#  define MULTI_USER 1
# else
#  define _USER xscale_mc
# endif
#endif

#ifdef CONFIG_CPU_XSC3
# ifdef _USER
#  define MULTI_USER 1
# else
#  define _USER xsc3_mc
# endif
#endif

#ifdef CONFIG_CPU_COPY_V6
# define MULTI_USER 1
#endif

#if !defined(_USER) && !defined(MULTI_USER)
#error Unknown user operations model
#endif

struct page;
struct vm_area_struct;

struct cpu_user_fns {
	void (*cpu_clear_user_highpage)(struct page *page, unsigned long vaddr);
	void (*cpu_copy_user_highpage)(struct page *to, struct page *from,
			unsigned long vaddr, struct vm_area_struct *vma);
};

#ifdef MULTI_USER
extern struct cpu_user_fns cpu_user;

#define __cpu_clear_user_highpage	cpu_user.cpu_clear_user_highpage
#define __cpu_copy_user_highpage	cpu_user.cpu_copy_user_highpage

#else

#define __cpu_clear_user_highpage	__glue(_USER,_clear_user_highpage)
#define __cpu_copy_user_highpage	__glue(_USER,_copy_user_highpage)

extern void __cpu_clear_user_highpage(struct page *page, unsigned long vaddr);
extern void __cpu_copy_user_highpage(struct page *to, struct page *from,
			unsigned long vaddr, struct vm_area_struct *vma);
#endif

#define clear_user_highpage(page,vaddr)		\
	 __cpu_clear_user_highpage(page, vaddr)

#define __HAVE_ARCH_COPY_USER_HIGHPAGE
#define copy_user_highpage(to,from,vaddr,vma)	\
	__cpu_copy_user_highpage(to, from, vaddr, vma)

#define clear_page(page)	memset((void *)(page), 0, PAGE_SIZE)
extern void copy_page(void *to, const void *from);

#ifdef CONFIG_KUSER_HELPERS
#define __HAVE_ARCH_GATE_AREA 1
#endif

#ifdef CONFIG_ARM_LPAE
#include <asm/pgtable-3level-types.h>
#else
#include <asm/pgtable-2level-types.h>
#endif

#endif  

typedef struct page *pgtable_t;

#ifdef CONFIG_HAVE_ARCH_PFN_VALID
extern int pfn_valid(unsigned long);
#endif

#include <asm/memory.h>

#endif  

#define VM_DATA_DEFAULT_FLAGS \
	(((current->personality & READ_IMPLIES_EXEC) ? VM_EXEC : 0) | \
	 VM_READ | VM_WRITE | VM_MAYREAD | VM_MAYWRITE | VM_MAYEXEC)

#include <asm-generic/getorder.h>

#endif
