#ifndef MY_ABC_HERE
#define MY_ABC_HERE
#endif
/*
 * linux/fs/hfsplus/xattr.h
 *
 * Vyacheslav Dubeyko <slava@dubeyko.com>
 *
 * Logic of processing extended attributes
 */

#ifndef _LINUX_HFSPLUS_XATTR_H
#define _LINUX_HFSPLUS_XATTR_H

#include <linux/xattr.h>

int __hfsplus_setxattr(struct inode *inode, const char *name,
			const void *value, size_t size, int flags);

static inline int hfsplus_setxattr(struct dentry *dentry, const char *name,
			const void *value, size_t size, int flags)
{
	return __hfsplus_setxattr(dentry->d_inode, name, value, size, flags);
}

ssize_t hfsplus_getxattr(struct dentry *dentry, const char *name,
			void *value, size_t size);

ssize_t hfsplus_listxattr(struct dentry *dentry, char *buffer, size_t size);

#ifdef MY_ABC_HERE
int hfsplus_syno_setxattr(struct dentry *dentry, const char *name, const void *value, size_t size, int flags);
ssize_t hfsplus_syno_getxattr(struct dentry *dentry, const char *name, void *buffer, size_t size);
#endif

int hfsplus_removexattr(struct dentry *dentry, const char *name);

int hfsplus_init_security(struct inode *inode, struct inode *dir,
				const struct qstr *qstr);

static inline int hfsplus_init_acl(struct inode *inode, struct inode *dir)
{
	/*TODO: implement*/
	return 0;
}

static inline int hfsplus_init_inode_security(struct inode *inode,
						struct inode *dir,
						const struct qstr *qstr)
{
	int err;

	err = hfsplus_init_acl(inode, dir);
	if (!err)
		err = hfsplus_init_security(inode, dir, qstr);
	return err;
}

#endif
