#include <linux/synobios.h>

#define CPLD_FAN_SPEED_0		0x0
#define CPLD_FAN_SPEED_1		0x1
#define CPLD_FAN_SPEED_2		0x2
#define CPLD_FAN_SPEED_3		0x3
#define CPLD_FAN_SPEED_4		0x4
#define CPLD_FAN_SPEED_5		0x5
#define CPLD_FAN_SPEED_6		0x6
#define CPLD_FAN_SPEED_7		0x7

// DS2.0 #8126
// These two definitions are for 3-bit fan speed adjust
// The unit for this duration is milli-seconds, ex: 500ms.
#define FAN_ACTIVATION_SPEED    CPLD_FAN_SPEED_6
#define FAN_ACTIVATION_DURATION 500 

/**
 * if you want to add a field to module_t, remember to modify 
 * this macro 
 */
#define MODULE_T_DECLARE(FAN_T,				\
						 RAID_T,			\
						 LED_T,				\
						 THERMAL_T,			\
						 FANCTRL_T,			\
						 AUTO_POWERON_T,	\
						 DUAL_POWER_T,		\
						 USBCOPY_T,			\
						 FAN_NUMBER_T,		\
						 EBOX_TYPE,			\
						 POWER_IN_SEQ,		\
						 RTC_TYPE,			\
						 CPUTMP_T)			\
				   							\
		{										\
			fan_type:			FAN_T,			\
			raid_type:			RAID_T,			\
			led_type:			LED_T,			\
			thermal_type:		THERMAL_T,		\
			fanctrl_type:		FANCTRL_T,		\
			auto_poweron_type:	AUTO_POWERON_T,	\
			dual_power_type:	DUAL_POWER_T,	\
			usbcopy_type:		USBCOPY_T,		\
			fan_number:			FAN_NUMBER_T,	\
			ebox_type:			EBOX_TYPE,		\
			pis_type:			POWER_IN_SEQ,	\
			rtc_type:			RTC_TYPE,		\
			cputmp_type:		CPUTMP_T		\
		}

/**
 * Add a model must also add a define on this. And add the 
 * assign on your own module_type_init in dsxxx.c 
 */
#define	MODULE_T_CS406e		MODULE_T_DECLARE(FAN_CPLD_SPEED_1LEVEL,           RAID_ON,      LED_DISKS,       THERMAL_NO,      FANCTRL_YES,     AUTO_POWERON_NO,      POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_4,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_CS406e,   HW_DS406}
#define	MODULE_T_CS406		MODULE_T_DECLARE(FAN_CPLD_SPEED_1LEVEL,           RAID_ON,      LED_DISKS,       THERMAL_NO,      FANCTRL_YES,     AUTO_POWERON_NO,      POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_4,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_CS406,    HW_DS406}
#define	MODULE_T_RS406		MODULE_T_DECLARE(FAN_CPLD_SPEED_1LEVEL,           RAID_ON,      LED_DISKS,       THERMAL_NO,      FANCTRL_YES,     AUTO_POWERON_NO,      POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_3, EBOX_NOT_SUPPORT, POWER_IN_SEQ_4,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_RS406,    HW_DS406}
#define	MODULE_T_DS107e		MODULE_T_DECLARE(FAN_CPLD_SPEED_2LEVEL,           RAID_OFF,     LED_DISK_ESATA,  THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_NO,      POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS107e,   HW_DS107e}
#define	MODULE_T_DS107v1	MODULE_T_DECLARE(FAN_CPLD_SPEED_2LEVEL,           RAID_OFF,     LED_DISK_ESATA,  THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_NO,      POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS107,    HW_DS107v10}
#define	MODULE_T_DS107v2	MODULE_T_DECLARE(FAN_MICROP_ALERT_FIRM,           RAID_OFF,     LED_DISK_ESATA,  THERMAL_NO,      FANCTRL_NO,      AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS107,    HW_DS107v20}
#define	MODULE_T_DS107v3	MODULE_T_DECLARE(FAN_MICROP_ALERT_SOFT,           RAID_OFF,     LED_DISK_ESATA,  THERMAL_NO,      FANCTRL_NO,      AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS107,    HW_DS107v30}
#define	MODULE_T_DS107pv1	MODULE_T_DECLARE(FAN_CPLD_SPEED_2LEVEL,           RAID_OFF,     LED_DISK_ESATA,  THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_NO,      POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS107mv,  HW_DS107v10}
#define	MODULE_T_DS107pv2	MODULE_T_DECLARE(FAN_MICROP_ALERT_FIRM,           RAID_OFF,     LED_DISK_ESATA,  THERMAL_NO,      FANCTRL_NO,      AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS107mv,  HW_DS107v20}
#define	MODULE_T_DS107pv3	MODULE_T_DECLARE(FAN_MICROP_ALERT_SOFT,           RAID_OFF,     LED_DISK_ESATA,  THERMAL_NO,      FANCTRL_NO,      AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS107mv,  HW_DS107v30}
#define	MODULE_T_DS207		MODULE_T_DECLARE(FAN_CPLD_SPEED_2LEVEL,           RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_NO,      POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_2,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS207,    HW_DS207}
#define	MODULE_T_DS207p		MODULE_T_DECLARE(FAN_CPLD_SPEED_2LEVEL,           RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_NO,      POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_2,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS207mv,  HW_DS207}
#define	MODULE_T_CS407e		MODULE_T_DECLARE(FAN_CPLD_SPEED_2LEVEL,           RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_NO,      POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_4,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_CS407e,   HW_DS407ev10}
#define	MODULE_T_CS407		MODULE_T_DECLARE(FAN_CPLD_SPEED_2LEVEL,           RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_NO,      POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_4,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_CS407,    HW_DS407v10}
#define	MODULE_T_DS108jv1	MODULE_T_DECLARE(FAN_MICROP_ALERT_FIRM,           RAID_OFF,     LED_DISK_ESATA,  THERMAL_NO,      FANCTRL_NO,      AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS108j,   HW_DS108jv10}
#define	MODULE_T_DS108jv2	MODULE_T_DECLARE(FAN_MICROP_ALERT_SOFT,           RAID_OFF,     LED_DISK_ESATA,  THERMAL_NO,      FANCTRL_NO,      AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS108j,   HW_DS108jv20}
#define	MODULE_T_DS408		MODULE_T_DECLARE(FAN_MULTI_EXCEPT_SLEEP,          RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_4,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS408,    HW_DS408}
#define	MODULE_T_RS408		MODULE_T_DECLARE(FAN_CPLD_SPEED_1LEVEL,           RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_3, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_RS408,    HW_RS408}
#define	MODULE_T_RS408rp	MODULE_T_DECLARE(FAN_CPLD_SPEED_1LEVEL,           RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_DUAL,    USBCOPY_NO,      FAN_NUMBER_4, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_RS408rp,  HW_RS408rp}
#define	MODULE_T_DS508		MODULE_T_DECLARE(FAN_MULTI_EXCEPT_SLEEP,          RAID_ON,      LED_DISKS_ALARM, THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_2, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS508,    HW_DS508}
#define	MODULE_T_DS109j		MODULE_T_DECLARE(FAN_MULTI_EXCEPT_SLEEP,          RAID_OFF,     LED_DISK_ESATA,  THERMAL_NO,      FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS109j ,  HW_DS109j}
#define	MODULE_T_DS109p		MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_OFF,     LED_DISK_ESATA,  THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS109p,   HW_DS109p}
#define	MODULE_T_DS110p		MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_OFF,     LED_DISK_ESATA,  THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS110p,   HW_DS110p}
#define	MODULE_T_DS209j		MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_NOT_SUPPORT, POWER_IN_SEQ_2,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS209j ,  HW_DS209j}
#define	MODULE_T_DS209p		MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_2,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS209p,   HW_DS209p}
#define	MODULE_T_DS209pII	MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_2,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS209pII, HW_DS209pII}
#define	MODULE_T_DS409p		MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_2, EBOX_SUPPORT,     POWER_IN_SEQ_4,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS409p,   HW_DS409p}
#define	MODULE_T_RS409p		MODULE_T_DECLARE(FAN_CPLD_SPEED_1LEVEL,           RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_3, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_RS409p,   HW_RS409p}
#define	MODULE_T_RS409rpp	MODULE_T_DECLARE(FAN_CPLD_SPEED_1LEVEL,           RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_DUAL,    USBCOPY_NO,      FAN_NUMBER_4, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_RS409rpp, HW_RS409rpp}
#define	MODULE_T_DS509p		MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS_ALARM, THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_2, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS509p,   HW_DS509p}
#define	MODULE_T_DS109		MODULE_T_DECLARE(FAN_MULTI_EXCEPT_SLEEP,          RAID_OFF,     LED_DISK_ESATA,  THERMAL_NO,      FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS109,    HW_DS109}
#define	MODULE_T_DS209		MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_2,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS209,    HW_DS209}
#define	MODULE_T_DS409slim	MODULE_T_DECLARE(FAN_MULTI_ALWAYS,              RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS409slim,HW_DS409slim}
#define	MODULE_T_DS409		MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_4,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS409,    HW_DS409}
#define	MODULE_T_RS409v1	MODULE_T_DECLARE(FAN_CPLD_SPEED_1LEVEL,           RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_RS409,    HW_RS409}
#define	MODULE_T_RS409v2	MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_SEIKO,   CPUTMP_NO)		//{MODEL_RS409,    HW_RS409}
#define	MODULE_T_DS410j		MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_4,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS410j,   HW_DS410j}
#define	MODULE_T_DS410		MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_NO,      FAN_NUMBER_2, EBOX_SUPPORT,     POWER_IN_SEQ_4,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS410,   HW_DS410}
#define	MODULE_T_DS210jv1	MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_2,   RTC_SEIKO,   CPUTMP_NO)		//{MODEL_DS210j,   HW_DS210j}
#define	MODULE_T_DS210jv2	MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_2,   RTC_SEIKO,   CPUTMP_NO)		//{MODEL_DS210j,   HW_DS210j}
#define	MODULE_T_DS210jv3	MODULE_T_DECLARE(FAN_MULTI_EXCEPT_SLEEP,          RAID_ON,      LED_DISKS,       THERMAL_NO,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_2,   RTC_SEIKO,   CPUTMP_NO)		//{MODEL_DS210j,   HW_DS210j}
#define	MODULE_T_DS210p		MODULE_T_DECLARE(FAN_MULTI_ALWAYS,                RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_2,   RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS210p, HW_DS210p}
#define	MODULE_T_DS110jv1	MODULE_T_DECLARE(FAN_MULTI_EXCEPT_SLEEP,          RAID_OFF,     LED_DISK_ESATA,  THERMAL_NO,      FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_SEIKO,   CPUTMP_NO)		//{MODEL_DS110j,   HW_DS110j}
#define	MODULE_T_DS110jv2	MODULE_T_DECLARE(FAN_MULTI_EXCEPT_SLEEP,          RAID_OFF,     LED_DISK_ESATA,  THERMAL_NO,      FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS110j,   HW_DS110j}
#define	MODULE_T_DS110jv3	MODULE_T_DECLARE(FAN_MULTI_EXCEPT_SLEEP,          RAID_OFF,     LED_DISK_ESATA,  THERMAL_NO,      FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_SEIKO,   CPUTMP_NO)		//{MODEL_DS110j,   HW_DS110j}
#define	MODULE_T_DS710p		MODULE_T_DECLARE(FAN_MICROP_BANDON,               RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,      POWER_IN_SEQ_2,   RTC_BANDON,  CPUTMP_YES)		//{MODEL_DS710p,   HW_DS710p}
#define	MODULE_T_DS1010p	MODULE_T_DECLARE(FAN_MICROP_BANDON,               RAID_ON,      LED_DISKS_ALARM,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,  POWER_SINGLE,  USBCOPY_NO,     FAN_NUMBER_1, EBOX_SUPPORT,    POWER_IN_SEQ_OFF, RTC_BANDON,  CPUTMP_YES)		//{MODEL_DS1010p,  HW_DS1010p}
#define	MODULE_T_DS110		MODULE_T_DECLARE(FAN_MULTI_EXCEPT_SLEEP,          RAID_OFF,     LED_DISK_ESATA,  THERMAL_NO,      FANCTRL_YES,     AUTO_POWERON_YES,     POWER_SINGLE,  USBCOPY_YES,     FAN_NUMBER_1, EBOX_SUPPORT,     POWER_IN_SEQ_OFF, RTC_RICOH,   CPUTMP_NO)		//{MODEL_DS110,    HW_DS110}
#define MODULE_T_DS410p   MODULE_T_DECLARE(FAN_MICROP_BANDON_WITH_CPUFAN,   RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,  POWER_SINGLE,  USBCOPY_NO,     FAN_NUMBER_1, EBOX_SUPPORT,    POWER_IN_SEQ_4, RTC_BANDON, CPUTMP_YES)   //{MODEL_DS410p, HW_DS410p}
#define MODULE_T_RS810p   MODULE_T_DECLARE(FAN_MICROP_BANDON_WITH_CPUFAN,   RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,  POWER_SINGLE,  USBCOPY_NO,     FAN_NUMBER_1, EBOX_SUPPORT,    POWER_IN_SEQ_OFF, RTC_BANDON, CPUTMP_YES)   //{MODEL_RS810p, HW_RS810p}
#define MODULE_T_RS810rpp   MODULE_T_DECLARE(FAN_MICROP_BANDON_WITH_CPUFAN,   RAID_ON,      LED_DISKS,       THERMAL_YES,     FANCTRL_YES,     AUTO_POWERON_YES,  POWER_DUAL,  USBCOPY_NO,     FAN_NUMBER_1, EBOX_SUPPORT,    POWER_IN_SEQ_OFF, RTC_BANDON, CPUTMP_YES)   //{MODEL_RS810rpp, HW_RS810rpp}
#define	MODULE_T_UNKNOWN	MODULE_T_DECLARE(FAN_UNKNOWN,                     RAID_UNKNOWN, LED_UNKNOWN,     THERMAL_UNKNOWN, FANCTRL_UNKNOWN, AUTO_POWERON_UNKNOWN, POWER_UNKNOWN, USBCOPY_UNKNOWN, FAN_NUMBER_X, EBOX_NOT_SUPPORT, POWER_IN_SEQ_OFF, RTC_UNKNOWN, CPUTMP_UNKNOWN)	//{MODEL_INVALID,  NULL}

void module_type_set(module_t *pModule);
module_t *module_type_get(void);

#if SYNO_HAVE_KERNEL_VERSION(2,6,15)
int  GetFanNum(int *pFanNum);
#endif // SYNO_HAVE_KERNEL_VERSION(2,6,15)
int  GetHwCapability(CAPABILITY *pCapability);
int  FanStatusMappingType1(FAN_STATUS status, FAN_SPEED speed, char *pSpeed_value);
int  FanStatusMappingType2(FAN_STATUS status, FAN_SPEED speed, char *pSpeed_value);
