/*
 * stv0900_reg.h
 *
 * Driver for ST STV0900 satellite demodulator IC.
 *
 * Copyright (C) ST Microelectronics.
 * Copyright (C) 2009 NetUP Inc.
 * Copyright (C) 2009 Igor M. Liplianin <liplianin@netup.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef STV0900_REG_H
#define STV0900_REG_H

/*MID*/
#define R0900_MID  0xf100
#define F0900_MCHIP_IDENT  0xf10000f0
#define F0900_MRELEASE  0xf100000f

/*DACR1*/
#define R0900_DACR1  0xf113
#define F0900_DAC_MODE  0xf11300e0
#define F0900_DAC_VALUE1  0xf113000f

/*DACR2*/
#define R0900_DACR2  0xf114
#define F0900_DAC_VALUE0  0xf11400ff

/*OUTCFG*/
#define R0900_OUTCFG  0xf11c
#define F0900_INV_DATA6  0xf11c0080
#define F0900_OUTSERRS1_HZ  0xf11c0040
#define F0900_OUTSERRS2_HZ  0xf11c0020
#define F0900_OUTSERRS3_HZ  0xf11c0010
#define F0900_OUTPARRS3_HZ  0xf11c0008
#define F0900_OUTHZ3_CONTROL  0xf11c0007

/*MODECFG*/
#define R0900_MODECFG  0xf11d
#define F0900_FECSPY_SEL_2  0xf11d0020
#define F0900_HWARE_SEL_2  0xf11d0010
#define F0900_PKTDEL_SEL_2  0xf11d0008
#define F0900_DISEQC_SEL_2  0xf11d0004
#define F0900_VIT_SEL_2  0xf11d0002
#define F0900_DEMOD_SEL_2  0xf11d0001

/*IRQSTATUS3*/
#define R0900_IRQSTATUS3  0xf120
#define F0900_SPLL_LOCK  0xf1200020
#define F0900_SSTREAM_LCK_3  0xf1200010
#define F0900_SSTREAM_LCK_2  0xf1200008
#define F0900_SSTREAM_LCK_1  0xf1200004
#define F0900_SDVBS1_PRF_2  0xf1200002
#define F0900_SDVBS1_PRF_1  0xf1200001

/*IRQSTATUS2*/
#define R0900_IRQSTATUS2  0xf121
#define F0900_SSPY_ENDSIM_3  0xf1210080
#define F0900_SSPY_ENDSIM_2  0xf1210040
#define F0900_SSPY_ENDSIM_1  0xf1210020
#define F0900_SPKTDEL_ERROR_2  0xf1210010
#define F0900_SPKTDEL_LOCKB_2  0xf1210008
#define F0900_SPKTDEL_LOCK_2  0xf1210004
#define F0900_SPKTDEL_ERROR_1  0xf1210002
#define F0900_SPKTDEL_LOCKB_1  0xf1210001

/*IRQSTATUS1*/
#define R0900_IRQSTATUS1  0xf122
#define F0900_SPKTDEL_LOCK_1  0xf1220080
#define F0900_SEXTPINB2  0xf1220040
#define F0900_SEXTPIN2  0xf1220020
#define F0900_SEXTPINB1  0xf1220010
#define F0900_SEXTPIN1  0xf1220008
#define F0900_SDEMOD_LOCKB_2  0xf1220004
#define F0900_SDEMOD_LOCK_2  0xf1220002
#define F0900_SDEMOD_IRQ_2  0xf1220001

/*IRQSTATUS0*/
#define R0900_IRQSTATUS0  0xf123
#define F0900_SDEMOD_LOCKB_1  0xf1230080
#define F0900_SDEMOD_LOCK_1  0xf1230040
#define F0900_SDEMOD_IRQ_1  0xf1230020
#define F0900_SBCH_ERRFLAG  0xf1230010
#define F0900_SDISEQC2RX_IRQ  0xf1230008
#define F0900_SDISEQC2TX_IRQ  0xf1230004
#define F0900_SDISEQC1RX_IRQ  0xf1230002
#define F0900_SDISEQC1TX_IRQ  0xf1230001

/*IRQMASK3*/
#define R0900_IRQMASK3  0xf124
#define F0900_MPLL_LOCK  0xf1240020
#define F0900_MSTREAM_LCK_3  0xf1240010
#define F0900_MSTREAM_LCK_2  0xf1240008
#define F0900_MSTREAM_LCK_1  0xf1240004
#define F0900_MDVBS1_PRF_2  0xf1240002
#define F0900_MDVBS1_PRF_1  0xf1240001

/*IRQMASK2*/
#define R0900_IRQMASK2  0xf125
#define F0900_MSPY_ENDSIM_3  0xf1250080
#define F0900_MSPY_ENDSIM_2  0xf1250040
#define F0900_MSPY_ENDSIM_1  0xf1250020
#define F0900_MPKTDEL_ERROR_2  0xf1250010
#define F0900_MPKTDEL_LOCKB_2  0xf1250008
#define F0900_MPKTDEL_LOCK_2  0xf1250004
#define F0900_MPKTDEL_ERROR_1  0xf1250002
#define F0900_MPKTDEL_LOCKB_1  0xf1250001

/*IRQMASK1*/
#define R0900_IRQMASK1  0xf126
#define F0900_MPKTDEL_LOCK_1  0xf1260080
#define F0900_MEXTPINB2  0xf1260040
#define F0900_MEXTPIN2  0xf1260020
#define F0900_MEXTPINB1  0xf1260010
#define F0900_MEXTPIN1  0xf1260008
#define F0900_MDEMOD_LOCKB_2  0xf1260004
#define F0900_MDEMOD_LOCK_2  0xf1260002
#define F0900_MDEMOD_IRQ_2  0xf1260001

/*IRQMASK0*/
#define R0900_IRQMASK0  0xf127
#define F0900_MDEMOD_LOCKB_1  0xf1270080
#define F0900_MDEMOD_LOCK_1  0xf1270040
#define F0900_MDEMOD_IRQ_1  0xf1270020
#define F0900_MBCH_ERRFLAG  0xf1270010
#define F0900_MDISEQC2RX_IRQ  0xf1270008
#define F0900_MDISEQC2TX_IRQ  0xf1270004
#define F0900_MDISEQC1RX_IRQ  0xf1270002
#define F0900_MDISEQC1TX_IRQ  0xf1270001

/*I2CCFG*/
#define R0900_I2CCFG  0xf129
#define F0900_I2C2_FASTMODE  0xf1290080
#define F0900_STATUS_WR2  0xf1290040
#define F0900_I2C2ADDR_INC  0xf1290030
#define F0900_I2C_FASTMODE  0xf1290008
#define F0900_STATUS_WR  0xf1290004
#define F0900_I2CADDR_INC  0xf1290003

/*P1_I2CRPT*/
#define R0900_P1_I2CRPT  0xf12a
#define F0900_P1_I2CT_ON  0xf12a0080
#define F0900_P1_ENARPT_LEVEL  0xf12a0070
#define F0900_P1_SCLT_DELAY  0xf12a0008
#define F0900_P1_STOP_ENABLE  0xf12a0004
#define F0900_P1_STOP_SDAT2SDA  0xf12a0002

/*P2_I2CRPT*/
#define R0900_P2_I2CRPT  0xf12b
#define F0900_P2_I2CT_ON  0xf12b0080
#define F0900_P2_ENARPT_LEVEL  0xf12b0070
#define F0900_P2_SCLT_DELAY  0xf12b0008
#define F0900_P2_STOP_ENABLE  0xf12b0004
#define F0900_P2_STOP_SDAT2SDA  0xf12b0002

/*CLKI2CFG*/
#define R0900_CLKI2CFG  0xf140
#define F0900_CLKI2_OPD  0xf1400080
#define F0900_CLKI2_CONFIG  0xf140007e
#define F0900_CLKI2_XOR  0xf1400001

/*GPIO1CFG*/
#define R0900_GPIO1CFG  0xf141
#define F0900_GPIO1_OPD  0xf1410080
#define F0900_GPIO1_CONFIG  0xf141007e
#define F0900_GPIO1_XOR  0xf1410001

/*GPIO2CFG*/
#define R0900_GPIO2CFG  0xf142
#define F0900_GPIO2_OPD  0xf1420080
#define F0900_GPIO2_CONFIG  0xf142007e
#define F0900_GPIO2_XOR  0xf1420001

/*GPIO3CFG*/
#define R0900_GPIO3CFG  0xf143
#define F0900_GPIO3_OPD  0xf1430080
#define F0900_GPIO3_CONFIG  0xf143007e
#define F0900_GPIO3_XOR  0xf1430001

/*GPIO4CFG*/
#define R0900_GPIO4CFG  0xf144
#define F0900_GPIO4_OPD  0xf1440080
#define F0900_GPIO4_CONFIG  0xf144007e
#define F0900_GPIO4_XOR  0xf1440001

/*GPIO5CFG*/
#define R0900_GPIO5CFG  0xf145
#define F0900_GPIO5_OPD  0xf1450080
#define F0900_GPIO5_CONFIG  0xf145007e
#define F0900_GPIO5_XOR  0xf1450001

/*GPIO6CFG*/
#define R0900_GPIO6CFG  0xf146
#define F0900_GPIO6_OPD  0xf1460080
#define F0900_GPIO6_CONFIG  0xf146007e
#define F0900_GPIO6_XOR  0xf1460001

/*GPIO7CFG*/
#define R0900_GPIO7CFG  0xf147
#define F0900_GPIO7_OPD  0xf1470080
#define F0900_GPIO7_CONFIG  0xf147007e
#define F0900_GPIO7_XOR  0xf1470001

/*GPIO8CFG*/
#define R0900_GPIO8CFG  0xf148
#define F0900_GPIO8_OPD  0xf1480080
#define F0900_GPIO8_CONFIG  0xf148007e
#define F0900_GPIO8_XOR  0xf1480001

/*GPIO9CFG*/
#define R0900_GPIO9CFG  0xf149
#define F0900_GPIO9_OPD  0xf1490080
#define F0900_GPIO9_CONFIG  0xf149007e
#define F0900_GPIO9_XOR  0xf1490001

/*GPIO10CFG*/
#define R0900_GPIO10CFG  0xf14a
#define F0900_GPIO10_OPD  0xf14a0080
#define F0900_GPIO10_CONFIG  0xf14a007e
#define F0900_GPIO10_XOR  0xf14a0001

/*GPIO11CFG*/
#define R0900_GPIO11CFG  0xf14b
#define F0900_GPIO11_OPD  0xf14b0080
#define F0900_GPIO11_CONFIG  0xf14b007e
#define F0900_GPIO11_XOR  0xf14b0001

/*GPIO12CFG*/
#define R0900_GPIO12CFG  0xf14c
#define F0900_GPIO12_OPD  0xf14c0080
#define F0900_GPIO12_CONFIG  0xf14c007e
#define F0900_GPIO12_XOR  0xf14c0001

/*GPIO13CFG*/
#define R0900_GPIO13CFG  0xf14d
#define F0900_GPIO13_OPD  0xf14d0080
#define F0900_GPIO13_CONFIG  0xf14d007e
#define F0900_GPIO13_XOR  0xf14d0001

/*CS0CFG*/
#define R0900_CS0CFG  0xf14e
#define F0900_CS0_OPD  0xf14e0080
#define F0900_CS0_CONFIG  0xf14e007e
#define F0900_CS0_XOR  0xf14e0001

/*CS1CFG*/
#define R0900_CS1CFG  0xf14f
#define F0900_CS1_OPD  0xf14f0080
#define F0900_CS1_CONFIG  0xf14f007e
#define F0900_CS1_XOR  0xf14f0001

/*STDBYCFG*/
#define R0900_STDBYCFG  0xf150
#define F0900_STDBY_OPD  0xf1500080
#define F0900_STDBY_CONFIG  0xf150007e
#define F0900_STBDY_XOR  0xf1500001

/*DIRCLKCFG*/
#define R0900_DIRCLKCFG  0xf151
#define F0900_DIRCLK_OPD  0xf1510080
#define F0900_DIRCLK_CONFIG  0xf151007e
#define F0900_DIRCLK_XOR  0xf1510001

/*AGCRF1CFG*/
#define R0900_AGCRF1CFG  0xf152
#define F0900_AGCRF1_OPD  0xf1520080
#define F0900_AGCRF1_CONFIG  0xf152007e
#define F0900_AGCRF1_XOR  0xf1520001

/*SDAT1CFG*/
#define R0900_SDAT1CFG  0xf153
#define F0900_SDAT1_OPD  0xf1530080
#define F0900_SDAT1_CONFIG  0xf153007e
#define F0900_SDAT1_XOR  0xf1530001

/*SCLT1CFG*/
#define R0900_SCLT1CFG  0xf154
#define F0900_SCLT1_OPD  0xf1540080
#define F0900_SCLT1_CONFIG  0xf154007e
#define F0900_SCLT1_XOR  0xf1540001

/*DISEQCO1CFG*/
#define R0900_DISEQCO1CFG  0xf155
#define F0900_DISEQCO1_OPD  0xf1550080
#define F0900_DISEQCO1_CONFIG  0xf155007e
#define F0900_DISEQC1_XOR  0xf1550001

/*AGCRF2CFG*/
#define R0900_AGCRF2CFG  0xf156
#define F0900_AGCRF2_OPD  0xf1560080
#define F0900_AGCRF2_CONFIG  0xf156007e
#define F0900_AGCRF2_XOR  0xf1560001

/*SDAT2CFG*/
#define R0900_SDAT2CFG  0xf157
#define F0900_SDAT2_OPD  0xf1570080
#define F0900_SDAT2_CONFIG  0xf157007e
#define F0900_SDAT2_XOR  0xf1570001

/*SCLT2CFG*/
#define R0900_SCLT2CFG  0xf158
#define F0900_SCLT2_OPD  0xf1580080
#define F0900_SCLT2_CONFIG  0xf158007e
#define F0900_SCLT2_XOR  0xf1580001

/*DISEQCO2CFG*/
#define R0900_DISEQCO2CFG  0xf159
#define F0900_DISEQCO2_OPD  0xf1590080
#define F0900_DISEQCO2_CONFIG  0xf159007e
#define F0900_DISEQC2_XOR  0xf1590001

/*CLKOUT27CFG*/
#define R0900_CLKOUT27CFG  0xf15a
#define F0900_CLKOUT27_OPD  0xf15a0080
#define F0900_CLKOUT27_CONFIG  0xf15a007e
#define F0900_CLKOUT27_XOR  0xf15a0001

/*ERROR1CFG*/
#define R0900_ERROR1CFG  0xf15b
#define F0900_ERROR1_OPD  0xf15b0080
#define F0900_ERROR1_CONFIG  0xf15b007e
#define F0900_ERROR1_XOR  0xf15b0001

/*DPN1CFG*/
#define R0900_DPN1CFG  0xf15c
#define F0900_DPN1_OPD  0xf15c0080
#define F0900_DPN1_CONFIG  0xf15c007e
#define F0900_DPN1_XOR  0xf15c0001

/*STROUT1CFG*/
#define R0900_STROUT1CFG  0xf15d
#define F0900_STROUT1_OPD  0xf15d0080
#define F0900_STROUT1_CONFIG  0xf15d007e
#define F0900_STROUT1_XOR  0xf15d0001

/*CLKOUT1CFG*/
#define R0900_CLKOUT1CFG  0xf15e
#define F0900_CLKOUT1_OPD  0xf15e0080
#define F0900_CLKOUT1_CONFIG  0xf15e007e
#define F0900_CLKOUT1_XOR  0xf15e0001

/*DATA71CFG*/
#define R0900_DATA71CFG  0xf15f
#define F0900_DATA71_OPD  0xf15f0080
#define F0900_DATA71_CONFIG  0xf15f007e
#define F0900_DATA71_XOR  0xf15f0001

/*ERROR2CFG*/
#define R0900_ERROR2CFG  0xf160
#define F0900_ERROR2_OPD  0xf1600080
#define F0900_ERROR2_CONFIG  0xf160007e
#define F0900_ERROR2_XOR  0xf1600001

/*DPN2CFG*/
#define R0900_DPN2CFG  0xf161
#define F0900_DPN2_OPD  0xf1610080
#define F0900_DPN2_CONFIG  0xf161007e
#define F0900_DPN2_XOR  0xf1610001

/*STROUT2CFG*/
#define R0900_STROUT2CFG  0xf162
#define F0900_STROUT2_OPD  0xf1620080
#define F0900_STROUT2_CONFIG  0xf162007e
#define F0900_STROUT2_XOR  0xf1620001

/*CLKOUT2CFG*/
#define R0900_CLKOUT2CFG  0xf163
#define F0900_CLKOUT2_OPD  0xf1630080
#define F0900_CLKOUT2_CONFIG  0xf163007e
#define F0900_CLKOUT2_XOR  0xf1630001

/*DATA72CFG*/
#define R0900_DATA72CFG  0xf164
#define F0900_DATA72_OPD  0xf1640080
#define F0900_DATA72_CONFIG  0xf164007e
#define F0900_DATA72_XOR  0xf1640001

/*ERROR3CFG*/
#define R0900_ERROR3CFG  0xf165
#define F0900_ERROR3_OPD  0xf1650080
#define F0900_ERROR3_CONFIG  0xf165007e
#define F0900_ERROR3_XOR  0xf1650001

/*DPN3CFG*/
#define R0900_DPN3CFG  0xf166
#define F0900_DPN3_OPD  0xf1660080
#define F0900_DPN3_CONFIG  0xf166007e
#define F0900_DPN3_XOR  0xf1660001

/*STROUT3CFG*/
#define R0900_STROUT3CFG  0xf167
#define F0900_STROUT3_OPD  0xf1670080
#define F0900_STROUT3_CONFIG  0xf167007e
#define F0900_STROUT3_XOR  0xf1670001

/*CLKOUT3CFG*/
#define R0900_CLKOUT3CFG  0xf168
#define F0900_CLKOUT3_OPD  0xf1680080
#define F0900_CLKOUT3_CONFIG  0xf168007e
#define F0900_CLKOUT3_XOR  0xf1680001

/*DATA73CFG*/
#define R0900_DATA73CFG  0xf169
#define F0900_DATA73_OPD  0xf1690080
#define F0900_DATA73_CONFIG  0xf169007e
#define F0900_DATA73_XOR  0xf1690001

/*FSKTFC2*/
#define R0900_FSKTFC2  0xf170
#define F0900_FSKT_KMOD  0xf17000fc
#define F0900_FSKT_CAR2  0xf1700003

/*FSKTFC1*/
#define R0900_FSKTFC1  0xf171
#define F0900_FSKT_CAR1  0xf17100ff

/*FSKTFC0*/
#define R0900_FSKTFC0  0xf172
#define F0900_FSKT_CAR0  0xf17200ff

/*FSKTDELTAF1*/
#define R0900_FSKTDELTAF1  0xf173
#define F0900_FSKT_DELTAF1  0xf173000f

/*FSKTDELTAF0*/
#define R0900_FSKTDELTAF0  0xf174
#define F0900_FSKT_DELTAF0  0xf17400ff

/*FSKTCTRL*/
#define R0900_FSKTCTRL  0xf175
#define F0900_FSKT_EN_SGN  0xf1750040
#define F0900_FSKT_MOD_SGN  0xf1750020
#define F0900_FSKT_MOD_EN  0xf175001c
#define F0900_FSKT_DACMODE  0xf1750003

/*FSKRFC2*/
#define R0900_FSKRFC2  0xf176
#define F0900_FSKR_DETSGN  0xf1760040
#define F0900_FSKR_OUTSGN  0xf1760020
#define F0900_FSKR_KAGC  0xf176001c
#define F0900_FSKR_CAR2  0xf1760003

/*FSKRFC1*/
#define R0900_FSKRFC1  0xf177
#define F0900_FSKR_CAR1  0xf17700ff

/*FSKRFC0*/
#define R0900_FSKRFC0  0xf178
#define F0900_FSKR_CAR0  0xf17800ff

/*FSKRK1*/
#define R0900_FSKRK1  0xf179
#define F0900_FSKR_K1_EXP  0xf17900e0
#define F0900_FSKR_K1_MANT  0xf179001f

/*FSKRK2*/
#define R0900_FSKRK2  0xf17a
#define F0900_FSKR_K2_EXP  0xf17a00e0
#define F0900_FSKR_K2_MANT  0xf17a001f

/*FSKRAGCR*/
#define R0900_FSKRAGCR  0xf17b
#define F0900_FSKR_OUTCTL  0xf17b00c0
#define F0900_FSKR_AGC_REF  0xf17b003f

/*FSKRAGC*/
#define R0900_FSKRAGC  0xf17c
#define F0900_FSKR_AGC_ACCU  0xf17c00ff

/*FSKRALPHA*/
#define R0900_FSKRALPHA  0xf17d
#define F0900_FSKR_ALPHA_EXP  0xf17d001c
#define F0900_FSKR_ALPHA_M  0xf17d0003

/*FSKRPLTH1*/
#define R0900_FSKRPLTH1  0xf17e
#define F0900_FSKR_BETA  0xf17e00f0
#define F0900_FSKR_PLL_TRESH1  0xf17e000f

/*FSKRPLTH0*/
#define R0900_FSKRPLTH0  0xf17f
#define F0900_FSKR_PLL_TRESH0  0xf17f00ff

/*FSKRDF1*/
#define R0900_FSKRDF1  0xf180
#define F0900_FSKR_OUT  0xf1800080
#define F0900_FSKR_DELTAF1  0xf180001f

/*FSKRDF0*/
#define R0900_FSKRDF0  0xf181
#define F0900_FSKR_DELTAF0  0xf18100ff

/*FSKRSTEPP*/
#define R0900_FSKRSTEPP  0xf182
#define F0900_FSKR_STEP_PLUS  0xf18200ff

/*FSKRSTEPM*/
#define R0900_FSKRSTEPM  0xf183
#define F0900_FSKR_STEP_MINUS  0xf18300ff

/*FSKRDET1*/
#define R0900_FSKRDET1  0xf184
#define F0900_FSKR_DETECT  0xf1840080
#define F0900_FSKR_CARDET_ACCU1  0xf184000f

/*FSKRDET0*/
#define R0900_FSKRDET0  0xf185
#define F0900_FSKR_CARDET_ACCU0  0xf18500ff

/*FSKRDTH1*/
#define R0900_FSKRDTH1  0xf186
#define F0900_FSKR_CARLOSS_THRESH1  0xf18600f0
#define F0900_FSKR_CARDET_THRESH1  0xf186000f

/*FSKRDTH0*/
#define R0900_FSKRDTH0  0xf187
#define F0900_FSKR_CARDET_THRESH0  0xf18700ff

/*FSKRLOSS*/
#define R0900_FSKRLOSS  0xf188
#define F0900_FSKR_CARLOSS_THRESH0  0xf18800ff

/*P2_DISTXCTL*/
#define R0900_P2_DISTXCTL  0xf190
#define F0900_P2_TIM_OFF  0xf1900080
#define F0900_P2_DISEQC_RESET  0xf1900040
#define F0900_P2_TIM_CMD  0xf1900030
#define F0900_P2_DIS_PRECHARGE  0xf1900008
#define F0900_P2_DISTX_MODE  0xf1900007

/*P2_DISRXCTL*/
#define R0900_P2_DISRXCTL  0xf191
#define F0900_P2_RECEIVER_ON  0xf1910080
#define F0900_P2_IGNO_SHORT22K  0xf1910040
#define F0900_P2_ONECHIP_TRX  0xf1910020
#define F0900_P2_EXT_ENVELOP  0xf1910010
#define F0900_P2_PIN_SELECT  0xf191000c
#define F0900_P2_IRQ_RXEND  0xf1910002
#define F0900_P2_IRQ_4NBYTES  0xf1910001

/*P2_DISRX_ST0*/
#define R0900_P2_DISRX_ST0  0xf194
#define F0900_P2_RX_END  0xf1940080
#define F0900_P2_RX_ACTIVE  0xf1940040
#define F0900_P2_SHORT_22KHZ  0xf1940020
#define F0900_P2_CONT_TONE  0xf1940010
#define F0900_P2_FIFO_4BREADY  0xf1940008
#define F0900_P2_FIFO_EMPTY  0xf1940004
#define F0900_P2_ABORT_DISRX  0xf1940001

/*P2_DISRX_ST1*/
#define R0900_P2_DISRX_ST1  0xf195
#define F0900_P2_RX_FAIL  0xf1950080
#define F0900_P2_FIFO_PARITYFAIL  0xf1950040
#define F0900_P2_RX_NONBYTE  0xf1950020
#define F0900_P2_FIFO_OVERFLOW  0xf1950010
#define F0900_P2_FIFO_BYTENBR  0xf195000f

/*P2_DISRXDATA*/
#define R0900_P2_DISRXDATA  0xf196
#define F0900_P2_DISRX_DATA  0xf19600ff

/*P2_DISTXDATA*/
#define R0900_P2_DISTXDATA  0xf197
#define F0900_P2_DISEQC_FIFO  0xf19700ff

/*P2_DISTXSTATUS*/
#define R0900_P2_DISTXSTATUS  0xf198
#define F0900_P2_TX_FAIL  0xf1980080
#define F0900_P2_FIFO_FULL  0xf1980040
#define F0900_P2_TX_IDLE  0xf1980020
#define F0900_P2_GAP_BURST  0xf1980010
#define F0900_P2_TXFIFO_BYTES  0xf198000f

/*P2_F22TX*/
#define R0900_P2_F22TX  0xf199
#define F0900_P2_F22_REG  0xf19900ff

/*P2_F22RX*/
#define R0900_P2_F22RX  0xf19a
#define F0900_P2_F22RX_REG  0xf19a00ff

/*P2_ACRPRESC*/
#define R0900_P2_ACRPRESC  0xf19c
#define F0900_P2_ACR_CODFRDY  0xf19c0008
#define F0900_P2_ACR_PRESC  0xf19c0007

/*P2_ACRDIV*/
#define R0900_P2_ACRDIV  0xf19d
#define F0900_P2_ACR_DIV  0xf19d00ff

/*P1_DISTXCTL*/
#define R0900_P1_DISTXCTL  0xf1a0
#define F0900_P1_TIM_OFF  0xf1a00080
#define F0900_P1_DISEQC_RESET  0xf1a00040
#define F0900_P1_TIM_CMD  0xf1a00030
#define F0900_P1_DIS_PRECHARGE  0xf1a00008
#define F0900_P1_DISTX_MODE  0xf1a00007

/*P1_DISRXCTL*/
#define R0900_P1_DISRXCTL  0xf1a1
#define F0900_P1_RECEIVER_ON  0xf1a10080
#define F0900_P1_IGNO_SHORT22K  0xf1a10040
#define F0900_P1_ONECHIP_TRX  0xf1a10020
#define F0900_P1_EXT_ENVELOP  0xf1a10010
#define F0900_P1_PIN_SELECT  0xf1a1000c
#define F0900_P1_IRQ_RXEND  0xf1a10002
#define F0900_P1_IRQ_4NBYTES  0xf1a10001

/*P1_DISRX_ST0*/
#define R0900_P1_DISRX_ST0  0xf1a4
#define F0900_P1_RX_END  0xf1a40080
#define F0900_P1_RX_ACTIVE  0xf1a40040
#define F0900_P1_SHORT_22KHZ  0xf1a40020
#define F0900_P1_CONT_TONE  0xf1a40010
#define F0900_P1_FIFO_4BREADY  0xf1a40008
#define F0900_P1_FIFO_EMPTY  0xf1a40004
#define F0900_P1_ABORT_DISRX  0xf1a40001

/*P1_DISRX_ST1*/
#define R0900_P1_DISRX_ST1  0xf1a5
#define F0900_P1_RX_FAIL  0xf1a50080
#define F0900_P1_FIFO_PARITYFAIL  0xf1a50040
#define F0900_P1_RX_NONBYTE  0xf1a50020
#define F0900_P1_FIFO_OVERFLOW  0xf1a50010
#define F0900_P1_FIFO_BYTENBR  0xf1a5000f

/*P1_DISRXDATA*/
#define R0900_P1_DISRXDATA  0xf1a6
#define F0900_P1_DISRX_DATA  0xf1a600ff

/*P1_DISTXDATA*/
#define R0900_P1_DISTXDATA  0xf1a7
#define F0900_P1_DISEQC_FIFO  0xf1a700ff

/*P1_DISTXSTATUS*/
#define R0900_P1_DISTXSTATUS  0xf1a8
#define F0900_P1_TX_FAIL  0xf1a80080
#define F0900_P1_FIFO_FULL  0xf1a80040
#define F0900_P1_TX_IDLE  0xf1a80020
#define F0900_P1_GAP_BURST  0xf1a80010
#define F0900_P1_TXFIFO_BYTES  0xf1a8000f

/*P1_F22TX*/
#define R0900_P1_F22TX  0xf1a9
#define F0900_P1_F22_REG  0xf1a900ff

/*P1_F22RX*/
#define R0900_P1_F22RX  0xf1aa
#define F0900_P1_F22RX_REG  0xf1aa00ff

/*P1_ACRPRESC*/
#define R0900_P1_ACRPRESC  0xf1ac
#define F0900_P1_ACR_CODFRDY  0xf1ac0008
#define F0900_P1_ACR_PRESC  0xf1ac0007

/*P1_ACRDIV*/
#define R0900_P1_ACRDIV  0xf1ad
#define F0900_P1_ACR_DIV  0xf1ad00ff

/*NCOARSE*/
#define R0900_NCOARSE  0xf1b3
#define F0900_M_DIV  0xf1b300ff

/*SYNTCTRL*/
#define R0900_SYNTCTRL  0xf1b6
#define F0900_STANDBY  0xf1b60080
#define F0900_BYPASSPLLCORE  0xf1b60040
#define F0900_SELX1RATIO  0xf1b60020
#define F0900_I2C_TUD  0xf1b60010
#define F0900_STOP_PLL  0xf1b60008
#define F0900_BYPASSPLLFSK  0xf1b60004
#define F0900_SELOSCI  0xf1b60002
#define F0900_BYPASSPLLADC  0xf1b60001

/*FILTCTRL*/
#define R0900_FILTCTRL  0xf1b7
#define F0900_INV_CLK135  0xf1b70080
#define F0900_PERM_BYPDIS  0xf1b70040
#define F0900_SEL_FSKCKDIV  0xf1b70004
#define F0900_INV_CLKFSK  0xf1b70002
#define F0900_BYPASS_APPLI  0xf1b70001

/*PLLSTAT*/
#define R0900_PLLSTAT  0xf1b8
#define F0900_ACM_SEL  0xf1b80080
#define F0900_DTV_SEL  0xf1b80040
#define F0900_PLLLOCK  0xf1b80001

/*STOPCLK1*/
#define R0900_STOPCLK1  0xf1c2
#define F0900_STOP_CLKPKDT2  0xf1c20040
#define F0900_STOP_CLKPKDT1  0xf1c20020
#define F0900_STOP_CLKFEC  0xf1c20010
#define F0900_STOP_CLKADCI2  0xf1c20008
#define F0900_INV_CLKADCI2  0xf1c20004
#define F0900_STOP_CLKADCI1  0xf1c20002
#define F0900_INV_CLKADCI1  0xf1c20001

/*STOPCLK2*/
#define R0900_STOPCLK2  0xf1c3
#define F0900_STOP_CLKSAMP2  0xf1c30010
#define F0900_STOP_CLKSAMP1  0xf1c30008
#define F0900_STOP_CLKVIT2  0xf1c30004
#define F0900_STOP_CLKVIT1  0xf1c30002
#define F0900_STOP_CLKTS  0xf1c30001

/*TSTTNR0*/
#define R0900_TSTTNR0  0xf1df
#define F0900_SEL_FSK  0xf1df0080
#define F0900_FSK_PON  0xf1df0004
#define F0900_FSK_OPENLOOP  0xf1df0002

/*TSTTNR1*/
#define R0900_TSTTNR1  0xf1e0
#define F0900_BYPASS_ADC1  0xf1e00080
#define F0900_INVADC1_CKOUT  0xf1e00040
#define F0900_SELIQSRC1  0xf1e00030
#define F0900_ADC1_PON  0xf1e00002
#define F0900_ADC1_INMODE  0xf1e00001

/*TSTTNR2*/
#define R0900_TSTTNR2  0xf1e1
#define F0900_DISEQC1_PON  0xf1e10020
#define F0900_DISEQC1_TEST  0xf1e1001f

/*TSTTNR3*/
#define R0900_TSTTNR3  0xf1e2
#define F0900_BYPASS_ADC2  0xf1e20080
#define F0900_INVADC2_CKOUT  0xf1e20040
#define F0900_SELIQSRC2  0xf1e20030
#define F0900_ADC2_PON  0xf1e20002
#define F0900_ADC2_INMODE  0xf1e20001

/*TSTTNR4*/
#define R0900_TSTTNR4  0xf1e3
#define F0900_DISEQC2_PON  0xf1e30020
#define F0900_DISEQC2_TEST  0xf1e3001f

/*P2_IQCONST*/
#define R0900_P2_IQCONST  0xf200
#define F0900_P2_CONSTEL_SELECT  0xf2000060
#define F0900_P2_IQSYMB_SEL  0xf200001f

/*P2_NOSCFG*/
#define R0900_P2_NOSCFG  0xf201
#define F0900_P2_DUMMYPL_NOSDATA  0xf2010020
#define F0900_P2_NOSPLH_BETA  0xf2010018
#define F0900_P2_NOSDATA_BETA  0xf2010007

/*P2_ISYMB*/
#define R0900_P2_ISYMB  0xf202
#define F0900_P2_I_SYMBOL  0xf20201ff

/*P2_QSYMB*/
#define R0900_P2_QSYMB  0xf203
#define F0900_P2_Q_SYMBOL  0xf20301ff

/*P2_AGC1CFG*/
#define R0900_P2_AGC1CFG  0xf204
#define F0900_P2_DC_FROZEN  0xf2040080
#define F0900_P2_DC_CORRECT  0xf2040040
#define F0900_P2_AMM_FROZEN  0xf2040020
#define F0900_P2_AMM_CORRECT  0xf2040010
#define F0900_P2_QUAD_FROZEN  0xf2040008
#define F0900_P2_QUAD_CORRECT  0xf2040004
#define F0900_P2_DCCOMP_SLOW  0xf2040002
#define F0900_P2_IQMISM_SLOW  0xf2040001

/*P2_AGC1CN*/
#define R0900_P2_AGC1CN  0xf206
#define F0900_P2_AGC1_LOCKED  0xf2060080
#define F0900_P2_AGC1_OVERFLOW  0xf2060040
#define F0900_P2_AGC1_NOSLOWLK  0xf2060020
#define F0900_P2_AGC1_MINPOWER  0xf2060010
#define F0900_P2_AGCOUT_FAST  0xf2060008
#define F0900_P2_AGCIQ_BETA  0xf2060007

/*P2_AGC1REF*/
#define R0900_P2_AGC1REF  0xf207
#define F0900_P2_AGCIQ_REF  0xf20700ff

/*P2_IDCCOMP*/
#define R0900_P2_IDCCOMP  0xf208
#define F0900_P2_IAVERAGE_ADJ  0xf20801ff

/*P2_QDCCOMP*/
#define R0900_P2_QDCCOMP  0xf209
#define F0900_P2_QAVERAGE_ADJ  0xf20901ff

/*P2_POWERI*/
#define R0900_P2_POWERI  0xf20a
#define F0900_P2_POWER_I  0xf20a00ff

/*P2_POWERQ*/
#define R0900_P2_POWERQ  0xf20b
#define F0900_P2_POWER_Q  0xf20b00ff

/*P2_AGC1AMM*/
#define R0900_P2_AGC1AMM  0xf20c
#define F0900_P2_AMM_VALUE  0xf20c00ff

/*P2_AGC1QUAD*/
#define R0900_P2_AGC1QUAD  0xf20d
#define F0900_P2_QUAD_VALUE  0xf20d01ff

/*P2_AGCIQIN1*/
#define R0900_P2_AGCIQIN1  0xf20e
#define F0900_P2_AGCIQ_VALUE1  0xf20e00ff

/*P2_AGCIQIN0*/
#define R0900_P2_AGCIQIN0  0xf20f
#define F0900_P2_AGCIQ_VALUE0  0xf20f00ff

/*P2_DEMOD*/
#define R0900_P2_DEMOD  0xf210
#define F0900_P2_DEMOD_STOP  0xf2100040
#define F0900_P2_SPECINV_CONTROL  0xf2100030
#define F0900_P2_FORCE_ENASAMP  0xf2100008
#define F0900_P2_MANUAL_ROLLOFF  0xf2100004
#define F0900_P2_ROLLOFF_CONTROL  0xf2100003

/*P2_DMDMODCOD*/
#define R0900_P2_DMDMODCOD  0xf211
#define F0900_P2_MANUAL_MODCOD  0xf2110080
#define F0900_P2_DEMOD_MODCOD  0xf211007c
#define F0900_P2_DEMOD_TYPE  0xf2110003

/*P2_DSTATUS*/
#define R0900_P2_DSTATUS  0xf212
#define F0900_P2_CAR_LOCK  0xf2120080
#define F0900_P2_TMGLOCK_QUALITY  0xf2120060
#define F0900_P2_SDVBS1_ENABLE  0xf2120010
#define F0900_P2_LOCK_DEFINITIF  0xf2120008
#define F0900_P2_TIMING_IS_LOCKED  0xf2120004
#define F0900_P2_COARSE_TMGLOCK  0xf2120002
#define F0900_P2_COARSE_CARLOCK  0xf2120001

/*P2_DSTATUS2*/
#define R0900_P2_DSTATUS2  0xf213
#define F0900_P2_DEMOD_DELOCK  0xf2130080
#define F0900_P2_DEMOD_TIMEOUT  0xf2130040
#define F0900_P2_MODCODRQ_SYNCTAG  0xf2130020
#define F0900_P2_POLYPH_SATEVENT  0xf2130010
#define F0900_P2_AGC1_NOSIGNALACK  0xf2130008
#define F0900_P2_AGC2_OVERFLOW  0xf2130004
#define F0900_P2_CFR_OVERFLOW  0xf2130002
#define F0900_P2_GAMMA_OVERUNDER  0xf2130001

/*P2_DMDCFGMD*/
#define R0900_P2_DMDCFGMD  0xf214
#define F0900_P2_DVBS2_ENABLE  0xf2140080
#define F0900_P2_DVBS1_ENABLE  0xf2140040
#define F0900_P2_CFR_AUTOSCAN  0xf2140020
#define F0900_P2_SCAN_ENABLE  0xf2140010
#define F0900_P2_TUN_AUTOSCAN  0xf2140008
#define F0900_P2_NOFORCE_RELOCK  0xf2140004
#define F0900_P2_TUN_RNG  0xf2140003

/*P2_DMDCFG2*/
#define R0900_P2_DMDCFG2  0xf215
#define F0900_P2_AGC1_WAITLOCK  0xf2150080
#define F0900_P2_S1S2_SEQUENTIAL  0xf2150040
#define F0900_P2_OVERFLOW_TIMEOUT  0xf2150020
#define F0900_P2_SCANFAIL_TIMEOUT  0xf2150010
#define F0900_P2_DMDTOUT_BACK  0xf2150008
#define F0900_P2_CARLOCK_S1ENABLE  0xf2150004
#define F0900_P2_COARSE_LK3MODE  0xf2150002
#define F0900_P2_COARSE_LK2MODE  0xf2150001

/*P2_DMDISTATE*/
#define R0900_P2_DMDISTATE  0xf216
#define F0900_P2_I2C_NORESETDMODE  0xf2160080
#define F0900_P2_FORCE_ETAPED  0xf2160040
#define F0900_P2_SDMDRST_DIRCLK  0xf2160020
#define F0900_P2_I2C_DEMOD_MODE  0xf216001f

/*P2_DMDT0M*/
#define R0900_P2_DMDT0M  0xf217
#define F0900_P2_DMDT0_MIN  0xf21700ff

/*P2_DMDSTATE*/
#define R0900_P2_DMDSTATE  0xf21b
#define F0900_P2_DEMOD_LOCKED  0xf21b0080
#define F0900_P2_HEADER_MODE  0xf21b0060
#define F0900_P2_DEMOD_MODE  0xf21b001f

/*P2_DMDFLYW*/
#define R0900_P2_DMDFLYW  0xf21c
#define F0900_P2_I2C_IRQVAL  0xf21c00f0
#define F0900_P2_FLYWHEEL_CPT  0xf21c000f

/*P2_DSTATUS3*/
#define R0900_P2_DSTATUS3  0xf21d
#define F0900_P2_CFR_ZIGZAG  0xf21d0080
#define F0900_P2_DEMOD_CFGMODE  0xf21d0060
#define F0900_P2_GAMMA_LOWBAUDRATE  0xf21d0010
#define F0900_P2_RELOCK_MODE  0xf21d0008
#define F0900_P2_DEMOD_FAIL  0xf21d0004
#define F0900_P2_ETAPE1A_DVBXMEM  0xf21d0003

/*P2_DMDCFG3*/
#define R0900_P2_DMDCFG3  0xf21e
#define F0900_P2_DVBS1_TMGWAIT  0xf21e0080
#define F0900_P2_NO_BWCENTERING  0xf21e0040
#define F0900_P2_INV_SEQSRCH  0xf21e0020
#define F0900_P2_DIS_SFRUPLOW_TRK  0xf21e0010
#define F0900_P2_NOSTOP_FIFOFULL  0xf21e0008
#define F0900_P2_LOCKTIME_MODE  0xf21e0007

/*P2_DMDCFG4*/
#define R0900_P2_DMDCFG4  0xf21f
#define F0900_P2_TUNER_NRELAUNCH  0xf21f0008
#define F0900_P2_DIS_CLKENABLE  0xf21f0004
#define F0900_P2_DIS_HDRDIVLOCK  0xf21f0002
#define F0900_P2_NO_TNRWBINIT  0xf21f0001

/*P2_CORRELMANT*/
#define R0900_P2_CORRELMANT  0xf220
#define F0900_P2_CORREL_MANT  0xf22000ff

/*P2_CORRELABS*/
#define R0900_P2_CORRELABS  0xf221
#define F0900_P2_CORREL_ABS  0xf22100ff

/*P2_CORRELEXP*/
#define R0900_P2_CORRELEXP  0xf222
#define F0900_P2_CORREL_ABSEXP  0xf22200f0
#define F0900_P2_CORREL_EXP  0xf222000f

/*P2_PLHMODCOD*/
#define R0900_P2_PLHMODCOD  0xf224
#define F0900_P2_SPECINV_DEMOD  0xf2240080
#define F0900_P2_PLH_MODCOD  0xf224007c
#define F0900_P2_PLH_TYPE  0xf2240003

/*P2_AGCK32*/
#define R0900_P2_AGCK32  0xf22b
#define F0900_P2_R3ADJOFF_32APSK  0xf22b0080
#define F0900_P2_R2ADJOFF_32APSK  0xf22b0040
#define F0900_P2_R1ADJOFF_32APSK  0xf22b0020
#define F0900_P2_RADJ_32APSK  0xf22b001f

/*P2_AGC2O*/
#define R0900_P2_AGC2O  0xf22c
#define F0900_P2_AGC2REF_ADJUSTING  0xf22c0080
#define F0900_P2_AGC2_COARSEFAST  0xf22c0040
#define F0900_P2_AGC2_LKSQRT  0xf22c0020
#define F0900_P2_AGC2_LKMODE  0xf22c0010
#define F0900_P2_AGC2_LKEQUA  0xf22c0008
#define F0900_P2_AGC2_COEF  0xf22c0007

/*P2_AGC2REF*/
#define R0900_P2_AGC2REF  0xf22d
#define F0900_P2_AGC2_REF  0xf22d00ff

/*P2_AGC1ADJ*/
#define R0900_P2_AGC1ADJ  0xf22e
#define F0900_P2_AGC1ADJ_MANUAL  0xf22e0080
#define F0900_P2_AGC1_ADJUSTED  0xf22e017f

/*P2_AGC2I1*/
#define R0900_P2_AGC2I1  0xf236
#define F0900_P2_AGC2_INTEGRATOR1  0xf23600ff

/*P2_AGC2I0*/
#define R0900_P2_AGC2I0  0xf237
#define F0900_P2_AGC2_INTEGRATOR0  0xf23700ff

/*P2_CARCFG*/
#define R0900_P2_CARCFG  0xf238
#define F0900_P2_CFRUPLOW_AUTO  0xf2380080
#define F0900_P2_CFRUPLOW_TEST  0xf2380040
#define F0900_P2_EN_CAR2CENTER  0xf2380020
#define F0900_P2_CARHDR_NODIV8  0xf2380010
#define F0900_P2_I2C_ROTA  0xf2380008
#define F0900_P2_ROTAON  0xf2380004
#define F0900_P2_PH_DET_ALGO  0xf2380003

/*P2_ACLC*/
#define R0900_P2_ACLC  0xf239
#define F0900_P2_STOP_S2ALPHA  0xf23900c0
#define F0900_P2_CAR_ALPHA_MANT  0xf2390030
#define F0900_P2_CAR_ALPHA_EXP  0xf239000f

/*P2_BCLC*/
#define R0900_P2_BCLC  0xf23a
#define F0900_P2_STOP_S2BETA  0xf23a00c0
#define F0900_P2_CAR_BETA_MANT  0xf23a0030
#define F0900_P2_CAR_BETA_EXP  0xf23a000f

/*P2_CARFREQ*/
#define R0900_P2_CARFREQ  0xf23d
#define F0900_P2_KC_COARSE_EXP  0xf23d00f0
#define F0900_P2_BETA_FREQ  0xf23d000f

/*P2_CARHDR*/
#define R0900_P2_CARHDR  0xf23e
#define F0900_P2_K_FREQ_HDR  0xf23e00ff

/*P2_LDT*/
#define R0900_P2_LDT  0xf23f
#define F0900_P2_CARLOCK_THRES  0xf23f01ff

/*P2_LDT2*/
#define R0900_P2_LDT2  0xf240
#define F0900_P2_CARLOCK_THRES2  0xf24001ff

/*P2_CFRICFG*/
#define R0900_P2_CFRICFG  0xf241
#define F0900_P2_CFRINIT_UNVALRNG  0xf2410080
#define F0900_P2_CFRINIT_LUNVALCPT  0xf2410040
#define F0900_P2_CFRINIT_ABORTDBL  0xf2410020
#define F0900_P2_CFRINIT_ABORTPRED  0xf2410010
#define F0900_P2_CFRINIT_UNVALSKIP  0xf2410008
#define F0900_P2_CFRINIT_CSTINC  0xf2410004
#define F0900_P2_NEG_CFRSTEP  0xf2410001

/*P2_CFRUP1*/
#define R0900_P2_CFRUP1  0xf242
#define F0900_P2_CFR_UP1  0xf24201ff

/*P2_CFRUP0*/
#define R0900_P2_CFRUP0  0xf243
#define F0900_P2_CFR_UP0  0xf24300ff

/*P2_CFRLOW1*/
#define R0900_P2_CFRLOW1  0xf246
#define F0900_P2_CFR_LOW1  0xf24601ff

/*P2_CFRLOW0*/
#define R0900_P2_CFRLOW0  0xf247
#define F0900_P2_CFR_LOW0  0xf24700ff

/*P2_CFRINIT1*/
#define R0900_P2_CFRINIT1  0xf248
#define F0900_P2_CFR_INIT1  0xf24801ff

/*P2_CFRINIT0*/
#define R0900_P2_CFRINIT0  0xf249
#define F0900_P2_CFR_INIT0  0xf24900ff

/*P2_CFRINC1*/
#define R0900_P2_CFRINC1  0xf24a
#define F0900_P2_MANUAL_CFRINC  0xf24a0080
#define F0900_P2_CFR_INC1  0xf24a017f

/*P2_CFRINC0*/
#define R0900_P2_CFRINC0  0xf24b
#define F0900_P2_CFR_INC0  0xf24b00f0

/*P2_CFR2*/
#define R0900_P2_CFR2  0xf24c
#define F0900_P2_CAR_FREQ2  0xf24c01ff

/*P2_CFR1*/
#define R0900_P2_CFR1  0xf24d
#define F0900_P2_CAR_FREQ1  0xf24d00ff

/*P2_CFR0*/
#define R0900_P2_CFR0  0xf24e
#define F0900_P2_CAR_FREQ0  0xf24e00ff

/*P2_LDI*/
#define R0900_P2_LDI  0xf24f
#define F0900_P2_LOCK_DET_INTEGR  0xf24f01ff

/*P2_TMGCFG*/
#define R0900_P2_TMGCFG  0xf250
#define F0900_P2_TMGLOCK_BETA  0xf25000c0
#define F0900_P2_NOTMG_GROUPDELAY  0xf2500020
#define F0900_P2_DO_TIMING_CORR  0xf2500010
#define F0900_P2_MANUAL_SCAN  0xf250000c
#define F0900_P2_TMG_MINFREQ  0xf2500003

/*P2_RTC*/
#define R0900_P2_RTC  0xf251
#define F0900_P2_TMGALPHA_EXP  0xf25100f0
#define F0900_P2_TMGBETA_EXP  0xf251000f

/*P2_RTCS2*/
#define R0900_P2_RTCS2  0xf252
#define F0900_P2_TMGALPHAS2_EXP  0xf25200f0
#define F0900_P2_TMGBETAS2_EXP  0xf252000f

/*P2_TMGTHRISE*/
#define R0900_P2_TMGTHRISE  0xf253
#define F0900_P2_TMGLOCK_THRISE  0xf25300ff

/*P2_TMGTHFALL*/
#define R0900_P2_TMGTHFALL  0xf254
#define F0900_P2_TMGLOCK_THFALL  0xf25400ff

/*P2_SFRUPRATIO*/
#define R0900_P2_SFRUPRATIO  0xf255
#define F0900_P2_SFR_UPRATIO  0xf25500ff

/*P2_SFRLOWRATIO*/
#define R0900_P2_SFRLOWRATIO  0xf256
#define F0900_P2_SFR_LOWRATIO  0xf25600ff

/*P2_KREFTMG*/
#define R0900_P2_KREFTMG  0xf258
#define F0900_P2_KREF_TMG  0xf25800ff

/*P2_SFRSTEP*/
#define R0900_P2_SFRSTEP  0xf259
#define F0900_P2_SFR_SCANSTEP  0xf25900f0
#define F0900_P2_SFR_CENTERSTEP  0xf259000f

/*P2_TMGCFG2*/
#define R0900_P2_TMGCFG2  0xf25a
#define F0900_P2_DIS_AUTOSAMP  0xf25a0008
#define F0900_P2_SCANINIT_QUART  0xf25a0004
#define F0900_P2_NOTMG_DVBS1DERAT  0xf25a0002
#define F0900_P2_SFRRATIO_FINE  0xf25a0001

/*P2_SFRINIT1*/
#define R0900_P2_SFRINIT1  0xf25e
#define F0900_P2_SFR_INIT1  0xf25e00ff

/*P2_SFRINIT0*/
#define R0900_P2_SFRINIT0  0xf25f
#define F0900_P2_SFR_INIT0  0xf25f00ff

/*P2_SFRUP1*/
#define R0900_P2_SFRUP1  0xf260
#define F0900_P2_AUTO_GUP  0xf2600080
#define F0900_P2_SYMB_FREQ_UP1  0xf260007f

/*P2_SFRUP0*/
#define R0900_P2_SFRUP0  0xf261
#define F0900_P2_SYMB_FREQ_UP0  0xf26100ff

/*P2_SFRLOW1*/
#define R0900_P2_SFRLOW1  0xf262
#define F0900_P2_AUTO_GLOW  0xf2620080
#define F0900_P2_SYMB_FREQ_LOW1  0xf262007f

/*P2_SFRLOW0*/
#define R0900_P2_SFRLOW0  0xf263
#define F0900_P2_SYMB_FREQ_LOW0  0xf26300ff

/*P2_SFR3*/
#define R0900_P2_SFR3  0xf264
#define F0900_P2_SYMB_FREQ3  0xf26400ff

/*P2_SFR2*/
#define R0900_P2_SFR2  0xf265
#define F0900_P2_SYMB_FREQ2  0xf26500ff

/*P2_SFR1*/
#define R0900_P2_SFR1  0xf266
#define F0900_P2_SYMB_FREQ1  0xf26600ff

/*P2_SFR0*/
#define R0900_P2_SFR0  0xf267
#define F0900_P2_SYMB_FREQ0  0xf26700ff

/*P2_TMGREG2*/
#define R0900_P2_TMGREG2  0xf268
#define F0900_P2_TMGREG2  0xf26800ff

/*P2_TMGREG1*/
#define R0900_P2_TMGREG1  0xf269
#define F0900_P2_TMGREG1  0xf26900ff

/*P2_TMGREG0*/
#define R0900_P2_TMGREG0  0xf26a
#define F0900_P2_TMGREG0  0xf26a00ff

/*P2_TMGLOCK1*/
#define R0900_P2_TMGLOCK1  0xf26b
#define F0900_P2_TMGLOCK_LEVEL1  0xf26b01ff

/*P2_TMGLOCK0*/
#define R0900_P2_TMGLOCK0  0xf26c
#define F0900_P2_TMGLOCK_LEVEL0  0xf26c00ff

/*P2_TMGOBS*/
#define R0900_P2_TMGOBS  0xf26d
#define F0900_P2_ROLLOFF_STATUS  0xf26d00c0
#define F0900_P2_SCAN_SIGN  0xf26d0030
#define F0900_P2_TMG_SCANNING  0xf26d0008
#define F0900_P2_CHCENTERING_MODE  0xf26d0004
#define F0900_P2_TMG_SCANFAIL  0xf26d0002

/*P2_EQUALCFG*/
#define R0900_P2_EQUALCFG  0xf26f
#define F0900_P2_NOTMG_NEGALWAIT  0xf26f0080
#define F0900_P2_EQUAL_ON  0xf26f0040
#define F0900_P2_SEL_EQUALCOR  0xf26f0038
#define F0900_P2_MU_EQUALDFE  0xf26f0007

/*P2_EQUAI1*/
#define R0900_P2_EQUAI1  0xf270
#define F0900_P2_EQUA_ACCI1  0xf27001ff

/*P2_EQUAQ1*/
#define R0900_P2_EQUAQ1  0xf271
#define F0900_P2_EQUA_ACCQ1  0xf27101ff

/*P2_EQUAI2*/
#define R0900_P2_EQUAI2  0xf272
#define F0900_P2_EQUA_ACCI2  0xf27201ff

/*P2_EQUAQ2*/
#define R0900_P2_EQUAQ2  0xf273
#define F0900_P2_EQUA_ACCQ2  0xf27301ff

/*P2_EQUAI3*/
#define R0900_P2_EQUAI3  0xf274
#define F0900_P2_EQUA_ACCI3  0xf27401ff

/*P2_EQUAQ3*/
#define R0900_P2_EQUAQ3  0xf275
#define F0900_P2_EQUA_ACCQ3  0xf27501ff

/*P2_EQUAI4*/
#define R0900_P2_EQUAI4  0xf276
#define F0900_P2_EQUA_ACCI4  0xf27601ff

/*P2_EQUAQ4*/
#define R0900_P2_EQUAQ4  0xf277
#define F0900_P2_EQUA_ACCQ4  0xf27701ff

/*P2_EQUAI5*/
#define R0900_P2_EQUAI5  0xf278
#define F0900_P2_EQUA_ACCI5  0xf27801ff

/*P2_EQUAQ5*/
#define R0900_P2_EQUAQ5  0xf279
#define F0900_P2_EQUA_ACCQ5  0xf27901ff

/*P2_EQUAI6*/
#define R0900_P2_EQUAI6  0xf27a
#define F0900_P2_EQUA_ACCI6  0xf27a01ff

/*P2_EQUAQ6*/
#define R0900_P2_EQUAQ6  0xf27b
#define F0900_P2_EQUA_ACCQ6  0xf27b01ff

/*P2_EQUAI7*/
#define R0900_P2_EQUAI7  0xf27c
#define F0900_P2_EQUA_ACCI7  0xf27c01ff

/*P2_EQUAQ7*/
#define R0900_P2_EQUAQ7  0xf27d
#define F0900_P2_EQUA_ACCQ7  0xf27d01ff

/*P2_EQUAI8*/
#define R0900_P2_EQUAI8  0xf27e
#define F0900_P2_EQUA_ACCI8  0xf27e01ff

/*P2_EQUAQ8*/
#define R0900_P2_EQUAQ8  0xf27f
#define F0900_P2_EQUA_ACCQ8  0xf27f01ff

/*P2_NNOSDATAT1*/
#define R0900_P2_NNOSDATAT1  0xf280
#define F0900_P2_NOSDATAT_NORMED1  0xf28000ff

/*P2_NNOSDATAT0*/
#define R0900_P2_NNOSDATAT0  0xf281
#define F0900_P2_NOSDATAT_NORMED0  0xf28100ff

/*P2_NNOSDATA1*/
#define R0900_P2_NNOSDATA1  0xf282
#define F0900_P2_NOSDATA_NORMED1  0xf28200ff

/*P2_NNOSDATA0*/
#define R0900_P2_NNOSDATA0  0xf283
#define F0900_P2_NOSDATA_NORMED0  0xf28300ff

/*P2_NNOSPLHT1*/
#define R0900_P2_NNOSPLHT1  0xf284
#define F0900_P2_NOSPLHT_NORMED1  0xf28400ff

/*P2_NNOSPLHT0*/
#define R0900_P2_NNOSPLHT0  0xf285
#define F0900_P2_NOSPLHT_NORMED0  0xf28500ff

/*P2_NNOSPLH1*/
#define R0900_P2_NNOSPLH1  0xf286
#define F0900_P2_NOSPLH_NORMED1  0xf28600ff

/*P2_NNOSPLH0*/
#define R0900_P2_NNOSPLH0  0xf287
#define F0900_P2_NOSPLH_NORMED0  0xf28700ff

/*P2_NOSDATAT1*/
#define R0900_P2_NOSDATAT1  0xf288
#define F0900_P2_NOSDATAT_UNNORMED1  0xf28800ff

/*P2_NOSDATAT0*/
#define R0900_P2_NOSDATAT0  0xf289
#define F0900_P2_NOSDATAT_UNNORMED0  0xf28900ff

/*P2_NOSDATA1*/
#define R0900_P2_NOSDATA1  0xf28a
#define F0900_P2_NOSDATA_UNNORMED1  0xf28a00ff

/*P2_NOSDATA0*/
#define R0900_P2_NOSDATA0  0xf28b
#define F0900_P2_NOSDATA_UNNORMED0  0xf28b00ff

/*P2_NOSPLHT1*/
#define R0900_P2_NOSPLHT1  0xf28c
#define F0900_P2_NOSPLHT_UNNORMED1  0xf28c00ff

/*P2_NOSPLHT0*/
#define R0900_P2_NOSPLHT0  0xf28d
#define F0900_P2_NOSPLHT_UNNORMED0  0xf28d00ff

/*P2_NOSPLH1*/
#define R0900_P2_NOSPLH1  0xf28e
#define F0900_P2_NOSPLH_UNNORMED1  0xf28e00ff

/*P2_NOSPLH0*/
#define R0900_P2_NOSPLH0  0xf28f
#define F0900_P2_NOSPLH_UNNORMED0  0xf28f00ff

/*P2_CAR2CFG*/
#define R0900_P2_CAR2CFG  0xf290
#define F0900_P2_DESCRAMB_OFF  0xf2900080
#define F0900_P2_PN4_SELECT  0xf2900040
#define F0900_P2_CFR2_STOPDVBS1  0xf2900020
#define F0900_P2_STOP_CFR2UPDATE  0xf2900010
#define F0900_P2_STOP_NCO2UPDATE  0xf2900008
#define F0900_P2_ROTA2ON  0xf2900004
#define F0900_P2_PH_DET_ALGO2  0xf2900003

/*P2_ACLC2*/
#define R0900_P2_ACLC2  0xf291
#define F0900_P2_CAR2_PUNCT_ADERAT  0xf2910040
#define F0900_P2_CAR2_ALPHA_MANT  0xf2910030
#define F0900_P2_CAR2_ALPHA_EXP  0xf291000f

/*P2_BCLC2*/
#define R0900_P2_BCLC2  0xf292
#define F0900_P2_DVBS2_NIP  0xf2920080
#define F0900_P2_CAR2_PUNCT_BDERAT  0xf2920040
#define F0900_P2_CAR2_BETA_MANT  0xf2920030
#define F0900_P2_CAR2_BETA_EXP  0xf292000f

/*P2_CFR22*/
#define R0900_P2_CFR22  0xf293
#define F0900_P2_CAR2_FREQ2  0xf29301ff

/*P2_CFR21*/
#define R0900_P2_CFR21  0xf294
#define F0900_P2_CAR2_FREQ1  0xf29400ff

/*P2_CFR20*/
#define R0900_P2_CFR20  0xf295
#define F0900_P2_CAR2_FREQ0  0xf29500ff

/*P2_ACLC2S2Q*/
#define R0900_P2_ACLC2S2Q  0xf297
#define F0900_P2_ENAB_SPSKSYMB  0xf2970080
#define F0900_P2_CAR2S2_QADERAT  0xf2970040
#define F0900_P2_CAR2S2_Q_ALPH_M  0xf2970030
#define F0900_P2_CAR2S2_Q_ALPH_E  0xf297000f

/*P2_ACLC2S28*/
#define R0900_P2_ACLC2S28  0xf298
#define F0900_P2_OLDI3Q_MODE  0xf2980080
#define F0900_P2_CAR2S2_8ADERAT  0xf2980040
#define F0900_P2_CAR2S2_8_ALPH_M  0xf2980030
#define F0900_P2_CAR2S2_8_ALPH_E  0xf298000f

/*P2_ACLC2S216A*/
#define R0900_P2_ACLC2S216A  0xf299
#define F0900_P2_CAR2S2_16ADERAT  0xf2990040
#define F0900_P2_CAR2S2_16A_ALPH_M  0xf2990030
#define F0900_P2_CAR2S2_16A_ALPH_E  0xf299000f

/*P2_ACLC2S232A*/
#define R0900_P2_ACLC2S232A  0xf29a
#define F0900_P2_CAR2S2_32ADERAT  0xf29a0040
#define F0900_P2_CAR2S2_32A_ALPH_M  0xf29a0030
#define F0900_P2_CAR2S2_32A_ALPH_E  0xf29a000f

/*P2_BCLC2S2Q*/
#define R0900_P2_BCLC2S2Q  0xf29c
#define F0900_P2_DVBS2S2Q_NIP  0xf29c0080
#define F0900_P2_CAR2S2_QBDERAT  0xf29c0040
#define F0900_P2_CAR2S2_Q_BETA_M  0xf29c0030
#define F0900_P2_CAR2S2_Q_BETA_E  0xf29c000f

/*P2_BCLC2S28*/
#define R0900_P2_BCLC2S28  0xf29d
#define F0900_P2_DVBS2S28_NIP  0xf29d0080
#define F0900_P2_CAR2S2_8BDERAT  0xf29d0040
#define F0900_P2_CAR2S2_8_BETA_M  0xf29d0030
#define F0900_P2_CAR2S2_8_BETA_E  0xf29d000f

/*P2_BCLC2S216A*/
#define R0900_P2_BCLC2S216A  0xf29e
#define F0900_P2_DVBS2S216A_NIP  0xf29e0080
#define F0900_P2_CAR2S2_16BDERAT  0xf29e0040
#define F0900_P2_CAR2S2_16A_BETA_M  0xf29e0030
#define F0900_P2_CAR2S2_16A_BETA_E  0xf29e000f

/*P2_BCLC2S232A*/
#define R0900_P2_BCLC2S232A  0xf29f
#define F0900_P2_DVBS2S232A_NIP  0xf29f0080
#define F0900_P2_CAR2S2_32BDERAT  0xf29f0040
#define F0900_P2_CAR2S2_32A_BETA_M  0xf29f0030
#define F0900_P2_CAR2S2_32A_BETA_E  0xf29f000f

/*P2_PLROOT2*/
#define R0900_P2_PLROOT2  0xf2ac
#define F0900_P2_SHORTFR_DISABLE  0xf2ac0080
#define F0900_P2_LONGFR_DISABLE  0xf2ac0040
#define F0900_P2_DUMMYPL_DISABLE  0xf2ac0020
#define F0900_P2_SHORTFR_AVOID  0xf2ac0010
#define F0900_P2_PLSCRAMB_MODE  0xf2ac000c
#define F0900_P2_PLSCRAMB_ROOT2  0xf2ac0003

/*P2_PLROOT1*/
#define R0900_P2_PLROOT1  0xf2ad
#define F0900_P2_PLSCRAMB_ROOT1  0xf2ad00ff

/*P2_PLROOT0*/
#define R0900_P2_PLROOT0  0xf2ae
#define F0900_P2_PLSCRAMB_ROOT0  0xf2ae00ff

/*P2_MODCODLST0*/
#define R0900_P2_MODCODLST0  0xf2b0
#define F0900_P2_EN_TOKEN31  0xf2b00080
#define F0900_P2_SYNCTAG_SELECT  0xf2b00040
#define F0900_P2_MODCODRQ_MODE  0xf2b00030

/*P2_MODCODLST1*/
#define R0900_P2_MODCODLST1  0xf2b1
#define F0900_P2_DIS_MODCOD29  0xf2b100f0
#define F0900_P2_DIS_32PSK_9_10  0xf2b1000f

/*P2_MODCODLST2*/
#define R0900_P2_MODCODLST2  0xf2b2
#define F0900_P2_DIS_32PSK_8_9  0xf2b200f0
#define F0900_P2_DIS_32PSK_5_6  0xf2b2000f

/*P2_MODCODLST3*/
#define R0900_P2_MODCODLST3  0xf2b3
#define F0900_P2_DIS_32PSK_4_5  0xf2b300f0
#define F0900_P2_DIS_32PSK_3_4  0xf2b3000f

/*P2_MODCODLST4*/
#define R0900_P2_MODCODLST4  0xf2b4
#define F0900_P2_DIS_16PSK_9_10  0xf2b400f0
#define F0900_P2_DIS_16PSK_8_9  0xf2b4000f

/*P2_MODCODLST5*/
#define R0900_P2_MODCODLST5  0xf2b5
#define F0900_P2_DIS_16PSK_5_6  0xf2b500f0
#define F0900_P2_DIS_16PSK_4_5  0xf2b5000f

/*P2_MODCODLST6*/
#define R0900_P2_MODCODLST6  0xf2b6
#define F0900_P2_DIS_16PSK_3_4  0xf2b600f0
#define F0900_P2_DIS_16PSK_2_3  0xf2b6000f

/*P2_MODCODLST7*/
#define R0900_P2_MODCODLST7  0xf2b7
#define F0900_P2_DIS_8P_9_10  0xf2b700f0
#define F0900_P2_DIS_8P_8_9  0xf2b7000f

/*P2_MODCODLST8*/
#define R0900_P2_MODCODLST8  0xf2b8
#define F0900_P2_DIS_8P_5_6  0xf2b800f0
#define F0900_P2_DIS_8P_3_4  0xf2b8000f

/*P2_MODCODLST9*/
#define R0900_P2_MODCODLST9  0xf2b9
#define F0900_P2_DIS_8P_2_3  0xf2b900f0
#define F0900_P2_DIS_8P_3_5  0xf2b9000f

/*P2_MODCODLSTA*/
#define R0900_P2_MODCODLSTA  0xf2ba
#define F0900_P2_DIS_QP_9_10  0xf2ba00f0
#define F0900_P2_DIS_QP_8_9  0xf2ba000f

/*P2_MODCODLSTB*/
#define R0900_P2_MODCODLSTB  0xf2bb
#define F0900_P2_DIS_QP_5_6  0xf2bb00f0
#define F0900_P2_DIS_QP_4_5  0xf2bb000f

/*P2_MODCODLSTC*/
#define R0900_P2_MODCODLSTC  0xf2bc
#define F0900_P2_DIS_QP_3_4  0xf2bc00f0
#define F0900_P2_DIS_QP_2_3  0xf2bc000f

/*P2_MODCODLSTD*/
#define R0900_P2_MODCODLSTD  0xf2bd
#define F0900_P2_DIS_QP_3_5  0xf2bd00f0
#define F0900_P2_DIS_QP_1_2  0xf2bd000f

/*P2_MODCODLSTE*/
#define R0900_P2_MODCODLSTE  0xf2be
#define F0900_P2_DIS_QP_2_5  0xf2be00f0
#define F0900_P2_DIS_QP_1_3  0xf2be000f

/*P2_MODCODLSTF*/
#define R0900_P2_MODCODLSTF  0xf2bf
#define F0900_P2_DIS_QP_1_4  0xf2bf00f0
#define F0900_P2_DDEMOD_SET  0xf2bf0002
#define F0900_P2_DDEMOD_MASK  0xf2bf0001

/*P2_DMDRESCFG*/
#define R0900_P2_DMDRESCFG  0xf2c6
#define F0900_P2_DMDRES_RESET  0xf2c60080
#define F0900_P2_DMDRES_NOISESQR  0xf2c60010
#define F0900_P2_DMDRES_STRALL  0xf2c60008
#define F0900_P2_DMDRES_NEWONLY  0xf2c60004
#define F0900_P2_DMDRES_NOSTORE  0xf2c60002
#define F0900_P2_DMDRES_AGC2MEM  0xf2c60001

/*P2_DMDRESADR*/
#define R0900_P2_DMDRESADR  0xf2c7
#define F0900_P2_SUSP_PREDCANAL  0xf2c70080
#define F0900_P2_DMDRES_VALIDCFR  0xf2c70040
#define F0900_P2_DMDRES_MEMFULL  0xf2c70030
#define F0900_P2_DMDRES_RESNBR  0xf2c7000f

/*P2_DMDRESDATA7*/
#define R0900_P2_DMDRESDATA7  0xf2c8
#define F0900_P2_DMDRES_DATA7  0xf2c800ff

/*P2_DMDRESDATA6*/
#define R0900_P2_DMDRESDATA6  0xf2c9
#define F0900_P2_DMDRES_DATA6  0xf2c900ff

/*P2_DMDRESDATA5*/
#define R0900_P2_DMDRESDATA5  0xf2ca
#define F0900_P2_DMDRES_DATA5  0xf2ca00ff

/*P2_DMDRESDATA4*/
#define R0900_P2_DMDRESDATA4  0xf2cb
#define F0900_P2_DMDRES_DATA4  0xf2cb00ff

/*P2_DMDRESDATA3*/
#define R0900_P2_DMDRESDATA3  0xf2cc
#define F0900_P2_DMDRES_DATA3  0xf2cc00ff

/*P2_DMDRESDATA2*/
#define R0900_P2_DMDRESDATA2  0xf2cd
#define F0900_P2_DMDRES_DATA2  0xf2cd00ff

/*P2_DMDRESDATA1*/
#define R0900_P2_DMDRESDATA1  0xf2ce
#define F0900_P2_DMDRES_DATA1  0xf2ce00ff

/*P2_DMDRESDATA0*/
#define R0900_P2_DMDRESDATA0  0xf2cf
#define F0900_P2_DMDRES_DATA0  0xf2cf00ff

/*P2_FFEI1*/
#define R0900_P2_FFEI1  0xf2d0
#define F0900_P2_FFE_ACCI1  0xf2d001ff

/*P2_FFEQ1*/
#define R0900_P2_FFEQ1  0xf2d1
#define F0900_P2_FFE_ACCQ1  0xf2d101ff

/*P2_FFEI2*/
#define R0900_P2_FFEI2  0xf2d2
#define F0900_P2_FFE_ACCI2  0xf2d201ff

/*P2_FFEQ2*/
#define R0900_P2_FFEQ2  0xf2d3
#define F0900_P2_FFE_ACCQ2  0xf2d301ff

/*P2_FFEI3*/
#define R0900_P2_FFEI3  0xf2d4
#define F0900_P2_FFE_ACCI3  0xf2d401ff

/*P2_FFEQ3*/
#define R0900_P2_FFEQ3  0xf2d5
#define F0900_P2_FFE_ACCQ3  0xf2d501ff

/*P2_FFEI4*/
#define R0900_P2_FFEI4  0xf2d6
#define F0900_P2_FFE_ACCI4  0xf2d601ff

/*P2_FFEQ4*/
#define R0900_P2_FFEQ4  0xf2d7
#define F0900_P2_FFE_ACCQ4  0xf2d701ff

/*P2_FFECFG*/
#define R0900_P2_FFECFG  0xf2d8
#define F0900_P2_EQUALFFE_ON  0xf2d80040
#define F0900_P2_EQUAL_USEDSYMB  0xf2d80030
#define F0900_P2_MU_EQUALFFE  0xf2d80007

/*P2_TNRCFG*/
#define R0900_P2_TNRCFG  0xf2e0
#define F0900_P2_TUN_ACKFAIL  0xf2e00080
#define F0900_P2_TUN_TYPE  0xf2e00070
#define F0900_P2_TUN_SECSTOP  0xf2e00008
#define F0900_P2_TUN_VCOSRCH  0xf2e00004
#define F0900_P2_TUN_MADDRESS  0xf2e00003

/*P2_TNRCFG2*/
#define R0900_P2_TNRCFG2  0xf2e1
#define F0900_P2_TUN_IQSWAP  0xf2e10080
#define F0900_P2_STB6110_STEP2MHZ  0xf2e10040
#define F0900_P2_STB6120_DBLI2C  0xf2e10020
#define F0900_P2_DIS_FCCK  0xf2e10010
#define F0900_P2_DIS_LPEN  0xf2e10008
#define F0900_P2_DIS_BWCALC  0xf2e10004
#define F0900_P2_SHORT_WAITSTATES  0xf2e10002
#define F0900_P2_DIS_2BWAGC1  0xf2e10001

/*P2_TNRXTAL*/
#define R0900_P2_TNRXTAL  0xf2e4
#define F0900_P2_TUN_MCLKDECIMAL  0xf2e400e0
#define F0900_P2_TUN_XTALFREQ  0xf2e4001f

/*P2_TNRSTEPS*/
#define R0900_P2_TNRSTEPS  0xf2e7
#define F0900_P2_TUNER_BW1P6  0xf2e70080
#define F0900_P2_BWINC_OFFSET  0xf2e70070
#define F0900_P2_SOFTSTEP_RNG  0xf2e70008
#define F0900_P2_TUN_BWOFFSET  0xf2e70107

/*P2_TNRGAIN*/
#define R0900_P2_TNRGAIN  0xf2e8
#define F0900_P2_TUN_KDIVEN  0xf2e800c0
#define F0900_P2_STB6X00_OCK  0xf2e80030
#define F0900_P2_TUN_GAIN  0xf2e8000f

/*P2_TNRRF1*/
#define R0900_P2_TNRRF1  0xf2e9
#define F0900_P2_TUN_RFFREQ2  0xf2e900ff

/*P2_TNRRF0*/
#define R0900_P2_TNRRF0  0xf2ea
#define F0900_P2_TUN_RFFREQ1  0xf2ea00ff

/*P2_TNRBW*/
#define R0900_P2_TNRBW  0xf2eb
#define F0900_P2_TUN_RFFREQ0  0xf2eb00c0
#define F0900_P2_TUN_BW  0xf2eb003f

/*P2_TNRADJ*/
#define R0900_P2_TNRADJ  0xf2ec
#define F0900_P2_STB61X0_RCLK  0xf2ec0080
#define F0900_P2_STB61X0_CALTIME  0xf2ec0040
#define F0900_P2_STB6X00_DLB  0xf2ec0038
#define F0900_P2_STB6000_FCL  0xf2ec0007

/*P2_TNRCTL2*/
#define R0900_P2_TNRCTL2  0xf2ed
#define F0900_P2_STB61X0_LCP1_RCCKOFF  0xf2ed0080
#define F0900_P2_STB61X0_LCP0  0xf2ed0040
#define F0900_P2_STB61X0_XTOUT_RFOUTS  0xf2ed0020
#define F0900_P2_STB61X0_XTON_MCKDV  0xf2ed0010
#define F0900_P2_STB61X0_CALOFF_DCOFF  0xf2ed0008
#define F0900_P2_STB6110_LPT  0xf2ed0004
#define F0900_P2_STB6110_RX  0xf2ed0002
#define F0900_P2_STB6110_SYN  0xf2ed0001

/*P2_TNRCFG3*/
#define R0900_P2_TNRCFG3  0xf2ee
#define F0900_P2_STB6120_DISCTRL1  0xf2ee0080
#define F0900_P2_STB6120_INVORDER  0xf2ee0040
#define F0900_P2_STB6120_ENCTRL6  0xf2ee0020
#define F0900_P2_TUN_PLLFREQ  0xf2ee001c
#define F0900_P2_TUN_I2CFREQ_MODE  0xf2ee0003

/*P2_TNRLAUNCH*/
#define R0900_P2_TNRLAUNCH  0xf2f0

/*P2_TNRLD*/
#define R0900_P2_TNRLD  0xf2f0
#define F0900_P2_TUNLD_VCOING  0xf2f00080
#define F0900_P2_TUN_REG1FAIL  0xf2f00040
#define F0900_P2_TUN_REG2FAIL  0xf2f00020
#define F0900_P2_TUN_REG3FAIL  0xf2f00010
#define F0900_P2_TUN_REG4FAIL  0xf2f00008
#define F0900_P2_TUN_REG5FAIL  0xf2f00004
#define F0900_P2_TUN_BWING  0xf2f00002
#define F0900_P2_TUN_LOCKED  0xf2f00001

/*P2_TNROBSL*/
#define R0900_P2_TNROBSL  0xf2f6
#define F0900_P2_TUN_I2CABORTED  0xf2f60080
#define F0900_P2_TUN_LPEN  0xf2f60040
#define F0900_P2_TUN_FCCK  0xf2f60020
#define F0900_P2_TUN_I2CLOCKED  0xf2f60010
#define F0900_P2_TUN_PROGDONE  0xf2f6000c
#define F0900_P2_TUN_RFRESTE1  0xf2f60003

/*P2_TNRRESTE*/
#define R0900_P2_TNRRESTE  0xf2f7
#define F0900_P2_TUN_RFRESTE0  0xf2f700ff

/*P2_SMAPCOEF7*/
#define R0900_P2_SMAPCOEF7  0xf300
#define F0900_P2_DIS_QSCALE  0xf3000080
#define F0900_P2_SMAPCOEF_Q_LLR12  0xf300017f

/*P2_SMAPCOEF6*/
#define R0900_P2_SMAPCOEF6  0xf301
#define F0900_P2_DIS_NEWSCALE  0xf3010008
#define F0900_P2_ADJ_8PSKLLR1  0xf3010004
#define F0900_P2_OLD_8PSKLLR1  0xf3010002
#define F0900_P2_DIS_AB8PSK  0xf3010001

/*P2_SMAPCOEF5*/
#define R0900_P2_SMAPCOEF5  0xf302
#define F0900_P2_DIS_8SCALE  0xf3020080
#define F0900_P2_SMAPCOEF_8P_LLR23  0xf302017f

/*P2_DMDPLHSTAT*/
#define R0900_P2_DMDPLHSTAT  0xf320
#define F0900_P2_PLH_STATISTIC  0xf32000ff

/*P2_LOCKTIME3*/
#define R0900_P2_LOCKTIME3  0xf322
#define F0900_P2_DEMOD_LOCKTIME3  0xf32200ff

/*P2_LOCKTIME2*/
#define R0900_P2_LOCKTIME2  0xf323
#define F0900_P2_DEMOD_LOCKTIME2  0xf32300ff

/*P2_LOCKTIME1*/
#define R0900_P2_LOCKTIME1  0xf324
#define F0900_P2_DEMOD_LOCKTIME1  0xf32400ff

/*P2_LOCKTIME0*/
#define R0900_P2_LOCKTIME0  0xf325
#define F0900_P2_DEMOD_LOCKTIME0  0xf32500ff

/*P2_VITSCALE*/
#define R0900_P2_VITSCALE  0xf332
#define F0900_P2_NVTH_NOSRANGE  0xf3320080
#define F0900_P2_VERROR_MAXMODE  0xf3320040
#define F0900_P2_KDIV_MODE  0xf3320030
#define F0900_P2_NSLOWSN_LOCKED  0xf3320008
#define F0900_P2_DELOCK_PRFLOSS  0xf3320004
#define F0900_P2_DIS_RSFLOCK  0xf3320002

/*P2_FECM*/
#define R0900_P2_FECM  0xf333
#define F0900_P2_DSS_DVB  0xf3330080
#define F0900_P2_DEMOD_BYPASS  0xf3330040
#define F0900_P2_CMP_SLOWMODE  0xf3330020
#define F0900_P2_DSS_SRCH  0xf3330010
#define F0900_P2_DIFF_MODEVIT  0xf3330004
#define F0900_P2_SYNCVIT  0xf3330002
#define F0900_P2_IQINV  0xf3330001

/*P2_VTH12*/
#define R0900_P2_VTH12  0xf334
#define F0900_P2_VTH12  0xf33400ff

/*P2_VTH23*/
#define R0900_P2_VTH23  0xf335
#define F0900_P2_VTH23  0xf33500ff

/*P2_VTH34*/
#define R0900_P2_VTH34  0xf336
#define F0900_P2_VTH34  0xf33600ff

/*P2_VTH56*/
#define R0900_P2_VTH56  0xf337
#define F0900_P2_VTH56  0xf33700ff

/*P2_VTH67*/
#define R0900_P2_VTH67  0xf338
#define F0900_P2_VTH67  0xf33800ff

/*P2_VTH78*/
#define R0900_P2_VTH78  0xf339
#define F0900_P2_VTH78  0xf33900ff

/*P2_VITCURPUN*/
#define R0900_P2_VITCURPUN  0xf33a
#define F0900_P2_VIT_MAPPING  0xf33a00e0
#define F0900_P2_VIT_CURPUN  0xf33a001f

/*P2_VERROR*/
#define R0900_P2_VERROR  0xf33b
#define F0900_P2_REGERR_VIT  0xf33b00ff

/*P2_PRVIT*/
#define R0900_P2_PRVIT  0xf33c
#define F0900_P2_DIS_VTHLOCK  0xf33c0040
#define F0900_P2_E7_8VIT  0xf33c0020
#define F0900_P2_E6_7VIT  0xf33c0010
#define F0900_P2_E5_6VIT  0xf33c0008
#define F0900_P2_E3_4VIT  0xf33c0004
#define F0900_P2_E2_3VIT  0xf33c0002
#define F0900_P2_E1_2VIT  0xf33c0001

/*P2_VAVSRVIT*/
#define R0900_P2_VAVSRVIT  0xf33d
#define F0900_P2_AMVIT  0xf33d0080
#define F0900_P2_FROZENVIT  0xf33d0040
#define F0900_P2_SNVIT  0xf33d0030
#define F0900_P2_TOVVIT  0xf33d000c
#define F0900_P2_HYPVIT  0xf33d0003

/*P2_VSTATUSVIT*/
#define R0900_P2_VSTATUSVIT  0xf33e
#define F0900_P2_VITERBI_ON  0xf33e0080
#define F0900_P2_END_LOOPVIT  0xf33e0040
#define F0900_P2_VITERBI_DEPRF  0xf33e0020
#define F0900_P2_PRFVIT  0xf33e0010
#define F0900_P2_LOCKEDVIT  0xf33e0008
#define F0900_P2_VITERBI_DELOCK  0xf33e0004
#define F0900_P2_VIT_DEMODSEL  0xf33e0002
#define F0900_P2_VITERBI_COMPOUT  0xf33e0001

/*P2_VTHINUSE*/
#define R0900_P2_VTHINUSE  0xf33f
#define F0900_P2_VIT_INUSE  0xf33f00ff

/*P2_KDIV12*/
#define R0900_P2_KDIV12  0xf340
#define F0900_P2_KDIV12_MANUAL  0xf3400080
#define F0900_P2_K_DIVIDER_12  0xf340007f

/*P2_KDIV23*/
#define R0900_P2_KDIV23  0xf341
#define F0900_P2_KDIV23_MANUAL  0xf3410080
#define F0900_P2_K_DIVIDER_23  0xf341007f

/*P2_KDIV34*/
#define R0900_P2_KDIV34  0xf342
#define F0900_P2_KDIV34_MANUAL  0xf3420080
#define F0900_P2_K_DIVIDER_34  0xf342007f

/*P2_KDIV56*/
#define R0900_P2_KDIV56  0xf343
#define F0900_P2_KDIV56_MANUAL  0xf3430080
#define F0900_P2_K_DIVIDER_56  0xf343007f

/*P2_KDIV67*/
#define R0900_P2_KDIV67  0xf344
#define F0900_P2_KDIV67_MANUAL  0xf3440080
#define F0900_P2_K_DIVIDER_67  0xf344007f

/*P2_KDIV78*/
#define R0900_P2_KDIV78  0xf345
#define F0900_P2_KDIV78_MANUAL  0xf3450080
#define F0900_P2_K_DIVIDER_78  0xf345007f

/*P2_PDELCTRL1*/
#define R0900_P2_PDELCTRL1  0xf350
#define F0900_P2_INV_MISMASK  0xf3500080
#define F0900_P2_FORCE_ACCEPTED  0xf3500040
#define F0900_P2_FILTER_EN  0xf3500020
#define F0900_P2_FORCE_PKTDELINUSE  0xf3500010
#define F0900_P2_HYSTEN  0xf3500008
#define F0900_P2_HYSTSWRST  0xf3500004
#define F0900_P2_EN_MIS00  0xf3500002
#define F0900_P2_ALGOSWRST  0xf3500001

/*P2_PDELCTRL2*/
#define R0900_P2_PDELCTRL2  0xf351
#define F0900_P2_FORCE_CONTINUOUS  0xf3510080
#define F0900_P2_RESET_UPKO_COUNT  0xf3510040
#define F0900_P2_USER_PKTDELIN_NB  0xf3510020
#define F0900_P2_FORCE_LOCKED  0xf3510010
#define F0900_P2_DATA_UNBBSCRAM  0xf3510008
#define F0900_P2_FORCE_LONGPKT  0xf3510004
#define F0900_P2_FRAME_MODE  0xf3510002

/*P2_HYSTTHRESH*/
#define R0900_P2_HYSTTHRESH  0xf354
#define F0900_P2_UNLCK_THRESH  0xf35400f0
#define F0900_P2_DELIN_LCK_THRESH  0xf354000f

/*P2_ISIENTRY*/
#define R0900_P2_ISIENTRY  0xf35e
#define F0900_P2_ISI_ENTRY  0xf35e00ff

/*P2_ISIBITENA*/
#define R0900_P2_ISIBITENA  0xf35f
#define F0900_P2_ISI_BIT_EN  0xf35f00ff

/*P2_MATSTR1*/
#define R0900_P2_MATSTR1  0xf360
#define F0900_P2_MATYPE_CURRENT1  0xf36000ff

/*P2_MATSTR0*/
#define R0900_P2_MATSTR0  0xf361
#define F0900_P2_MATYPE_CURRENT0  0xf36100ff

/*P2_UPLSTR1*/
#define R0900_P2_UPLSTR1  0xf362
#define F0900_P2_UPL_CURRENT1  0xf36200ff

/*P2_UPLSTR0*/
#define R0900_P2_UPLSTR0  0xf363
#define F0900_P2_UPL_CURRENT0  0xf36300ff

/*P2_DFLSTR1*/
#define R0900_P2_DFLSTR1  0xf364
#define F0900_P2_DFL_CURRENT1  0xf36400ff

/*P2_DFLSTR0*/
#define R0900_P2_DFLSTR0  0xf365
#define F0900_P2_DFL_CURRENT0  0xf36500ff

/*P2_SYNCSTR*/
#define R0900_P2_SYNCSTR  0xf366
#define F0900_P2_SYNC_CURRENT  0xf36600ff

/*P2_SYNCDSTR1*/
#define R0900_P2_SYNCDSTR1  0xf367
#define F0900_P2_SYNCD_CURRENT1  0xf36700ff

/*P2_SYNCDSTR0*/
#define R0900_P2_SYNCDSTR0  0xf368
#define F0900_P2_SYNCD_CURRENT0  0xf36800ff

/*P2_PDELSTATUS1*/
#define R0900_P2_PDELSTATUS1  0xf369
#define F0900_P2_PKTDELIN_DELOCK  0xf3690080
#define F0900_P2_SYNCDUPDFL_BADDFL  0xf3690040
#define F0900_P2_CONTINUOUS_STREAM  0xf3690020
#define F0900_P2_UNACCEPTED_STREAM  0xf3690010
#define F0900_P2_BCH_ERROR_FLAG  0xf3690008
#define F0900_P2_BBHCRCKO  0xf3690004
#define F0900_P2_PKTDELIN_LOCK  0xf3690002
#define F0900_P2_FIRST_LOCK  0xf3690001

/*P2_PDELSTATUS2*/
#define R0900_P2_PDELSTATUS2  0xf36a
#define F0900_P2_PKTDEL_DEMODSEL  0xf36a0080
#define F0900_P2_FRAME_MODCOD  0xf36a007c
#define F0900_P2_FRAME_TYPE  0xf36a0003

/*P2_BBFCRCKO1*/
#define R0900_P2_BBFCRCKO1  0xf36b
#define F0900_P2_BBHCRC_KOCNT1  0xf36b00ff

/*P2_BBFCRCKO0*/
#define R0900_P2_BBFCRCKO0  0xf36c
#define F0900_P2_BBHCRC_KOCNT0  0xf36c00ff

/*P2_UPCRCKO1*/
#define R0900_P2_UPCRCKO1  0xf36d
#define F0900_P2_PKTCRC_KOCNT1  0xf36d00ff

/*P2_UPCRCKO0*/
#define R0900_P2_UPCRCKO0  0xf36e
#define F0900_P2_PKTCRC_KOCNT0  0xf36e00ff

/*P2_TSSTATEM*/
#define R0900_P2_TSSTATEM  0xf370
#define F0900_P2_TSDIL_ON  0xf3700080
#define F0900_P2_TSSKIPRS_ON  0xf3700040
#define F0900_P2_TSRS_ON  0xf3700020
#define F0900_P2_TSDESCRAMB_ON  0xf3700010
#define F0900_P2_TSFRAME_MODE  0xf3700008
#define F0900_P2_TS_DISABLE  0xf3700004
#define F0900_P2_TSACM_MODE  0xf3700002
#define F0900_P2_TSOUT_NOSYNC  0xf3700001

/*P2_TSCFGH*/
#define R0900_P2_TSCFGH  0xf372
#define F0900_P2_TSFIFO_DVBCI  0xf3720080
#define F0900_P2_TSFIFO_SERIAL  0xf3720040
#define F0900_P2_TSFIFO_TEIUPDATE  0xf3720020
#define F0900_P2_TSFIFO_DUTY50  0xf3720010
#define F0900_P2_TSFIFO_HSGNLOUT  0xf3720008
#define F0900_P2_TSFIFO_ERRMODE  0xf3720006
#define F0900_P2_RST_HWARE  0xf3720001

/*P2_TSCFGM*/
#define R0900_P2_TSCFGM  0xf373
#define F0900_P2_TSFIFO_MANSPEED  0xf37300c0
#define F0900_P2_TSFIFO_PERMDATA  0xf3730020
#define F0900_P2_TSFIFO_NONEWSGNL  0xf3730010
#define F0900_P2_TSFIFO_BITSPEED  0xf3730008
#define F0900_P2_NPD_SPECDVBS2  0xf3730004
#define F0900_P2_TSFIFO_STOPCKDIS  0xf3730002
#define F0900_P2_TSFIFO_INVDATA  0xf3730001

/*P2_TSCFGL*/
#define R0900_P2_TSCFGL  0xf374
#define F0900_P2_TSFIFO_BCLKDEL1CK  0xf37400c0
#define F0900_P2_BCHERROR_MODE  0xf3740030
#define F0900_P2_TSFIFO_NSGNL2DATA  0xf3740008
#define F0900_P2_TSFIFO_EMBINDVB  0xf3740004
#define F0900_P2_TSFIFO_DPUNACT  0xf3740002
#define F0900_P2_TSFIFO_NPDOFF  0xf3740001

/*P2_TSINSDELH*/
#define R0900_P2_TSINSDELH  0xf376
#define F0900_P2_TSDEL_SYNCBYTE  0xf3760080
#define F0900_P2_TSDEL_XXHEADER  0xf3760040
#define F0900_P2_TSDEL_BBHEADER  0xf3760020
#define F0900_P2_TSDEL_DATAFIELD  0xf3760010
#define F0900_P2_TSINSDEL_ISCR  0xf3760008
#define F0900_P2_TSINSDEL_NPD  0xf3760004
#define F0900_P2_TSINSDEL_RSPARITY  0xf3760002
#define F0900_P2_TSINSDEL_CRC8  0xf3760001

/*P2_TSSPEED*/
#define R0900_P2_TSSPEED  0xf380
#define F0900_P2_TSFIFO_OUTSPEED  0xf38000ff

/*P2_TSSTATUS*/
#define R0900_P2_TSSTATUS  0xf381
#define F0900_P2_TSFIFO_LINEOK  0xf3810080
#define F0900_P2_TSFIFO_ERROR  0xf3810040
#define F0900_P2_TSFIFO_DATA7  0xf3810020
#define F0900_P2_TSFIFO_NOSYNC  0xf3810010
#define F0900_P2_ISCR_INITIALIZED  0xf3810008
#define F0900_P2_ISCR_UPDATED  0xf3810004
#define F0900_P2_SOFFIFO_UNREGUL  0xf3810002
#define F0900_P2_DIL_READY  0xf3810001

/*P2_TSSTATUS2*/
#define R0900_P2_TSSTATUS2  0xf382
#define F0900_P2_TSFIFO_DEMODSEL  0xf3820080
#define F0900_P2_TSFIFOSPEED_STORE  0xf3820040
#define F0900_P2_DILXX_RESET  0xf3820020
#define F0900_P2_TSSERIAL_IMPOS  0xf3820010
#define F0900_P2_TSFIFO_LINENOK  0xf3820008
#define F0900_P2_BITSPEED_EVENT  0xf3820004
#define F0900_P2_SCRAMBDETECT  0xf3820002
#define F0900_P2_ULDTV67_FALSELOCK  0xf3820001

/*P2_TSBITRATE1*/
#define R0900_P2_TSBITRATE1  0xf383
#define F0900_P2_TSFIFO_BITRATE1  0xf38300ff

/*P2_TSBITRATE0*/
#define R0900_P2_TSBITRATE0  0xf384
#define F0900_P2_TSFIFO_BITRATE0  0xf38400ff

/*P2_ERRCTRL1*/
#define R0900_P2_ERRCTRL1  0xf398
#define F0900_P2_ERR_SOURCE1  0xf39800f0
#define F0900_P2_NUM_EVENT1  0xf3980007

/*P2_ERRCNT12*/
#define R0900_P2_ERRCNT12  0xf399
#define F0900_P2_ERRCNT1_OLDVALUE  0xf3990080
#define F0900_P2_ERR_CNT12  0xf399007f

/*P2_ERRCNT11*/
#define R0900_P2_ERRCNT11  0xf39a
#define F0900_P2_ERR_CNT11  0xf39a00ff

/*P2_ERRCNT10*/
#define R0900_P2_ERRCNT10  0xf39b
#define F0900_P2_ERR_CNT10  0xf39b00ff

/*P2_ERRCTRL2*/
#define R0900_P2_ERRCTRL2  0xf39c
#define F0900_P2_ERR_SOURCE2  0xf39c00f0
#define F0900_P2_NUM_EVENT2  0xf39c0007

/*P2_ERRCNT22*/
#define R0900_P2_ERRCNT22  0xf39d
#define F0900_P2_ERRCNT2_OLDVALUE  0xf39d0080
#define F0900_P2_ERR_CNT22  0xf39d007f

/*P2_ERRCNT21*/
#define R0900_P2_ERRCNT21  0xf39e
#define F0900_P2_ERR_CNT21  0xf39e00ff

/*P2_ERRCNT20*/
#define R0900_P2_ERRCNT20  0xf39f
#define F0900_P2_ERR_CNT20  0xf39f00ff

/*P2_FECSPY*/
#define R0900_P2_FECSPY  0xf3a0
#define F0900_P2_SPY_ENABLE  0xf3a00080
#define F0900_P2_NO_SYNCBYTE  0xf3a00040
#define F0900_P2_SERIAL_MODE  0xf3a00020
#define F0900_P2_UNUSUAL_PACKET  0xf3a00010
#define F0900_P2_BER_PACKMODE  0xf3a00008
#define F0900_P2_BERMETER_LMODE  0xf3a00002
#define F0900_P2_BERMETER_RESET  0xf3a00001

/*P2_FSPYCFG*/
#define R0900_P2_FSPYCFG  0xf3a1
#define F0900_P2_FECSPY_INPUT  0xf3a100c0
#define F0900_P2_RST_ON_ERROR  0xf3a10020
#define F0900_P2_ONE_SHOT  0xf3a10010
#define F0900_P2_I2C_MODE  0xf3a1000c
#define F0900_P2_SPY_HYSTERESIS  0xf3a10003

/*P2_FSPYDATA*/
#define R0900_P2_FSPYDATA  0xf3a2
#define F0900_P2_SPY_STUFFING  0xf3a20080
#define F0900_P2_NOERROR_PKTJITTER  0xf3a20040
#define F0900_P2_SPY_CNULLPKT  0xf3a20020
#define F0900_P2_SPY_OUTDATA_MODE  0xf3a2001f

/*P2_FSPYOUT*/
#define R0900_P2_FSPYOUT  0xf3a3
#define F0900_P2_FSPY_DIRECT  0xf3a30080
#define F0900_P2_SPY_OUTDATA_BUS  0xf3a30038
#define F0900_P2_STUFF_MODE  0xf3a30007

/*P2_FSTATUS*/
#define R0900_P2_FSTATUS  0xf3a4
#define F0900_P2_SPY_ENDSIM  0xf3a40080
#define F0900_P2_VALID_SIM  0xf3a40040
#define F0900_P2_FOUND_SIGNAL  0xf3a40020
#define F0900_P2_DSS_SYNCBYTE  0xf3a40010
#define F0900_P2_RESULT_STATE  0xf3a4000f

/*P2_FBERCPT4*/
#define R0900_P2_FBERCPT4  0xf3a8
#define F0900_P2_FBERMETER_CPT4  0xf3a800ff

/*P2_FBERCPT3*/
#define R0900_P2_FBERCPT3  0xf3a9
#define F0900_P2_FBERMETER_CPT3  0xf3a900ff

/*P2_FBERCPT2*/
#define R0900_P2_FBERCPT2  0xf3aa
#define F0900_P2_FBERMETER_CPT2  0xf3aa00ff

/*P2_FBERCPT1*/
#define R0900_P2_FBERCPT1  0xf3ab
#define F0900_P2_FBERMETER_CPT1  0xf3ab00ff

/*P2_FBERCPT0*/
#define R0900_P2_FBERCPT0  0xf3ac
#define F0900_P2_FBERMETER_CPT0  0xf3ac00ff

/*P2_FBERERR2*/
#define R0900_P2_FBERERR2  0xf3ad
#define F0900_P2_FBERMETER_ERR2  0xf3ad00ff

/*P2_FBERERR1*/
#define R0900_P2_FBERERR1  0xf3ae
#define F0900_P2_FBERMETER_ERR1  0xf3ae00ff

/*P2_FBERERR0*/
#define R0900_P2_FBERERR0  0xf3af
#define F0900_P2_FBERMETER_ERR0  0xf3af00ff

/*P2_FSPYBER*/
#define R0900_P2_FSPYBER  0xf3b2
#define F0900_P2_FSPYOBS_XORREAD  0xf3b20040
#define F0900_P2_FSPYBER_OBSMODE  0xf3b20020
#define F0900_P2_FSPYBER_SYNCBYTE  0xf3b20010
#define F0900_P2_FSPYBER_UNSYNC  0xf3b20008
#define F0900_P2_FSPYBER_CTIME  0xf3b20007

/*P1_IQCONST*/
#define R0900_P1_IQCONST  0xf400
#define F0900_P1_CONSTEL_SELECT  0xf4000060
#define F0900_P1_IQSYMB_SEL  0xf400001f

/*P1_NOSCFG*/
#define R0900_P1_NOSCFG  0xf401
#define F0900_P1_DUMMYPL_NOSDATA  0xf4010020
#define F0900_P1_NOSPLH_BETA  0xf4010018
#define F0900_P1_NOSDATA_BETA  0xf4010007

/*P1_ISYMB*/
#define R0900_P1_ISYMB  0xf402
#define F0900_P1_I_SYMBOL  0xf40201ff

/*P1_QSYMB*/
#define R0900_P1_QSYMB  0xf403
#define F0900_P1_Q_SYMBOL  0xf40301ff

/*P1_AGC1CFG*/
#define R0900_P1_AGC1CFG  0xf404
#define F0900_P1_DC_FROZEN  0xf4040080
#define F0900_P1_DC_CORRECT  0xf4040040
#define F0900_P1_AMM_FROZEN  0xf4040020
#define F0900_P1_AMM_CORRECT  0xf4040010
#define F0900_P1_QUAD_FROZEN  0xf4040008
#define F0900_P1_QUAD_CORRECT  0xf4040004
#define F0900_P1_DCCOMP_SLOW  0xf4040002
#define F0900_P1_IQMISM_SLOW  0xf4040001

/*P1_AGC1CN*/
#define R0900_P1_AGC1CN  0xf406
#define F0900_P1_AGC1_LOCKED  0xf4060080
#define F0900_P1_AGC1_OVERFLOW  0xf4060040
#define F0900_P1_AGC1_NOSLOWLK  0xf4060020
#define F0900_P1_AGC1_MINPOWER  0xf4060010
#define F0900_P1_AGCOUT_FAST  0xf4060008
#define F0900_P1_AGCIQ_BETA  0xf4060007

/*P1_AGC1REF*/
#define R0900_P1_AGC1REF  0xf407
#define F0900_P1_AGCIQ_REF  0xf40700ff

/*P1_IDCCOMP*/
#define R0900_P1_IDCCOMP  0xf408
#define F0900_P1_IAVERAGE_ADJ  0xf40801ff

/*P1_QDCCOMP*/
#define R0900_P1_QDCCOMP  0xf409
#define F0900_P1_QAVERAGE_ADJ  0xf40901ff

/*P1_POWERI*/
#define R0900_P1_POWERI  0xf40a
#define F0900_P1_POWER_I  0xf40a00ff

/*P1_POWERQ*/
#define R0900_P1_POWERQ  0xf40b
#define F0900_P1_POWER_Q  0xf40b00ff

/*P1_AGC1AMM*/
#define R0900_P1_AGC1AMM  0xf40c
#define F0900_P1_AMM_VALUE  0xf40c00ff

/*P1_AGC1QUAD*/
#define R0900_P1_AGC1QUAD  0xf40d
#define F0900_P1_QUAD_VALUE  0xf40d01ff

/*P1_AGCIQIN1*/
#define R0900_P1_AGCIQIN1  0xf40e
#define F0900_P1_AGCIQ_VALUE1  0xf40e00ff

/*P1_AGCIQIN0*/
#define R0900_P1_AGCIQIN0  0xf40f
#define F0900_P1_AGCIQ_VALUE0  0xf40f00ff

/*P1_DEMOD*/
#define R0900_P1_DEMOD  0xf410
#define F0900_P1_DEMOD_STOP  0xf4100040
#define F0900_P1_SPECINV_CONTROL  0xf4100030
#define F0900_P1_FORCE_ENASAMP  0xf4100008
#define F0900_P1_MANUAL_ROLLOFF  0xf4100004
#define F0900_P1_ROLLOFF_CONTROL  0xf4100003

/*P1_DMDMODCOD*/
#define R0900_P1_DMDMODCOD  0xf411
#define F0900_P1_MANUAL_MODCOD  0xf4110080
#define F0900_P1_DEMOD_MODCOD  0xf411007c
#define F0900_P1_DEMOD_TYPE  0xf4110003

/*P1_DSTATUS*/
#define R0900_P1_DSTATUS  0xf412
#define F0900_P1_CAR_LOCK  0xf4120080
#define F0900_P1_TMGLOCK_QUALITY  0xf4120060
#define F0900_P1_SDVBS1_ENABLE  0xf4120010
#define F0900_P1_LOCK_DEFINITIF  0xf4120008
#define F0900_P1_TIMING_IS_LOCKED  0xf4120004
#define F0900_P1_COARSE_TMGLOCK  0xf4120002
#define F0900_P1_COARSE_CARLOCK  0xf4120001

/*P1_DSTATUS2*/
#define R0900_P1_DSTATUS2  0xf413
#define F0900_P1_DEMOD_DELOCK  0xf4130080
#define F0900_P1_DEMOD_TIMEOUT  0xf4130040
#define F0900_P1_MODCODRQ_SYNCTAG  0xf4130020
#define F0900_P1_POLYPH_SATEVENT  0xf4130010
#define F0900_P1_AGC1_NOSIGNALACK  0xf4130008
#define F0900_P1_AGC2_OVERFLOW  0xf4130004
#define F0900_P1_CFR_OVERFLOW  0xf4130002
#define F0900_P1_GAMMA_OVERUNDER  0xf4130001

/*P1_DMDCFGMD*/
#define R0900_P1_DMDCFGMD  0xf414
#define F0900_P1_DVBS2_ENABLE  0xf4140080
#define F0900_P1_DVBS1_ENABLE  0xf4140040
#define F0900_P1_CFR_AUTOSCAN  0xf4140020
#define F0900_P1_SCAN_ENABLE  0xf4140010
#define F0900_P1_TUN_AUTOSCAN  0xf4140008
#define F0900_P1_NOFORCE_RELOCK  0xf4140004
#define F0900_P1_TUN_RNG  0xf4140003

/*P1_DMDCFG2*/
#define R0900_P1_DMDCFG2  0xf415
#define F0900_P1_AGC1_WAITLOCK  0xf4150080
#define F0900_P1_S1S2_SEQUENTIAL  0xf4150040
#define F0900_P1_OVERFLOW_TIMEOUT  0xf4150020
#define F0900_P1_SCANFAIL_TIMEOUT  0xf4150010
#define F0900_P1_DMDTOUT_BACK  0xf4150008
#define F0900_P1_CARLOCK_S1ENABLE  0xf4150004
#define F0900_P1_COARSE_LK3MODE  0xf4150002
#define F0900_P1_COARSE_LK2MODE  0xf4150001

/*P1_DMDISTATE*/
#define R0900_P1_DMDISTATE  0xf416
#define F0900_P1_I2C_NORESETDMODE  0xf4160080
#define F0900_P1_FORCE_ETAPED  0xf4160040
#define F0900_P1_SDMDRST_DIRCLK  0xf4160020
#define F0900_P1_I2C_DEMOD_MODE  0xf416001f

/*P1_DMDT0M*/
#define R0900_P1_DMDT0M  0xf417
#define F0900_P1_DMDT0_MIN  0xf41700ff

/*P1_DMDSTATE*/
#define R0900_P1_DMDSTATE  0xf41b
#define F0900_P1_DEMOD_LOCKED  0xf41b0080
#define F0900_P1_HEADER_MODE  0xf41b0060
#define F0900_P1_DEMOD_MODE  0xf41b001f

/*P1_DMDFLYW*/
#define R0900_P1_DMDFLYW  0xf41c
#define F0900_P1_I2C_IRQVAL  0xf41c00f0
#define F0900_P1_FLYWHEEL_CPT  0xf41c000f

/*P1_DSTATUS3*/
#define R0900_P1_DSTATUS3  0xf41d
#define F0900_P1_CFR_ZIGZAG  0xf41d0080
#define F0900_P1_DEMOD_CFGMODE  0xf41d0060
#define F0900_P1_GAMMA_LOWBAUDRATE  0xf41d0010
#define F0900_P1_RELOCK_MODE  0xf41d0008
#define F0900_P1_DEMOD_FAIL  0xf41d0004
#define F0900_P1_ETAPE1A_DVBXMEM  0xf41d0003

/*P1_DMDCFG3*/
#define R0900_P1_DMDCFG3  0xf41e
#define F0900_P1_DVBS1_TMGWAIT  0xf41e0080
#define F0900_P1_NO_BWCENTERING  0xf41e0040
#define F0900_P1_INV_SEQSRCH  0xf41e0020
#define F0900_P1_DIS_SFRUPLOW_TRK  0xf41e0010
#define F0900_P1_NOSTOP_FIFOFULL  0xf41e0008
#define F0900_P1_LOCKTIME_MODE  0xf41e0007

/*P1_DMDCFG4*/
#define R0900_P1_DMDCFG4  0xf41f
#define F0900_P1_TUNER_NRELAUNCH  0xf41f0008
#define F0900_P1_DIS_CLKENABLE  0xf41f0004
#define F0900_P1_DIS_HDRDIVLOCK  0xf41f0002
#define F0900_P1_NO_TNRWBINIT  0xf41f0001

/*P1_CORRELMANT*/
#define R0900_P1_CORRELMANT  0xf420
#define F0900_P1_CORREL_MANT  0xf42000ff

/*P1_CORRELABS*/
#define R0900_P1_CORRELABS  0xf421
#define F0900_P1_CORREL_ABS  0xf42100ff

/*P1_CORRELEXP*/
#define R0900_P1_CORRELEXP  0xf422
#define F0900_P1_CORREL_ABSEXP  0xf42200f0
#define F0900_P1_CORREL_EXP  0xf422000f

/*P1_PLHMODCOD*/
#define R0900_P1_PLHMODCOD  0xf424
#define F0900_P1_SPECINV_DEMOD  0xf4240080
#define F0900_P1_PLH_MODCOD  0xf424007c
#define F0900_P1_PLH_TYPE  0xf4240003

/*P1_AGCK32*/
#define R0900_P1_AGCK32  0xf42b
#define F0900_P1_R3ADJOFF_32APSK  0xf42b0080
#define F0900_P1_R2ADJOFF_32APSK  0xf42b0040
#define F0900_P1_R1ADJOFF_32APSK  0xf42b0020
#define F0900_P1_RADJ_32APSK  0xf42b001f

/*P1_AGC2O*/
#define R0900_P1_AGC2O  0xf42c
#define F0900_P1_AGC2REF_ADJUSTING  0xf42c0080
#define F0900_P1_AGC2_COARSEFAST  0xf42c0040
#define F0900_P1_AGC2_LKSQRT  0xf42c0020
#define F0900_P1_AGC2_LKMODE  0xf42c0010
#define F0900_P1_AGC2_LKEQUA  0xf42c0008
#define F0900_P1_AGC2_COEF  0xf42c0007

/*P1_AGC2REF*/
#define R0900_P1_AGC2REF  0xf42d
#define F0900_P1_AGC2_REF  0xf42d00ff

/*P1_AGC1ADJ*/
#define R0900_P1_AGC1ADJ  0xf42e
#define F0900_P1_AGC1ADJ_MANUAL  0xf42e0080
#define F0900_P1_AGC1_ADJUSTED  0xf42e017f

/*P1_AGC2I1*/
#define R0900_P1_AGC2I1  0xf436
#define F0900_P1_AGC2_INTEGRATOR1  0xf43600ff

/*P1_AGC2I0*/
#define R0900_P1_AGC2I0  0xf437
#define F0900_P1_AGC2_INTEGRATOR0  0xf43700ff

/*P1_CARCFG*/
#define R0900_P1_CARCFG  0xf438
#define F0900_P1_CFRUPLOW_AUTO  0xf4380080
#define F0900_P1_CFRUPLOW_TEST  0xf4380040
#define F0900_P1_EN_CAR2CENTER  0xf4380020
#define F0900_P1_CARHDR_NODIV8  0xf4380010
#define F0900_P1_I2C_ROTA  0xf4380008
#define F0900_P1_ROTAON  0xf4380004
#define F0900_P1_PH_DET_ALGO  0xf4380003

/*P1_ACLC*/
#define R0900_P1_ACLC  0xf439
#define F0900_P1_STOP_S2ALPHA  0xf43900c0
#define F0900_P1_CAR_ALPHA_MANT  0xf4390030
#define F0900_P1_CAR_ALPHA_EXP  0xf439000f

/*P1_BCLC*/
#define R0900_P1_BCLC  0xf43a
#define F0900_P1_STOP_S2BETA  0xf43a00c0
#define F0900_P1_CAR_BETA_MANT  0xf43a0030
#define F0900_P1_CAR_BETA_EXP  0xf43a000f

/*P1_CARFREQ*/
#define R0900_P1_CARFREQ  0xf43d
#define F0900_P1_KC_COARSE_EXP  0xf43d00f0
#define F0900_P1_BETA_FREQ  0xf43d000f

/*P1_CARHDR*/
#define R0900_P1_CARHDR  0xf43e
#define F0900_P1_K_FREQ_HDR  0xf43e00ff

/*P1_LDT*/
#define R0900_P1_LDT  0xf43f
#define F0900_P1_CARLOCK_THRES  0xf43f01ff

/*P1_LDT2*/
#define R0900_P1_LDT2  0xf440
#define F0900_P1_CARLOCK_THRES2  0xf44001ff

/*P1_CFRICFG*/
#define R0900_P1_CFRICFG  0xf441
#define F0900_P1_CFRINIT_UNVALRNG  0xf4410080
#define F0900_P1_CFRINIT_LUNVALCPT  0xf4410040
#define F0900_P1_CFRINIT_ABORTDBL  0xf4410020
#define F0900_P1_CFRINIT_ABORTPRED  0xf4410010
#define F0900_P1_CFRINIT_UNVALSKIP  0xf4410008
#define F0900_P1_CFRINIT_CSTINC  0xf4410004
#define F0900_P1_NEG_CFRSTEP  0xf4410001

/*P1_CFRUP1*/
#define R0900_P1_CFRUP1  0xf442
#define F0900_P1_CFR_UP1  0xf44201ff

/*P1_CFRUP0*/
#define R0900_P1_CFRUP0  0xf443
#define F0900_P1_CFR_UP0  0xf44300ff

/*P1_CFRLOW1*/
#define R0900_P1_CFRLOW1  0xf446
#define F0900_P1_CFR_LOW1  0xf44601ff

/*P1_CFRLOW0*/
#define R0900_P1_CFRLOW0  0xf447
#define F0900_P1_CFR_LOW0  0xf44700ff

/*P1_CFRINIT1*/
#define R0900_P1_CFRINIT1  0xf448
#define F0900_P1_CFR_INIT1  0xf44801ff

/*P1_CFRINIT0*/
#define R0900_P1_CFRINIT0  0xf449
#define F0900_P1_CFR_INIT0  0xf44900ff

/*P1_CFRINC1*/
#define R0900_P1_CFRINC1  0xf44a
#define F0900_P1_MANUAL_CFRINC  0xf44a0080
#define F0900_P1_CFR_INC1  0xf44a017f

/*P1_CFRINC0*/
#define R0900_P1_CFRINC0  0xf44b
#define F0900_P1_CFR_INC0  0xf44b00f0

/*P1_CFR2*/
#define R0900_P1_CFR2  0xf44c
#define F0900_P1_CAR_FREQ2  0xf44c01ff

/*P1_CFR1*/
#define R0900_P1_CFR1  0xf44d
#define F0900_P1_CAR_FREQ1  0xf44d00ff

/*P1_CFR0*/
#define R0900_P1_CFR0  0xf44e
#define F0900_P1_CAR_FREQ0  0xf44e00ff

/*P1_LDI*/
#define R0900_P1_LDI  0xf44f
#define F0900_P1_LOCK_DET_INTEGR  0xf44f01ff

/*P1_TMGCFG*/
#define R0900_P1_TMGCFG  0xf450
#define F0900_P1_TMGLOCK_BETA  0xf45000c0
#define F0900_P1_NOTMG_GROUPDELAY  0xf4500020
#define F0900_P1_DO_TIMING_CORR  0xf4500010
#define F0900_P1_MANUAL_SCAN  0xf450000c
#define F0900_P1_TMG_MINFREQ  0xf4500003

/*P1_RTC*/
#define R0900_P1_RTC  0xf451
#define F0900_P1_TMGALPHA_EXP  0xf45100f0
#define F0900_P1_TMGBETA_EXP  0xf451000f

/*P1_RTCS2*/
#define R0900_P1_RTCS2  0xf452
#define F0900_P1_TMGALPHAS2_EXP  0xf45200f0
#define F0900_P1_TMGBETAS2_EXP  0xf452000f

/*P1_TMGTHRISE*/
#define R0900_P1_TMGTHRISE  0xf453
#define F0900_P1_TMGLOCK_THRISE  0xf45300ff

/*P1_TMGTHFALL*/
#define R0900_P1_TMGTHFALL  0xf454
#define F0900_P1_TMGLOCK_THFALL  0xf45400ff

/*P1_SFRUPRATIO*/
#define R0900_P1_SFRUPRATIO  0xf455
#define F0900_P1_SFR_UPRATIO  0xf45500ff

/*P1_SFRLOWRATIO*/
#define R0900_P1_SFRLOWRATIO  0xf456
#define F0900_P1_SFR_LOWRATIO  0xf45600ff

/*P1_KREFTMG*/
#define R0900_P1_KREFTMG  0xf458
#define F0900_P1_KREF_TMG  0xf45800ff

/*P1_SFRSTEP*/
#define R0900_P1_SFRSTEP  0xf459
#define F0900_P1_SFR_SCANSTEP  0xf45900f0
#define F0900_P1_SFR_CENTERSTEP  0xf459000f

/*P1_TMGCFG2*/
#define R0900_P1_TMGCFG2  0xf45a
#define F0900_P1_DIS_AUTOSAMP  0xf45a0008
#define F0900_P1_SCANINIT_QUART  0xf45a0004
#define F0900_P1_NOTMG_DVBS1DERAT  0xf45a0002
#define F0900_P1_SFRRATIO_FINE  0xf45a0001

/*P1_SFRINIT1*/
#define R0900_P1_SFRINIT1  0xf45e
#define F0900_P1_SFR_INIT1  0xf45e00ff

/*P1_SFRINIT0*/
#define R0900_P1_SFRINIT0  0xf45f
#define F0900_P1_SFR_INIT0  0xf45f00ff

/*P1_SFRUP1*/
#define R0900_P1_SFRUP1  0xf460
#define F0900_P1_AUTO_GUP  0xf4600080
#define F0900_P1_SYMB_FREQ_UP1  0xf460007f

/*P1_SFRUP0*/
#define R0900_P1_SFRUP0  0xf461
#define F0900_P1_SYMB_FREQ_UP0  0xf46100ff

/*P1_SFRLOW1*/
#define R0900_P1_SFRLOW1  0xf462
#define F0900_P1_AUTO_GLOW  0xf4620080
#define F0900_P1_SYMB_FREQ_LOW1  0xf462007f

/*P1_SFRLOW0*/
#define R0900_P1_SFRLOW0  0xf463
#define F0900_P1_SYMB_FREQ_LOW0  0xf46300ff

/*P1_SFR3*/
#define R0900_P1_SFR3  0xf464
#define F0900_P1_SYMB_FREQ3  0xf46400ff

/*P1_SFR2*/
#define R0900_P1_SFR2  0xf465
#define F0900_P1_SYMB_FREQ2  0xf46500ff

/*P1_SFR1*/
#define R0900_P1_SFR1  0xf466
#define F0900_P1_SYMB_FREQ1  0xf46600ff

/*P1_SFR0*/
#define R0900_P1_SFR0  0xf467
#define F0900_P1_SYMB_FREQ0  0xf46700ff

/*P1_TMGREG2*/
#define R0900_P1_TMGREG2  0xf468
#define F0900_P1_TMGREG2  0xf46800ff

/*P1_TMGREG1*/
#define R0900_P1_TMGREG1  0xf469
#define F0900_P1_TMGREG1  0xf46900ff

/*P1_TMGREG0*/
#define R0900_P1_TMGREG0  0xf46a
#define F0900_P1_TMGREG0  0xf46a00ff

/*P1_TMGLOCK1*/
#define R0900_P1_TMGLOCK1  0xf46b
#define F0900_P1_TMGLOCK_LEVEL1  0xf46b01ff

/*P1_TMGLOCK0*/
#define R0900_P1_TMGLOCK0  0xf46c
#define F0900_P1_TMGLOCK_LEVEL0  0xf46c00ff

/*P1_TMGOBS*/
#define R0900_P1_TMGOBS  0xf46d
#define F0900_P1_ROLLOFF_STATUS  0xf46d00c0
#define F0900_P1_SCAN_SIGN  0xf46d0030
#define F0900_P1_TMG_SCANNING  0xf46d0008
#define F0900_P1_CHCENTERING_MODE  0xf46d0004
#define F0900_P1_TMG_SCANFAIL  0xf46d0002

/*P1_EQUALCFG*/
#define R0900_P1_EQUALCFG  0xf46f
#define F0900_P1_NOTMG_NEGALWAIT  0xf46f0080
#define F0900_P1_EQUAL_ON  0xf46f0040
#define F0900_P1_SEL_EQUALCOR  0xf46f0038
#define F0900_P1_MU_EQUALDFE  0xf46f0007

/*P1_EQUAI1*/
#define R0900_P1_EQUAI1  0xf470
#define F0900_P1_EQUA_ACCI1  0xf47001ff

/*P1_EQUAQ1*/
#define R0900_P1_EQUAQ1  0xf471
#define F0900_P1_EQUA_ACCQ1  0xf47101ff

/*P1_EQUAI2*/
#define R0900_P1_EQUAI2  0xf472
#define F0900_P1_EQUA_ACCI2  0xf47201ff

/*P1_EQUAQ2*/
#define R0900_P1_EQUAQ2  0xf473
#define F0900_P1_EQUA_ACCQ2  0xf47301ff

/*P1_EQUAI3*/
#define R0900_P1_EQUAI3  0xf474
#define F0900_P1_EQUA_ACCI3  0xf47401ff

/*P1_EQUAQ3*/
#define R0900_P1_EQUAQ3  0xf475
#define F0900_P1_EQUA_ACCQ3  0xf47501ff

/*P1_EQUAI4*/
#define R0900_P1_EQUAI4  0xf476
#define F0900_P1_EQUA_ACCI4  0xf47601ff

/*P1_EQUAQ4*/
#define R0900_P1_EQUAQ4  0xf477
#define F0900_P1_EQUA_ACCQ4  0xf47701ff

/*P1_EQUAI5*/
#define R0900_P1_EQUAI5  0xf478
#define F0900_P1_EQUA_ACCI5  0xf47801ff

/*P1_EQUAQ5*/
#define R0900_P1_EQUAQ5  0xf479
#define F0900_P1_EQUA_ACCQ5  0xf47901ff

/*P1_EQUAI6*/
#define R0900_P1_EQUAI6  0xf47a
#define F0900_P1_EQUA_ACCI6  0xf47a01ff

/*P1_EQUAQ6*/
#define R0900_P1_EQUAQ6  0xf47b
#define F0900_P1_EQUA_ACCQ6  0xf47b01ff

/*P1_EQUAI7*/
#define R0900_P1_EQUAI7  0xf47c
#define F0900_P1_EQUA_ACCI7  0xf47c01ff

/*P1_EQUAQ7*/
#define R0900_P1_EQUAQ7  0xf47d
#define F0900_P1_EQUA_ACCQ7  0xf47d01ff

/*P1_EQUAI8*/
#define R0900_P1_EQUAI8  0xf47e
#define F0900_P1_EQUA_ACCI8  0xf47e01ff

/*P1_EQUAQ8*/
#define R0900_P1_EQUAQ8  0xf47f
#define F0900_P1_EQUA_ACCQ8  0xf47f01ff

/*P1_NNOSDATAT1*/
#define R0900_P1_NNOSDATAT1  0xf480
#define F0900_P1_NOSDATAT_NORMED1  0xf48000ff

/*P1_NNOSDATAT0*/
#define R0900_P1_NNOSDATAT0  0xf481
#define F0900_P1_NOSDATAT_NORMED0  0xf48100ff

/*P1_NNOSDATA1*/
#define R0900_P1_NNOSDATA1  0xf482
#define F0900_P1_NOSDATA_NORMED1  0xf48200ff

/*P1_NNOSDATA0*/
#define R0900_P1_NNOSDATA0  0xf483
#define F0900_P1_NOSDATA_NORMED0  0xf48300ff

/*P1_NNOSPLHT1*/
#define R0900_P1_NNOSPLHT1  0xf484
#define F0900_P1_NOSPLHT_NORMED1  0xf48400ff

/*P1_NNOSPLHT0*/
#define R0900_P1_NNOSPLHT0  0xf485
#define F0900_P1_NOSPLHT_NORMED0  0xf48500ff

/*P1_NNOSPLH1*/
#define R0900_P1_NNOSPLH1  0xf486
#define F0900_P1_NOSPLH_NORMED1  0xf48600ff

/*P1_NNOSPLH0*/
#define R0900_P1_NNOSPLH0  0xf487
#define F0900_P1_NOSPLH_NORMED0  0xf48700ff

/*P1_NOSDATAT1*/
#define R0900_P1_NOSDATAT1  0xf488
#define F0900_P1_NOSDATAT_UNNORMED1  0xf48800ff

/*P1_NOSDATAT0*/
#define R0900_P1_NOSDATAT0  0xf489
#define F0900_P1_NOSDATAT_UNNORMED0  0xf48900ff

/*P1_NOSDATA1*/
#define R0900_P1_NOSDATA1  0xf48a
#define F0900_P1_NOSDATA_UNNORMED1  0xf48a00ff

/*P1_NOSDATA0*/
#define R0900_P1_NOSDATA0  0xf48b
#define F0900_P1_NOSDATA_UNNORMED0  0xf48b00ff

/*P1_NOSPLHT1*/
#define R0900_P1_NOSPLHT1  0xf48c
#define F0900_P1_NOSPLHT_UNNORMED1  0xf48c00ff

/*P1_NOSPLHT0*/
#define R0900_P1_NOSPLHT0  0xf48d
#define F0900_P1_NOSPLHT_UNNORMED0  0xf48d00ff

/*P1_NOSPLH1*/
#define R0900_P1_NOSPLH1  0xf48e
#define F0900_P1_NOSPLH_UNNORMED1  0xf48e00ff

/*P1_NOSPLH0*/
#define R0900_P1_NOSPLH0  0xf48f
#define F0900_P1_NOSPLH_UNNORMED0  0xf48f00ff

/*P1_CAR2CFG*/
#define R0900_P1_CAR2CFG  0xf490
#define F0900_P1_DESCRAMB_OFF  0xf4900080
#define F0900_P1_PN4_SELECT  0xf4900040
#define F0900_P1_CFR2_STOPDVBS1  0xf4900020
#define F0900_P1_STOP_CFR2UPDATE  0xf4900010
#define F0900_P1_STOP_NCO2UPDATE  0xf4900008
#define F0900_P1_ROTA2ON  0xf4900004
#define F0900_P1_PH_DET_ALGO2  0xf4900003

/*P1_ACLC2*/
#define R0900_P1_ACLC2  0xf491
#define F0900_P1_CAR2_PUNCT_ADERAT  0xf4910040
#define F0900_P1_CAR2_ALPHA_MANT  0xf4910030
#define F0900_P1_CAR2_ALPHA_EXP  0xf491000f

/*P1_BCLC2*/
#define R0900_P1_BCLC2  0xf492
#define F0900_P1_DVBS2_NIP  0xf4920080
#define F0900_P1_CAR2_PUNCT_BDERAT  0xf4920040
#define F0900_P1_CAR2_BETA_MANT  0xf4920030
#define F0900_P1_CAR2_BETA_EXP  0xf492000f

/*P1_CFR22*/
#define R0900_P1_CFR22  0xf493
#define F0900_P1_CAR2_FREQ2  0xf49301ff

/*P1_CFR21*/
#define R0900_P1_CFR21  0xf494
#define F0900_P1_CAR2_FREQ1  0xf49400ff

/*P1_CFR20*/
#define R0900_P1_CFR20  0xf495
#define F0900_P1_CAR2_FREQ0  0xf49500ff

/*P1_ACLC2S2Q*/
#define R0900_P1_ACLC2S2Q  0xf497
#define F0900_P1_ENAB_SPSKSYMB  0xf4970080
#define F0900_P1_CAR2S2_QADERAT  0xf4970040
#define F0900_P1_CAR2S2_Q_ALPH_M  0xf4970030
#define F0900_P1_CAR2S2_Q_ALPH_E  0xf497000f

/*P1_ACLC2S28*/
#define R0900_P1_ACLC2S28  0xf498
#define F0900_P1_OLDI3Q_MODE  0xf4980080
#define F0900_P1_CAR2S2_8ADERAT  0xf4980040
#define F0900_P1_CAR2S2_8_ALPH_M  0xf4980030
#define F0900_P1_CAR2S2_8_ALPH_E  0xf498000f

/*P1_ACLC2S216A*/
#define R0900_P1_ACLC2S216A  0xf499
#define F0900_P1_CAR2S2_16ADERAT  0xf4990040
#define F0900_P1_CAR2S2_16A_ALPH_M  0xf4990030
#define F0900_P1_CAR2S2_16A_ALPH_E  0xf499000f

/*P1_ACLC2S232A*/
#define R0900_P1_ACLC2S232A  0xf49a
#define F0900_P1_CAR2S2_32ADERAT  0xf49a0040
#define F0900_P1_CAR2S2_32A_ALPH_M  0xf49a0030
#define F0900_P1_CAR2S2_32A_ALPH_E  0xf49a000f

/*P1_BCLC2S2Q*/
#define R0900_P1_BCLC2S2Q  0xf49c
#define F0900_P1_DVBS2S2Q_NIP  0xf49c0080
#define F0900_P1_CAR2S2_QBDERAT  0xf49c0040
#define F0900_P1_CAR2S2_Q_BETA_M  0xf49c0030
#define F0900_P1_CAR2S2_Q_BETA_E  0xf49c000f

/*P1_BCLC2S28*/
#define R0900_P1_BCLC2S28  0xf49d
#define F0900_P1_DVBS2S28_NIP  0xf49d0080
#define F0900_P1_CAR2S2_8BDERAT  0xf49d0040
#define F0900_P1_CAR2S2_8_BETA_M  0xf49d0030
#define F0900_P1_CAR2S2_8_BETA_E  0xf49d000f

/*P1_BCLC2S216A*/
#define R0900_P1_BCLC2S216A  0xf49e
#define F0900_P1_DVBS2S216A_NIP  0xf49e0080
#define F0900_P1_CAR2S2_16BDERAT  0xf49e0040
#define F0900_P1_CAR2S2_16A_BETA_M  0xf49e0030
#define F0900_P1_CAR2S2_16A_BETA_E  0xf49e000f

/*P1_BCLC2S232A*/
#define R0900_P1_BCLC2S232A  0xf49f
#define F0900_P1_DVBS2S232A_NIP  0xf49f0080
#define F0900_P1_CAR2S2_32BDERAT  0xf49f0040
#define F0900_P1_CAR2S2_32A_BETA_M  0xf49f0030
#define F0900_P1_CAR2S2_32A_BETA_E  0xf49f000f

/*P1_PLROOT2*/
#define R0900_P1_PLROOT2  0xf4ac
#define F0900_P1_SHORTFR_DISABLE  0xf4ac0080
#define F0900_P1_LONGFR_DISABLE  0xf4ac0040
#define F0900_P1_DUMMYPL_DISABLE  0xf4ac0020
#define F0900_P1_SHORTFR_AVOID  0xf4ac0010
#define F0900_P1_PLSCRAMB_MODE  0xf4ac000c
#define F0900_P1_PLSCRAMB_ROOT2  0xf4ac0003

/*P1_PLROOT1*/
#define R0900_P1_PLROOT1  0xf4ad
#define F0900_P1_PLSCRAMB_ROOT1  0xf4ad00ff

/*P1_PLROOT0*/
#define R0900_P1_PLROOT0  0xf4ae
#define F0900_P1_PLSCRAMB_ROOT0  0xf4ae00ff

/*P1_MODCODLST0*/
#define R0900_P1_MODCODLST0  0xf4b0
#define F0900_P1_EN_TOKEN31  0xf4b00080
#define F0900_P1_SYNCTAG_SELECT  0xf4b00040
#define F0900_P1_MODCODRQ_MODE  0xf4b00030

/*P1_MODCODLST1*/
#define R0900_P1_MODCODLST1  0xf4b1
#define F0900_P1_DIS_MODCOD29  0xf4b100f0
#define F0900_P1_DIS_32PSK_9_10  0xf4b1000f

/*P1_MODCODLST2*/
#define R0900_P1_MODCODLST2  0xf4b2
#define F0900_P1_DIS_32PSK_8_9  0xf4b200f0
#define F0900_P1_DIS_32PSK_5_6  0xf4b2000f

/*P1_MODCODLST3*/
#define R0900_P1_MODCODLST3  0xf4b3
#define F0900_P1_DIS_32PSK_4_5  0xf4b300f0
#define F0900_P1_DIS_32PSK_3_4  0xf4b3000f

/*P1_MODCODLST4*/
#define R0900_P1_MODCODLST4  0xf4b4
#define F0900_P1_DIS_16PSK_9_10  0xf4b400f0
#define F0900_P1_DIS_16PSK_8_9  0xf4b4000f

/*P1_MODCODLST5*/
#define R0900_P1_MODCODLST5  0xf4b5
#define F0900_P1_DIS_16PSK_5_6  0xf4b500f0
#define F0900_P1_DIS_16PSK_4_5  0xf4b5000f

/*P1_MODCODLST6*/
#define R0900_P1_MODCODLST6  0xf4b6
#define F0900_P1_DIS_16PSK_3_4  0xf4b600f0
#define F0900_P1_DIS_16PSK_2_3  0xf4b6000f

/*P1_MODCODLST7*/
#define R0900_P1_MODCODLST7  0xf4b7
#define F0900_P1_DIS_8P_9_10  0xf4b700f0
#define F0900_P1_DIS_8P_8_9  0xf4b7000f

/*P1_MODCODLST8*/
#define R0900_P1_MODCODLST8  0xf4b8
#define F0900_P1_DIS_8P_5_6  0xf4b800f0
#define F0900_P1_DIS_8P_3_4  0xf4b8000f

/*P1_MODCODLST9*/
#define R0900_P1_MODCODLST9  0xf4b9
#define F0900_P1_DIS_8P_2_3  0xf4b900f0
#define F0900_P1_DIS_8P_3_5  0xf4b9000f

/*P1_MODCODLSTA*/
#define R0900_P1_MODCODLSTA  0xf4ba
#define F0900_P1_DIS_QP_9_10  0xf4ba00f0
#define F0900_P1_DIS_QP_8_9  0xf4ba000f

/*P1_MODCODLSTB*/
#define R0900_P1_MODCODLSTB  0xf4bb
#define F0900_P1_DIS_QP_5_6  0xf4bb00f0
#define F0900_P1_DIS_QP_4_5  0xf4bb000f

/*P1_MODCODLSTC*/
#define R0900_P1_MODCODLSTC  0xf4bc
#define F0900_P1_DIS_QP_3_4  0xf4bc00f0
#define F0900_P1_DIS_QP_2_3  0xf4bc000f

/*P1_MODCODLSTD*/
#define R0900_P1_MODCODLSTD  0xf4bd
#define F0900_P1_DIS_QP_3_5  0xf4bd00f0
#define F0900_P1_DIS_QP_1_2  0xf4bd000f

/*P1_MODCODLSTE*/
#define R0900_P1_MODCODLSTE  0xf4be
#define F0900_P1_DIS_QP_2_5  0xf4be00f0
#define F0900_P1_DIS_QP_1_3  0xf4be000f

/*P1_MODCODLSTF*/
#define R0900_P1_MODCODLSTF  0xf4bf
#define F0900_P1_DIS_QP_1_4  0xf4bf00f0
#define F0900_P1_DDEMOD_SET  0xf4bf0002
#define F0900_P1_DDEMOD_MASK  0xf4bf0001

/*P1_DMDRESCFG*/
#define R0900_P1_DMDRESCFG  0xf4c6
#define F0900_P1_DMDRES_RESET  0xf4c60080
#define F0900_P1_DMDRES_NOISESQR  0xf4c60010
#define F0900_P1_DMDRES_STRALL  0xf4c60008
#define F0900_P1_DMDRES_NEWONLY  0xf4c60004
#define F0900_P1_DMDRES_NOSTORE  0xf4c60002
#define F0900_P1_DMDRES_AGC2MEM  0xf4c60001

/*P1_DMDRESADR*/
#define R0900_P1_DMDRESADR  0xf4c7
#define F0900_P1_SUSP_PREDCANAL  0xf4c70080
#define F0900_P1_DMDRES_VALIDCFR  0xf4c70040
#define F0900_P1_DMDRES_MEMFULL  0xf4c70030
#define F0900_P1_DMDRES_RESNBR  0xf4c7000f

/*P1_DMDRESDATA7*/
#define R0900_P1_DMDRESDATA7  0xf4c8
#define F0900_P1_DMDRES_DATA7  0xf4c800ff

/*P1_DMDRESDATA6*/
#define R0900_P1_DMDRESDATA6  0xf4c9
#define F0900_P1_DMDRES_DATA6  0xf4c900ff

/*P1_DMDRESDATA5*/
#define R0900_P1_DMDRESDATA5  0xf4ca
#define F0900_P1_DMDRES_DATA5  0xf4ca00ff

/*P1_DMDRESDATA4*/
#define R0900_P1_DMDRESDATA4  0xf4cb
#define F0900_P1_DMDRES_DATA4  0xf4cb00ff

/*P1_DMDRESDATA3*/
#define R0900_P1_DMDRESDATA3  0xf4cc
#define F0900_P1_DMDRES_DATA3  0xf4cc00ff

/*P1_DMDRESDATA2*/
#define R0900_P1_DMDRESDATA2  0xf4cd
#define F0900_P1_DMDRES_DATA2  0xf4cd00ff

/*P1_DMDRESDATA1*/
#define R0900_P1_DMDRESDATA1  0xf4ce
#define F0900_P1_DMDRES_DATA1  0xf4ce00ff

/*P1_DMDRESDATA0*/
#define R0900_P1_DMDRESDATA0  0xf4cf
#define F0900_P1_DMDRES_DATA0  0xf4cf00ff

/*P1_FFEI1*/
#define R0900_P1_FFEI1  0xf4d0
#define F0900_P1_FFE_ACCI1  0xf4d001ff

/*P1_FFEQ1*/
#define R0900_P1_FFEQ1  0xf4d1
#define F0900_P1_FFE_ACCQ1  0xf4d101ff

/*P1_FFEI2*/
#define R0900_P1_FFEI2  0xf4d2
#define F0900_P1_FFE_ACCI2  0xf4d201ff

/*P1_FFEQ2*/
#define R0900_P1_FFEQ2  0xf4d3
#define F0900_P1_FFE_ACCQ2  0xf4d301ff

/*P1_FFEI3*/
#define R0900_P1_FFEI3  0xf4d4
#define F0900_P1_FFE_ACCI3  0xf4d401ff

/*P1_FFEQ3*/
#define R0900_P1_FFEQ3  0xf4d5
#define F0900_P1_FFE_ACCQ3  0xf4d501ff

/*P1_FFEI4*/
#define R0900_P1_FFEI4  0xf4d6
#define F0900_P1_FFE_ACCI4  0xf4d601ff

/*P1_FFEQ4*/
#define R0900_P1_FFEQ4  0xf4d7
#define F0900_P1_FFE_ACCQ4  0xf4d701ff

/*P1_FFECFG*/
#define R0900_P1_FFECFG  0xf4d8
#define F0900_P1_EQUALFFE_ON  0xf4d80040
#define F0900_P1_EQUAL_USEDSYMB  0xf4d80030
#define F0900_P1_MU_EQUALFFE  0xf4d80007

/*P1_TNRCFG*/
#define R0900_P1_TNRCFG  0xf4e0
#define F0900_P1_TUN_ACKFAIL  0xf4e00080
#define F0900_P1_TUN_TYPE  0xf4e00070
#define F0900_P1_TUN_SECSTOP  0xf4e00008
#define F0900_P1_TUN_VCOSRCH  0xf4e00004
#define F0900_P1_TUN_MADDRESS  0xf4e00003

/*P1_TNRCFG2*/
#define R0900_P1_TNRCFG2  0xf4e1
#define F0900_P1_TUN_IQSWAP  0xf4e10080
#define F0900_P1_STB6110_STEP2MHZ  0xf4e10040
#define F0900_P1_STB6120_DBLI2C  0xf4e10020
#define F0900_P1_DIS_FCCK  0xf4e10010
#define F0900_P1_DIS_LPEN  0xf4e10008
#define F0900_P1_DIS_BWCALC  0xf4e10004
#define F0900_P1_SHORT_WAITSTATES  0xf4e10002
#define F0900_P1_DIS_2BWAGC1  0xf4e10001

/*P1_TNRXTAL*/
#define R0900_P1_TNRXTAL  0xf4e4
#define F0900_P1_TUN_MCLKDECIMAL  0xf4e400e0
#define F0900_P1_TUN_XTALFREQ  0xf4e4001f

/*P1_TNRSTEPS*/
#define R0900_P1_TNRSTEPS  0xf4e7
#define F0900_P1_TUNER_BW1P6  0xf4e70080
#define F0900_P1_BWINC_OFFSET  0xf4e70070
#define F0900_P1_SOFTSTEP_RNG  0xf4e70008
#define F0900_P1_TUN_BWOFFSET  0xf4e70107

/*P1_TNRGAIN*/
#define R0900_P1_TNRGAIN  0xf4e8
#define F0900_P1_TUN_KDIVEN  0xf4e800c0
#define F0900_P1_STB6X00_OCK  0xf4e80030
#define F0900_P1_TUN_GAIN  0xf4e8000f

/*P1_TNRRF1*/
#define R0900_P1_TNRRF1  0xf4e9
#define F0900_P1_TUN_RFFREQ2  0xf4e900ff

/*P1_TNRRF0*/
#define R0900_P1_TNRRF0  0xf4ea
#define F0900_P1_TUN_RFFREQ1  0xf4ea00ff

/*P1_TNRBW*/
#define R0900_P1_TNRBW  0xf4eb
#define F0900_P1_TUN_RFFREQ0  0xf4eb00c0
#define F0900_P1_TUN_BW  0xf4eb003f

/*P1_TNRADJ*/
#define R0900_P1_TNRADJ  0xf4ec
#define F0900_P1_STB61X0_RCLK  0xf4ec0080
#define F0900_P1_STB61X0_CALTIME  0xf4ec0040
#define F0900_P1_STB6X00_DLB  0xf4ec0038
#define F0900_P1_STB6000_FCL  0xf4ec0007

/*P1_TNRCTL2*/
#define R0900_P1_TNRCTL2  0xf4ed
#define F0900_P1_STB61X0_LCP1_RCCKOFF  0xf4ed0080
#define F0900_P1_STB61X0_LCP0  0xf4ed0040
#define F0900_P1_STB61X0_XTOUT_RFOUTS  0xf4ed0020
#define F0900_P1_STB61X0_XTON_MCKDV  0xf4ed0010
#define F0900_P1_STB61X0_CALOFF_DCOFF  0xf4ed0008
#define F0900_P1_STB6110_LPT  0xf4ed0004
#define F0900_P1_STB6110_RX  0xf4ed0002
#define F0900_P1_STB6110_SYN  0xf4ed0001

/*P1_TNRCFG3*/
#define R0900_P1_TNRCFG3  0xf4ee
#define F0900_P1_STB6120_DISCTRL1  0xf4ee0080
#define F0900_P1_STB6120_INVORDER  0xf4ee0040
#define F0900_P1_STB6120_ENCTRL6  0xf4ee0020
#define F0900_P1_TUN_PLLFREQ  0xf4ee001c
#define F0900_P1_TUN_I2CFREQ_MODE  0xf4ee0003

/*P1_TNRLAUNCH*/
#define R0900_P1_TNRLAUNCH  0xf4f0

/*P1_TNRLD*/
#define R0900_P1_TNRLD  0xf4f0
#define F0900_P1_TUNLD_VCOING  0xf4f00080
#define F0900_P1_TUN_REG1FAIL  0xf4f00040
#define F0900_P1_TUN_REG2FAIL  0xf4f00020
#define F0900_P1_TUN_REG3FAIL  0xf4f00010
#define F0900_P1_TUN_REG4FAIL  0xf4f00008
#define F0900_P1_TUN_REG5FAIL  0xf4f00004
#define F0900_P1_TUN_BWING  0xf4f00002
#define F0900_P1_TUN_LOCKED  0xf4f00001

/*P1_TNROBSL*/
#define R0900_P1_TNROBSL  0xf4f6
#define F0900_P1_TUN_I2CABORTED  0xf4f60080
#define F0900_P1_TUN_LPEN  0xf4f60040
#define F0900_P1_TUN_FCCK  0xf4f60020
#define F0900_P1_TUN_I2CLOCKED  0xf4f60010
#define F0900_P1_TUN_PROGDONE  0xf4f6000c
#define F0900_P1_TUN_RFRESTE1  0xf4f60003

/*P1_TNRRESTE*/
#define R0900_P1_TNRRESTE  0xf4f7
#define F0900_P1_TUN_RFRESTE0  0xf4f700ff

/*P1_SMAPCOEF7*/
#define R0900_P1_SMAPCOEF7  0xf500
#define F0900_P1_DIS_QSCALE  0xf5000080
#define F0900_P1_SMAPCOEF_Q_LLR12  0xf500017f

/*P1_SMAPCOEF6*/
#define R0900_P1_SMAPCOEF6  0xf501
#define F0900_P1_DIS_NEWSCALE  0xf5010008
#define F0900_P1_ADJ_8PSKLLR1  0xf5010004
#define F0900_P1_OLD_8PSKLLR1  0xf5010002
#define F0900_P1_DIS_AB8PSK  0xf5010001

/*P1_SMAPCOEF5*/
#define R0900_P1_SMAPCOEF5  0xf502
#define F0900_P1_DIS_8SCALE  0xf5020080
#define F0900_P1_SMAPCOEF_8P_LLR23  0xf502017f

/*P1_DMDPLHSTAT*/
#define R0900_P1_DMDPLHSTAT  0xf520
#define F0900_P1_PLH_STATISTIC  0xf52000ff

/*P1_LOCKTIME3*/
#define R0900_P1_LOCKTIME3  0xf522
#define F0900_P1_DEMOD_LOCKTIME3  0xf52200ff

/*P1_LOCKTIME2*/
#define R0900_P1_LOCKTIME2  0xf523
#define F0900_P1_DEMOD_LOCKTIME2  0xf52300ff

/*P1_LOCKTIME1*/
#define R0900_P1_LOCKTIME1  0xf524
#define F0900_P1_DEMOD_LOCKTIME1  0xf52400ff

/*P1_LOCKTIME0*/
#define R0900_P1_LOCKTIME0  0xf525
#define F0900_P1_DEMOD_LOCKTIME0  0xf52500ff

/*P1_VITSCALE*/
#define R0900_P1_VITSCALE  0xf532
#define F0900_P1_NVTH_NOSRANGE  0xf5320080
#define F0900_P1_VERROR_MAXMODE  0xf5320040
#define F0900_P1_KDIV_MODE  0xf5320030
#define F0900_P1_NSLOWSN_LOCKED  0xf5320008
#define F0900_P1_DELOCK_PRFLOSS  0xf5320004
#define F0900_P1_DIS_RSFLOCK  0xf5320002

/*P1_FECM*/
#define R0900_P1_FECM  0xf533
#define F0900_P1_DSS_DVB  0xf5330080
#define F0900_P1_DEMOD_BYPASS  0xf5330040
#define F0900_P1_CMP_SLOWMODE  0xf5330020
#define F0900_P1_DSS_SRCH  0xf5330010
#define F0900_P1_DIFF_MODEVIT  0xf5330004
#define F0900_P1_SYNCVIT  0xf5330002
#define F0900_P1_IQINV  0xf5330001

/*P1_VTH12*/
#define R0900_P1_VTH12  0xf534
#define F0900_P1_VTH12  0xf53400ff

/*P1_VTH23*/
#define R0900_P1_VTH23  0xf535
#define F0900_P1_VTH23  0xf53500ff

/*P1_VTH34*/
#define R0900_P1_VTH34  0xf536
#define F0900_P1_VTH34  0xf53600ff

/*P1_VTH56*/
#define R0900_P1_VTH56  0xf537
#define F0900_P1_VTH56  0xf53700ff

/*P1_VTH67*/
#define R0900_P1_VTH67  0xf538
#define F0900_P1_VTH67  0xf53800ff

/*P1_VTH78*/
#define R0900_P1_VTH78  0xf539
#define F0900_P1_VTH78  0xf53900ff

/*P1_VITCURPUN*/
#define R0900_P1_VITCURPUN  0xf53a
#define F0900_P1_VIT_MAPPING  0xf53a00e0
#define F0900_P1_VIT_CURPUN  0xf53a001f

/*P1_VERROR*/
#define R0900_P1_VERROR  0xf53b
#define F0900_P1_REGERR_VIT  0xf53b00ff

/*P1_PRVIT*/
#define R0900_P1_PRVIT  0xf53c
#define F0900_P1_DIS_VTHLOCK  0xf53c0040
#define F0900_P1_E7_8VIT  0xf53c0020
#define F0900_P1_E6_7VIT  0xf53c0010
#define F0900_P1_E5_6VIT  0xf53c0008
#define F0900_P1_E3_4VIT  0xf53c0004
#define F0900_P1_E2_3VIT  0xf53c0002
#define F0900_P1_E1_2VIT  0xf53c0001

/*P1_VAVSRVIT*/
#define R0900_P1_VAVSRVIT  0xf53d
#define F0900_P1_AMVIT  0xf53d0080
#define F0900_P1_FROZENVIT  0xf53d0040
#define F0900_P1_SNVIT  0xf53d0030
#define F0900_P1_TOVVIT  0xf53d000c
#define F0900_P1_HYPVIT  0xf53d0003

/*P1_VSTATUSVIT*/
#define R0900_P1_VSTATUSVIT  0xf53e
#define F0900_P1_VITERBI_ON  0xf53e0080
#define F0900_P1_END_LOOPVIT  0xf53e0040
#define F0900_P1_VITERBI_DEPRF  0xf53e0020
#define F0900_P1_PRFVIT  0xf53e0010
#define F0900_P1_LOCKEDVIT  0xf53e0008
#define F0900_P1_VITERBI_DELOCK  0xf53e0004
#define F0900_P1_VIT_DEMODSEL  0xf53e0002
#define F0900_P1_VITERBI_COMPOUT  0xf53e0001

/*P1_VTHINUSE*/
#define R0900_P1_VTHINUSE  0xf53f
#define F0900_P1_VIT_INUSE  0xf53f00ff

/*P1_KDIV12*/
#define R0900_P1_KDIV12  0xf540
#define F0900_P1_KDIV12_MANUAL  0xf5400080
#define F0900_P1_K_DIVIDER_12  0xf540007f

/*P1_KDIV23*/
#define R0900_P1_KDIV23  0xf541
#define F0900_P1_KDIV23_MANUAL  0xf5410080
#define F0900_P1_K_DIVIDER_23  0xf541007f

/*P1_KDIV34*/
#define R0900_P1_KDIV34  0xf542
#define F0900_P1_KDIV34_MANUAL  0xf5420080
#define F0900_P1_K_DIVIDER_34  0xf542007f

/*P1_KDIV56*/
#define R0900_P1_KDIV56  0xf543
#define F0900_P1_KDIV56_MANUAL  0xf5430080
#define F0900_P1_K_DIVIDER_56  0xf543007f

/*P1_KDIV67*/
#define R0900_P1_KDIV67  0xf544
#define F0900_P1_KDIV67_MANUAL  0xf5440080
#define F0900_P1_K_DIVIDER_67  0xf544007f

/*P1_KDIV78*/
#define R0900_P1_KDIV78  0xf545
#define F0900_P1_KDIV78_MANUAL  0xf5450080
#define F0900_P1_K_DIVIDER_78  0xf545007f

/*P1_PDELCTRL1*/
#define R0900_P1_PDELCTRL1  0xf550
#define F0900_P1_INV_MISMASK  0xf5500080
#define F0900_P1_FORCE_ACCEPTED  0xf5500040
#define F0900_P1_FILTER_EN  0xf5500020
#define F0900_P1_FORCE_PKTDELINUSE  0xf5500010
#define F0900_P1_HYSTEN  0xf5500008
#define F0900_P1_HYSTSWRST  0xf5500004
#define F0900_P1_EN_MIS00  0xf5500002
#define F0900_P1_ALGOSWRST  0xf5500001

/*P1_PDELCTRL2*/
#define R0900_P1_PDELCTRL2  0xf551
#define F0900_P1_FORCE_CONTINUOUS  0xf5510080
#define F0900_P1_RESET_UPKO_COUNT  0xf5510040
#define F0900_P1_USER_PKTDELIN_NB  0xf5510020
#define F0900_P1_FORCE_LOCKED  0xf5510010
#define F0900_P1_DATA_UNBBSCRAM  0xf5510008
#define F0900_P1_FORCE_LONGPKT  0xf5510004
#define F0900_P1_FRAME_MODE  0xf5510002

/*P1_HYSTTHRESH*/
#define R0900_P1_HYSTTHRESH  0xf554
#define F0900_P1_UNLCK_THRESH  0xf55400f0
#define F0900_P1_DELIN_LCK_THRESH  0xf554000f

/*P1_ISIENTRY*/
#define R0900_P1_ISIENTRY  0xf55e
#define F0900_P1_ISI_ENTRY  0xf55e00ff

/*P1_ISIBITENA*/
#define R0900_P1_ISIBITENA  0xf55f
#define F0900_P1_ISI_BIT_EN  0xf55f00ff

/*P1_MATSTR1*/
#define R0900_P1_MATSTR1  0xf560
#define F0900_P1_MATYPE_CURRENT1  0xf56000ff

/*P1_MATSTR0*/
#define R0900_P1_MATSTR0  0xf561
#define F0900_P1_MATYPE_CURRENT0  0xf56100ff

/*P1_UPLSTR1*/
#define R0900_P1_UPLSTR1  0xf562
#define F0900_P1_UPL_CURRENT1  0xf56200ff

/*P1_UPLSTR0*/
#define R0900_P1_UPLSTR0  0xf563
#define F0900_P1_UPL_CURRENT0  0xf56300ff

/*P1_DFLSTR1*/
#define R0900_P1_DFLSTR1  0xf564
#define F0900_P1_DFL_CURRENT1  0xf56400ff

/*P1_DFLSTR0*/
#define R0900_P1_DFLSTR0  0xf565
#define F0900_P1_DFL_CURRENT0  0xf56500ff

/*P1_SYNCSTR*/
#define R0900_P1_SYNCSTR  0xf566
#define F0900_P1_SYNC_CURRENT  0xf56600ff

/*P1_SYNCDSTR1*/
#define R0900_P1_SYNCDSTR1  0xf567
#define F0900_P1_SYNCD_CURRENT1  0xf56700ff

/*P1_SYNCDSTR0*/
#define R0900_P1_SYNCDSTR0  0xf568
#define F0900_P1_SYNCD_CURRENT0  0xf56800ff

/*P1_PDELSTATUS1*/
#define R0900_P1_PDELSTATUS1  0xf569
#define F0900_P1_PKTDELIN_DELOCK  0xf5690080
#define F0900_P1_SYNCDUPDFL_BADDFL  0xf5690040
#define F0900_P1_CONTINUOUS_STREAM  0xf5690020
#define F0900_P1_UNACCEPTED_STREAM  0xf5690010
#define F0900_P1_BCH_ERROR_FLAG  0xf5690008
#define F0900_P1_BBHCRCKO  0xf5690004
#define F0900_P1_PKTDELIN_LOCK  0xf5690002
#define F0900_P1_FIRST_LOCK  0xf5690001

/*P1_PDELSTATUS2*/
#define R0900_P1_PDELSTATUS2  0xf56a
#define F0900_P1_PKTDEL_DEMODSEL  0xf56a0080
#define F0900_P1_FRAME_MODCOD  0xf56a007c
#define F0900_P1_FRAME_TYPE  0xf56a0003

/*P1_BBFCRCKO1*/
#define R0900_P1_BBFCRCKO1  0xf56b
#define F0900_P1_BBHCRC_KOCNT1  0xf56b00ff

/*P1_BBFCRCKO0*/
#define R0900_P1_BBFCRCKO0  0xf56c
#define F0900_P1_BBHCRC_KOCNT0  0xf56c00ff

/*P1_UPCRCKO1*/
#define R0900_P1_UPCRCKO1  0xf56d
#define F0900_P1_PKTCRC_KOCNT1  0xf56d00ff

/*P1_UPCRCKO0*/
#define R0900_P1_UPCRCKO0  0xf56e
#define F0900_P1_PKTCRC_KOCNT0  0xf56e00ff

/*P1_TSSTATEM*/
#define R0900_P1_TSSTATEM  0xf570
#define F0900_P1_TSDIL_ON  0xf5700080
#define F0900_P1_TSSKIPRS_ON  0xf5700040
#define F0900_P1_TSRS_ON  0xf5700020
#define F0900_P1_TSDESCRAMB_ON  0xf5700010
#define F0900_P1_TSFRAME_MODE  0xf5700008
#define F0900_P1_TS_DISABLE  0xf5700004
#define F0900_P1_TSACM_MODE  0xf5700002
#define F0900_P1_TSOUT_NOSYNC  0xf5700001

/*P1_TSCFGH*/
#define R0900_P1_TSCFGH  0xf572
#define F0900_P1_TSFIFO_DVBCI  0xf5720080
#define F0900_P1_TSFIFO_SERIAL  0xf5720040
#define F0900_P1_TSFIFO_TEIUPDATE  0xf5720020
#define F0900_P1_TSFIFO_DUTY50  0xf5720010
#define F0900_P1_TSFIFO_HSGNLOUT  0xf5720008
#define F0900_P1_TSFIFO_ERRMODE  0xf5720006
#define F0900_P1_RST_HWARE  0xf5720001

/*P1_TSCFGM*/
#define R0900_P1_TSCFGM  0xf573
#define F0900_P1_TSFIFO_MANSPEED  0xf57300c0
#define F0900_P1_TSFIFO_PERMDATA  0xf5730020
#define F0900_P1_TSFIFO_NONEWSGNL  0xf5730010
#define F0900_P1_TSFIFO_BITSPEED  0xf5730008
#define F0900_P1_NPD_SPECDVBS2  0xf5730004
#define F0900_P1_TSFIFO_STOPCKDIS  0xf5730002
#define F0900_P1_TSFIFO_INVDATA  0xf5730001

/*P1_TSCFGL*/
#define R0900_P1_TSCFGL  0xf574
#define F0900_P1_TSFIFO_BCLKDEL1CK  0xf57400c0
#define F0900_P1_BCHERROR_MODE  0xf5740030
#define F0900_P1_TSFIFO_NSGNL2DATA  0xf5740008
#define F0900_P1_TSFIFO_EMBINDVB  0xf5740004
#define F0900_P1_TSFIFO_DPUNACT  0xf5740002
#define F0900_P1_TSFIFO_NPDOFF  0xf5740001

/*P1_TSINSDELH*/
#define R0900_P1_TSINSDELH  0xf576
#define F0900_P1_TSDEL_SYNCBYTE  0xf5760080
#define F0900_P1_TSDEL_XXHEADER  0xf5760040
#define F0900_P1_TSDEL_BBHEADER  0xf5760020
#define F0900_P1_TSDEL_DATAFIELD  0xf5760010
#define F0900_P1_TSINSDEL_ISCR  0xf5760008
#define F0900_P1_TSINSDEL_NPD  0xf5760004
#define F0900_P1_TSINSDEL_RSPARITY  0xf5760002
#define F0900_P1_TSINSDEL_CRC8  0xf5760001

/*P1_TSSPEED*/
#define R0900_P1_TSSPEED  0xf580
#define F0900_P1_TSFIFO_OUTSPEED  0xf58000ff

/*P1_TSSTATUS*/
#define R0900_P1_TSSTATUS  0xf581
#define F0900_P1_TSFIFO_LINEOK  0xf5810080
#define F0900_P1_TSFIFO_ERROR  0xf5810040
#define F0900_P1_TSFIFO_DATA7  0xf5810020
#define F0900_P1_TSFIFO_NOSYNC  0xf5810010
#define F0900_P1_ISCR_INITIALIZED  0xf5810008
#define F0900_P1_ISCR_UPDATED  0xf5810004
#define F0900_P1_SOFFIFO_UNREGUL  0xf5810002
#define F0900_P1_DIL_READY  0xf5810001

/*P1_TSSTATUS2*/
#define R0900_P1_TSSTATUS2  0xf582
#define F0900_P1_TSFIFO_DEMODSEL  0xf5820080
#define F0900_P1_TSFIFOSPEED_STORE  0xf5820040
#define F0900_P1_DILXX_RESET  0xf5820020
#define F0900_P1_TSSERIAL_IMPOS  0xf5820010
#define F0900_P1_TSFIFO_LINENOK  0xf5820008
#define F0900_P1_BITSPEED_EVENT  0xf5820004
#define F0900_P1_SCRAMBDETECT  0xf5820002
#define F0900_P1_ULDTV67_FALSELOCK  0xf5820001

/*P1_TSBITRATE1*/
#define R0900_P1_TSBITRATE1  0xf583
#define F0900_P1_TSFIFO_BITRATE1  0xf58300ff

/*P1_TSBITRATE0*/
#define R0900_P1_TSBITRATE0  0xf584
#define F0900_P1_TSFIFO_BITRATE0  0xf58400ff

/*P1_ERRCTRL1*/
#define R0900_P1_ERRCTRL1  0xf598
#define F0900_P1_ERR_SOURCE1  0xf59800f0
#define F0900_P1_NUM_EVENT1  0xf5980007

/*P1_ERRCNT12*/
#define R0900_P1_ERRCNT12  0xf599
#define F0900_P1_ERRCNT1_OLDVALUE  0xf5990080
#define F0900_P1_ERR_CNT12  0xf599007f

/*P1_ERRCNT11*/
#define R0900_P1_ERRCNT11  0xf59a
#define F0900_P1_ERR_CNT11  0xf59a00ff

/*P1_ERRCNT10*/
#define R0900_P1_ERRCNT10  0xf59b
#define F0900_P1_ERR_CNT10  0xf59b00ff

/*P1_ERRCTRL2*/
#define R0900_P1_ERRCTRL2  0xf59c
#define F0900_P1_ERR_SOURCE2  0xf59c00f0
#define F0900_P1_NUM_EVENT2  0xf59c0007

/*P1_ERRCNT22*/
#define R0900_P1_ERRCNT22  0xf59d
#define F0900_P1_ERRCNT2_OLDVALUE  0xf59d0080
#define F0900_P1_ERR_CNT22  0xf59d007f

/*P1_ERRCNT21*/
#define R0900_P1_ERRCNT21  0xf59e
#define F0900_P1_ERR_CNT21  0xf59e00ff

/*P1_ERRCNT20*/
#define R0900_P1_ERRCNT20  0xf59f
#define F0900_P1_ERR_CNT20  0xf59f00ff

/*P1_FECSPY*/
#define R0900_P1_FECSPY  0xf5a0
#define F0900_P1_SPY_ENABLE  0xf5a00080
#define F0900_P1_NO_SYNCBYTE  0xf5a00040
#define F0900_P1_SERIAL_MODE  0xf5a00020
#define F0900_P1_UNUSUAL_PACKET  0xf5a00010
#define F0900_P1_BER_PACKMODE  0xf5a00008
#define F0900_P1_BERMETER_LMODE  0xf5a00002
#define F0900_P1_BERMETER_RESET  0xf5a00001

/*P1_FSPYCFG*/
#define R0900_P1_FSPYCFG  0xf5a1
#define F0900_P1_FECSPY_INPUT  0xf5a100c0
#define F0900_P1_RST_ON_ERROR  0xf5a10020
#define F0900_P1_ONE_SHOT  0xf5a10010
#define F0900_P1_I2C_MODE  0xf5a1000c
#define F0900_P1_SPY_HYSTERESIS  0xf5a10003

/*P1_FSPYDATA*/
#define R0900_P1_FSPYDATA  0xf5a2
#define F0900_P1_SPY_STUFFING  0xf5a20080
#define F0900_P1_NOERROR_PKTJITTER  0xf5a20040
#define F0900_P1_SPY_CNULLPKT  0xf5a20020
#define F0900_P1_SPY_OUTDATA_MODE  0xf5a2001f

/*P1_FSPYOUT*/
#define R0900_P1_FSPYOUT  0xf5a3
#define F0900_P1_FSPY_DIRECT  0xf5a30080
#define F0900_P1_SPY_OUTDATA_BUS  0xf5a30038
#define F0900_P1_STUFF_MODE  0xf5a30007

/*P1_FSTATUS*/
#define R0900_P1_FSTATUS  0xf5a4
#define F0900_P1_SPY_ENDSIM  0xf5a40080
#define F0900_P1_VALID_SIM  0xf5a40040
#define F0900_P1_FOUND_SIGNAL  0xf5a40020
#define F0900_P1_DSS_SYNCBYTE  0xf5a40010
#define F0900_P1_RESULT_STATE  0xf5a4000f

/*P1_FBERCPT4*/
#define R0900_P1_FBERCPT4  0xf5a8
#define F0900_P1_FBERMETER_CPT4  0xf5a800ff

/*P1_FBERCPT3*/
#define R0900_P1_FBERCPT3  0xf5a9
#define F0900_P1_FBERMETER_CPT3  0xf5a900ff

/*P1_FBERCPT2*/
#define R0900_P1_FBERCPT2  0xf5aa
#define F0900_P1_FBERMETER_CPT2  0xf5aa00ff

/*P1_FBERCPT1*/
#define R0900_P1_FBERCPT1  0xf5ab
#define F0900_P1_FBERMETER_CPT1  0xf5ab00ff

/*P1_FBERCPT0*/
#define R0900_P1_FBERCPT0  0xf5ac
#define F0900_P1_FBERMETER_CPT0  0xf5ac00ff

/*P1_FBERERR2*/
#define R0900_P1_FBERERR2  0xf5ad
#define F0900_P1_FBERMETER_ERR2  0xf5ad00ff

/*P1_FBERERR1*/
#define R0900_P1_FBERERR1  0xf5ae
#define F0900_P1_FBERMETER_ERR1  0xf5ae00ff

/*P1_FBERERR0*/
#define R0900_P1_FBERERR0  0xf5af
#define F0900_P1_FBERMETER_ERR0  0xf5af00ff

/*P1_FSPYBER*/
#define R0900_P1_FSPYBER  0xf5b2
#define F0900_P1_FSPYOBS_XORREAD  0xf5b20040
#define F0900_P1_FSPYBER_OBSMODE  0xf5b20020
#define F0900_P1_FSPYBER_SYNCBYTE  0xf5b20010
#define F0900_P1_FSPYBER_UNSYNC  0xf5b20008
#define F0900_P1_FSPYBER_CTIME  0xf5b20007

/*RCCFGH*/
#define R0900_RCCFGH  0xf600
#define F0900_TSRCFIFO_DVBCI  0xf6000080
#define F0900_TSRCFIFO_SERIAL  0xf6000040
#define F0900_TSRCFIFO_DISABLE  0xf6000020
#define F0900_TSFIFO_2TORC  0xf6000010
#define F0900_TSRCFIFO_HSGNLOUT  0xf6000008
#define F0900_TSRCFIFO_ERRMODE  0xf6000006

/*TSGENERAL*/
#define R0900_TSGENERAL  0xf630
#define F0900_TSFIFO_BCLK1ALL  0xf6300020
#define F0900_MUXSTREAM_OUTMODE  0xf6300008
#define F0900_TSFIFO_PERMPARAL  0xf6300006
#define F0900_RST_REEDSOLO  0xf6300001

/*TSGENERAL1X*/
#define R0900_TSGENERAL1X  0xf670
#define F0900_TSFIFO1X_BCLK1ALL  0xf6700020
#define F0900_MUXSTREAM1X_OUTMODE  0xf6700008
#define F0900_TSFIFO1X_PERMPARAL  0xf6700006
#define F0900_RST1X_REEDSOLO  0xf6700001

/*NBITER_NF4*/
#define R0900_NBITER_NF4  0xfa03
#define F0900_NBITER_NF_QP_1_2  0xfa0300ff

/*NBITER_NF5*/
#define R0900_NBITER_NF5  0xfa04
#define F0900_NBITER_NF_QP_3_5  0xfa0400ff

/*NBITER_NF6*/
#define R0900_NBITER_NF6  0xfa05
#define F0900_NBITER_NF_QP_2_3  0xfa0500ff

/*NBITER_NF7*/
#define R0900_NBITER_NF7  0xfa06
#define F0900_NBITER_NF_QP_3_4  0xfa0600ff

/*NBITER_NF8*/
#define R0900_NBITER_NF8  0xfa07
#define F0900_NBITER_NF_QP_4_5  0xfa0700ff

/*NBITER_NF9*/
#define R0900_NBITER_NF9  0xfa08
#define F0900_NBITER_NF_QP_5_6  0xfa0800ff

/*NBITER_NF10*/
#define R0900_NBITER_NF10  0xfa09
#define F0900_NBITER_NF_QP_8_9  0xfa0900ff

/*NBITER_NF11*/
#define R0900_NBITER_NF11  0xfa0a
#define F0900_NBITER_NF_QP_9_10  0xfa0a00ff

/*NBITER_NF12*/
#define R0900_NBITER_NF12  0xfa0b
#define F0900_NBITER_NF_8P_3_5  0xfa0b00ff

/*NBITER_NF13*/
#define R0900_NBITER_NF13  0xfa0c
#define F0900_NBITER_NF_8P_2_3  0xfa0c00ff

/*NBITER_NF14*/
#define R0900_NBITER_NF14  0xfa0d
#define F0900_NBITER_NF_8P_3_4  0xfa0d00ff

/*NBITER_NF15*/
#define R0900_NBITER_NF15  0xfa0e
#define F0900_NBITER_NF_8P_5_6  0xfa0e00ff

/*NBITER_NF16*/
#define R0900_NBITER_NF16  0xfa0f
#define F0900_NBITER_NF_8P_8_9  0xfa0f00ff

/*NBITER_NF17*/
#define R0900_NBITER_NF17  0xfa10
#define F0900_NBITER_NF_8P_9_10  0xfa1000ff

/*NBITERNOERR*/
#define R0900_NBITERNOERR  0xfa3f
#define F0900_NBITER_STOP_CRIT  0xfa3f000f

/*GAINLLR_NF4*/
#define R0900_GAINLLR_NF4  0xfa43
#define F0900_GAINLLR_NF_QP_1_2  0xfa43007f

/*GAINLLR_NF5*/
#define R0900_GAINLLR_NF5  0xfa44
#define F0900_GAINLLR_NF_QP_3_5  0xfa44007f

/*GAINLLR_NF6*/
#define R0900_GAINLLR_NF6  0xfa45
#define F0900_GAINLLR_NF_QP_2_3  0xfa45007f

/*GAINLLR_NF7*/
#define R0900_GAINLLR_NF7  0xfa46
#define F0900_GAINLLR_NF_QP_3_4  0xfa46007f

/*GAINLLR_NF8*/
#define R0900_GAINLLR_NF8  0xfa47
#define F0900_GAINLLR_NF_QP_4_5  0xfa47007f

/*GAINLLR_NF9*/
#define R0900_GAINLLR_NF9  0xfa48
#define F0900_GAINLLR_NF_QP_5_6  0xfa48007f

/*GAINLLR_NF10*/
#define R0900_GAINLLR_NF10  0xfa49
#define F0900_GAINLLR_NF_QP_8_9  0xfa49007f

/*GAINLLR_NF11*/
#define R0900_GAINLLR_NF11  0xfa4a
#define F0900_GAINLLR_NF_QP_9_10  0xfa4a007f

/*GAINLLR_NF12*/
#define R0900_GAINLLR_NF12  0xfa4b
#define F0900_GAINLLR_NF_8P_3_5  0xfa4b007f

/*GAINLLR_NF13*/
#define R0900_GAINLLR_NF13  0xfa4c
#define F0900_GAINLLR_NF_8P_2_3  0xfa4c007f

/*GAINLLR_NF14*/
#define R0900_GAINLLR_NF14  0xfa4d
#define F0900_GAINLLR_NF_8P_3_4  0xfa4d007f

/*GAINLLR_NF15*/
#define R0900_GAINLLR_NF15  0xfa4e
#define F0900_GAINLLR_NF_8P_5_6  0xfa4e007f

/*GAINLLR_NF16*/
#define R0900_GAINLLR_NF16  0xfa4f
#define F0900_GAINLLR_NF_8P_8_9  0xfa4f007f

/*GAINLLR_NF17*/
#define R0900_GAINLLR_NF17  0xfa50
#define F0900_GAINLLR_NF_8P_9_10  0xfa50007f

/*CFGEXT*/
#define R0900_CFGEXT  0xfa80
#define F0900_STAGMODE  0xfa800080
#define F0900_BYPBCH  0xfa800040
#define F0900_BYPLDPC  0xfa800020
#define F0900_LDPCMODE  0xfa800010
#define F0900_INVLLRSIGN  0xfa800008
#define F0900_SHORTMULT  0xfa800004
#define F0900_EXTERNTX  0xfa800001

/*GENCFG*/
#define R0900_GENCFG  0xfa86
#define F0900_BROADCAST  0xfa860010
#define F0900_NOSHFRD2  0xfa860008
#define F0900_BCHERRFLAG  0xfa860004
#define F0900_PRIORITY  0xfa860002
#define F0900_DDEMOD  0xfa860001

/*LDPCERR1*/
#define R0900_LDPCERR1  0xfa96
#define F0900_LDPC_ERRORS_COUNTER1  0xfa9600ff

/*LDPCERR0*/
#define R0900_LDPCERR0  0xfa97
#define F0900_LDPC_ERRORS_COUNTER0  0xfa9700ff

/*BCHERR*/
#define R0900_BCHERR  0xfa98
#define F0900_ERRORFLAG  0xfa980010
#define F0900_BCH_ERRORS_COUNTER  0xfa98000f

/*TSTRES0*/
#define R0900_TSTRES0  0xff11
#define F0900_FRESFEC  0xff110080
#define F0900_FRESTS  0xff110040
#define F0900_FRESVIT1  0xff110020
#define F0900_FRESVIT2  0xff110010
#define F0900_FRESSYM1  0xff110008
#define F0900_FRESSYM2  0xff110004
#define F0900_FRESMAS  0xff110002
#define F0900_FRESINT  0xff110001

/*P2_TSTDISRX*/
#define R0900_P2_TSTDISRX  0xff65
#define F0900_P2_EN_DISRX  0xff650080
#define F0900_P2_TST_CURRSRC  0xff650040
#define F0900_P2_IN_DIGSIGNAL  0xff650020
#define F0900_P2_HIZ_CURRENTSRC  0xff650010
#define F0900_TST_P2_PIN_SELECT  0xff650008
#define F0900_P2_TST_DISRX  0xff650007

/*P1_TSTDISRX*/
#define R0900_P1_TSTDISRX  0xff67
#define F0900_P1_EN_DISRX  0xff670080
#define F0900_P1_TST_CURRSRC  0xff670040
#define F0900_P1_IN_DIGSIGNAL  0xff670020
#define F0900_P1_HIZ_CURRENTSRC  0xff670010
#define F0900_TST_P1_PIN_SELECT  0xff670008
#define F0900_P1_TST_DISRX  0xff670007

#define STV0900_NBREGS		684
#define STV0900_NBFIELDS		1702

#endif
