/*
 * arch/arm/mach-0x820/include/mach/irqs.h
 *
 * Copyright (C) 2009 Oxford Semiconductor Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __ASM_ARCH_IRQS_H
#define __ASM_ARCH_IRQS_H

/* Definitions for direct access to RPS interrupts */
#define DIRECT_RPS_FIQ_INTERRUPT		0
#define DIRECT_RPS_SOFTWARE_INTERRUPT	1
#define DIRECT_RPS_COMMRX_INTERRUPT		2
#define DIRECT_RPS_COMMTX_INTERRUPT		3
#define DIRECT_RPS_TIMER_1_INTERRUPT	4
#define DIRECT_RPS_TIMER_2_INTERRUPT	5
#define DIRECT_RPS_IRRX_INTERRUPT		6
#define DIRECT_RPS_USBHOST_INTERRUPT	7
#define DIRECT_RPS_MAC_INTERRUPT		8
#define DIRECT_RPS_MAC_2_INTERRUPT		9
#define DIRECT_RPS_SEM_A_INTERRUPT 		10
#define DIRECT_RPS_SEM_B_INTERRUPT 		11
#define DIRECT_RPS_SEM_C_INTERRUPT		12
#define DIRECT_RPS_DMA_INTERRUPT_0		13
#define DIRECT_RPS_DMA_INTERRUPT_1		14
#define DIRECT_RPS_DMA_INTERRUPT_2		15
#define DIRECT_RPS_DMA_INTERRUPT_3		16
#define DIRECT_RPS_DMA_INTERRUPT_4		17
#define DIRECT_RPS_SATA_INTERRUPT		18
#define DIRECT_RPS_PCIEA_INTERRUPT		19
#define DIRECT_RPS_PCIEB_INTERRUPT		20
#define DIRECT_RPS_GPIOA_INTERRUPT		21
#define DIRECT_RPS_GPIOB_INTERRUPT		22
#define DIRECT_RPS_UART_1_INTERRUPT		23
#define DIRECT_RPS_UART_2_INTERRUPT		24
#define DIRECT_RPS_AUDIO_DATA_INTERRUPT	25
#define DIRECT_RPS_AUDIO_ERR_INTERRUPT	26
#define DIRECT_RPS_CIPHERD_INTERRUPT	27
#define DIRECT_RPS_CIPHERE_INTERRUPT	28
#define DIRECT_RPS_SD_INTERRUPT			29
#define DIRECT_RPS_USBDEV_INTERRUPT		30

/* Definitions for the RPS core irq controller */
#define OX820_RPS_IRQ_START 64
#define NR_RPS_IRQS 32

#define RPS_FIQ_INTERRUPT			(OX820_RPS_IRQ_START +  0)
#define RPS_SOFTWARE_INTERRUPT		(OX820_RPS_IRQ_START +  1)
#define RPS_COMMRX_INTERRUPT		(OX820_RPS_IRQ_START +  2)
#define RPS_COMMTX_INTERRUPT		(OX820_RPS_IRQ_START +  3)
#define RPS_TIMER_1_INTERRUPT		(OX820_RPS_IRQ_START +  4)
#define RPS_TIMER_2_INTERRUPT		(OX820_RPS_IRQ_START +  5)
#define RPS_IRRX_INTERRUPT			(OX820_RPS_IRQ_START +  6)
#define RPS_USBHOST_INTERRUPT		(OX820_RPS_IRQ_START +  7)
#define RPS_MAC_INTERRUPT			(OX820_RPS_IRQ_START +  8)
#define RPS_MAC_2_INTERRUPT			(OX820_RPS_IRQ_START +  9)
#define RPS_SEM_A_INTERRUPT 		(OX820_RPS_IRQ_START + 10)
#define RPS_SEM_B_INTERRUPT 		(OX820_RPS_IRQ_START + 11)
#define RPS_SEM_C_INTERRUPT			(OX820_RPS_IRQ_START + 12)
#define RPS_DMA_INTERRUPT_0			(OX820_RPS_IRQ_START + 13)
#define RPS_DMA_INTERRUPT_1			(OX820_RPS_IRQ_START + 14)
#define RPS_DMA_INTERRUPT_2			(OX820_RPS_IRQ_START + 15)
#define RPS_DMA_INTERRUPT_3			(OX820_RPS_IRQ_START + 16)
#define RPS_DMA_INTERRUPT_4			(OX820_RPS_IRQ_START + 17)
#define RPS_SATA_INTERRUPT			(OX820_RPS_IRQ_START + 18)
#define RPS_PCIEA_INTERRUPT			(OX820_RPS_IRQ_START + 19)
#define RPS_PCIEB_INTERRUPT			(OX820_RPS_IRQ_START + 20)
#define RPS_GPIOA_INTERRUPT			(OX820_RPS_IRQ_START + 21)
#define RPS_GPIOB_INTERRUPT			(OX820_RPS_IRQ_START + 22)
#define RPS_UART_1_INTERRUPT		(OX820_RPS_IRQ_START + 23)
#define RPS_UART_2_INTERRUPT		(OX820_RPS_IRQ_START + 24)
#define RPS_AUDIO_DATA_INTERRUPT	(OX820_RPS_IRQ_START + 25)
#define RPS_AUDIO_ERR_INTERRUPT		(OX820_RPS_IRQ_START + 26)
#define RPS_CIPHERD_INTERRUPT		(OX820_RPS_IRQ_START + 27)
#define RPS_CIPHERE_INTERRUPT		(OX820_RPS_IRQ_START + 28)
#define RPS_SD_INTERRUPT			(OX820_RPS_IRQ_START + 29)
#define RPS_USBDEV_INTERRUPT		(OX820_RPS_IRQ_START + 30)

#define OX820_GIC_IRQ_START  32
#define NR_GIC_IRQS (OX820_GIC_IRQ_START + 32)

/* The per CPU timer interrupt */
#define IRQ_LOCALTIMER            (29)

#define RPSC_FIQ_INTERRUPT 			(OX820_GIC_IRQ_START +  2)
#define RPSC_IRQ_INTERRUPT 			(OX820_GIC_IRQ_START +  3)
#define RPSA_FIQ_INTERRUPT 			(OX820_GIC_IRQ_START +  4)
#define RPSA_IRQ_INTERRUPT 			(OX820_GIC_IRQ_START +  5)
#define IRRX_INTERRUPT				(OX820_GIC_IRQ_START +  6)
#define USBHOST_INTERRUPT			(OX820_GIC_IRQ_START +  7)
#define MAC_INTERRUPT				(OX820_GIC_IRQ_START +  8)
#define MAC_2_INTERRUPT				(OX820_GIC_IRQ_START +  9)
#define SEM_A_INTERRUPT 			(OX820_GIC_IRQ_START + 10)
#define SEM_B_INTERRUPT 			(OX820_GIC_IRQ_START + 11)
#define SEM_C_INTERRUPT 			(OX820_GIC_IRQ_START + 12)
#define DMA_INTERRUPT_0 			(OX820_GIC_IRQ_START + 13)
#define DMA_INTERRUPT_1 			(OX820_GIC_IRQ_START + 14)
#define DMA_INTERRUPT_2 			(OX820_GIC_IRQ_START + 15)
#define DMA_INTERRUPT_3 			(OX820_GIC_IRQ_START + 16)
#define DMA_INTERRUPT_4				(OX820_GIC_IRQ_START + 17)
#define SATA_INTERRUPT				(OX820_GIC_IRQ_START + 18)
#define PCIEA_INTERRUPT				(OX820_GIC_IRQ_START + 19)
#define PCIEB_INTERRUPT				(OX820_GIC_IRQ_START + 20)
#define GPIOA_INTERRUPT				(OX820_GIC_IRQ_START + 21)
#define GPIOB_INTERRUPT				(OX820_GIC_IRQ_START + 22)
#define UART_1_INTERRUPT 			(OX820_GIC_IRQ_START + 23)
#define UART_2_INTERRUPT 			(OX820_GIC_IRQ_START + 24)
#define AUDIO_DATA_INTERRUPT		(OX820_GIC_IRQ_START + 25)
#define AUDIO_ERR_INTERRUPT			(OX820_GIC_IRQ_START + 26)
#define CIPHERD_INTERRUPT			(OX820_GIC_IRQ_START + 27)
#define CIPHERE_INTERRUPT			(OX820_GIC_IRQ_START + 28)
#define SD_INTERRUPT				(OX820_GIC_IRQ_START + 29)
#define USBDEV_INTERRUPT			(OX820_GIC_IRQ_START + 30)

/* Definitions for the ARM11's GIC IRQ controller */ 
#define NR_IRQS (NR_GIC_IRQS + NR_RPS_IRQS) /* 96 RPS*/

#endif // __ASM_ARCH_IRQ_H
