/*
// I retain copyright in this code but I encourage its free use provided
// that I don't carry any responsibility for the results. I am especially 
// happy to see it used in free and open source software. If you do use 
// it I would appreciate an acknowledgement of its origin in the code or
// the product that results and I would also appreciate knowing a little
// about the use to which it is being put. I am grateful to Frank Yellin
// for some ideas that are used in this implementation.
//
// Dr B. R. Gladman <brg@gladman.uk.net> 6th April 2001.
//
// This is an implementation of the AES encryption algorithm (Rijndael)
// designed by Joan Daemen and Vincent Rijmen. This version is designed
// to provide both fixed and dynamic block and key lengths and can also 
// run with either big or little endian internal byte order (see aes.h). 
// It inputs block and key lengths in bytes with the legal values being 
// 16, 24 and 32.
*
*/

#ifdef __KERNEL__
#include <linux/types.h>
#else
#include <sys/types.h>
#endif
#include "crypto/aes_cbc.h"
#include "crypto/cbc_generic.h"

/* returns bool success */
int AES_set_key(aes_context *aes_ctx, const u_int8_t *key, int keysize) {
	aes_set_key(aes_ctx, key, keysize, 0);
	return 1;	
}
CBC_IMPL_BLK16(AES_cbc_encrypt, aes_context, u_int8_t *, aes_encrypt, aes_decrypt);


/*
 * $Log: aes_cbc.c,v $
 * Revision 1.1  2008/05/20 12:26:18  evantu
 * from freescale BSP: ltib-mpc8548cds-20071214
 *
 *  Modified Files:
 *  	Kconfig Makefile ipv4/af_inet.c
 *  Added Files:
 *  	ipsec/Kconfig ipsec/Makefile ipsec/Makefile.ver
 *  	ipsec/README-zlib ipsec/addrtoa.c ipsec/addrtot.c
 *  	ipsec/addrtypeof.c ipsec/adler32.c ipsec/anyaddr.c
 *  	ipsec/datatot.c ipsec/defconfig ipsec/deflate.c
 *  	ipsec/deflate.h ipsec/goodmask.c ipsec/infblock.c
 *  	ipsec/infblock.h ipsec/infcodes.c ipsec/infcodes.h
 *  	ipsec/inffast.c ipsec/inffast.h ipsec/inffixed.h
 *  	ipsec/inflate.c ipsec/inftrees.c ipsec/inftrees.h
 *  	ipsec/infutil.c ipsec/infutil.h ipsec/initaddr.c
 *  	ipsec/ipcomp.c ipsec/ipsec_ah.c ipsec/ipsec_alg.c
 *  	ipsec/ipsec_alg_cryptoapi.c ipsec/ipsec_esp.c
 *  	ipsec/ipsec_init.c ipsec/ipsec_ipcomp.c ipsec/ipsec_ipip.c
 *  	ipsec/ipsec_kern24.c ipsec/ipsec_life.c ipsec/ipsec_mast.c
 *  	ipsec/ipsec_md5c.c ipsec/ipsec_ocf.c ipsec/ipsec_ocf.h
 *  	ipsec/ipsec_proc.c ipsec/ipsec_radij.c ipsec/ipsec_rcv.c
 *  	ipsec/ipsec_sa.c ipsec/ipsec_sha1.c ipsec/ipsec_snprintf.c
 *  	ipsec/ipsec_tunnel.c ipsec/ipsec_xform.c ipsec/ipsec_xmit.c
 *  	ipsec/match586.S ipsec/match686.S ipsec/pfkey_v2.c
 *  	ipsec/pfkey_v2_build.c ipsec/pfkey_v2_debug.c
 *  	ipsec/pfkey_v2_ext_bits.c ipsec/pfkey_v2_ext_process.c
 *  	ipsec/pfkey_v2_parse.c ipsec/pfkey_v2_parser.c ipsec/prng.c
 *  	ipsec/radij.c ipsec/rangetoa.c ipsec/satot.c ipsec/subnetof.c
 *  	ipsec/subnettoa.c ipsec/sysctl_net_ipsec.c ipsec/trees.c
 *  	ipsec/trees.h ipsec/ultoa.c ipsec/ultot.c ipsec/version.c
 *  	ipsec/zutil.c ipsec/aes/Makefile ipsec/aes/aes-i586.S
 *  	ipsec/aes/aes.c ipsec/aes/aes_cbc.c ipsec/aes/aes_xcbc_mac.c
 *  	ipsec/aes/ipsec_alg_aes.c ipsec/alg/Config.alg_aes.in
 *  	ipsec/alg/Config.alg_cryptoapi.in ipsec/alg/Config.in
 *  	ipsec/alg/Makefile.alg_aes ipsec/alg/Makefile.alg_cryptoapi
 *  	ipsec/alg/ipsec_alg_cryptoapi.c
 *  	ipsec/alg/scripts/mk-static_init.c.sh ipsec/des/COPYRIGHT
 *  	ipsec/des/INSTALL ipsec/des/Makefile ipsec/des/README
 *  	ipsec/des/README.freeswan ipsec/des/VERSION
 *  	ipsec/des/cbc_enc.c ipsec/des/des.doc ipsec/des/des_enc.c
 *  	ipsec/des/des_opts.c ipsec/des/dx86unix.S ipsec/des/ecb_enc.c
 *  	ipsec/des/ipsec_alg_3des.c ipsec/des/set_key.c
 *  	ipsec/des/asm/des-586.pl ipsec/des/asm/des686.pl
 *  	ipsec/des/asm/desboth.pl ipsec/des/asm/readme
 *
 * Revision 1.2  2004/07/10 07:48:40  mcr
 * Moved from linux/crypto/ciphers/aes/aes_cbc.c,v
 *
 * Revision 1.1  2004/04/06 02:48:12  mcr
 * 	pullup of AES cipher from alg-branch.
 *
 *
 */
