// Copyright (c) 2003-2008 Synology Inc. All rights reserved.
#ifndef __SYNO_SATA_H_
#define __SYNO_SATA_H_

#define SYNO_SPINUP_DELAY_LABEL_JUMP(label)
#define SYNO_SPINUP_DELAY_LABEL(label)

/*
* We use g_internal_hd_num this variable pass from uboot for determine whether wake up in sequence.
* because if we need power in sequence at booting, 
* it's mean we also need wake up in sequence for power issue
*
* For old product, they don't passing g_internal_hd_num from u-boot, but in new kernel it had defined.
* so the default value is -1, it will still doing original job. So this define can compatible to old platform.
*/
#ifdef MY_ABC_HERE

extern long g_internal_hd_num;
extern long syno_boot_hd_count;

#if defined(CONFIG_SYNO_MPC85XX_COMMON) || defined(CONFIG_SYNO_MV88F5x8x)
#undef SYNO_SPINUP_DELAY_LABEL_JUMP
#undef SYNO_SPINUP_DELAY_LABEL

#define SYNO_SPINUP_DELAY_LABEL_JUMP(label) if(g_internal_hd_num == 0) goto label;
#define SYNO_SPINUP_DELAY_LABEL(label) label:;

#endif /* CONFIG_SYNO_MPC85XX_COMMON CONFIG_SYNO_MV88F5x8x */

static inline void SleepForHD(int i)
{
	if ( ( g_internal_hd_num < 0 ) || /* not specified in boot command line */
		 syno_boot_hd_count < g_internal_hd_num ) {
		printk("Delay 10 seconds to wait for disk %d ready.\n", i);
		mdelay(10000);
	}
	syno_boot_hd_count++;
}

static inline void SleepForHDAdditional(void)
{
	if (g_internal_hd_num != 0){
		mdelay(5000);
	}
}
#endif /* MY_ABC_HERE */

#endif /* __SYNO_SATA_H_ */
