#if !defined(COM_API_H)
#define COM_API_H
#define MAX_CDB_SIZE						16	//TBD

/* CDB definitions */
#define APICDB0_ADAPTER						0xF0
#define APICDB0_LD							0xF1
#define APICDB0_BLOCK						0xF2
#define APICDB0_PD							0xF3
#define APICDB0_EVENT						0xF4
#define APICDB0_DBG							0xF5
#define APICDB0_FLASH						0xF6

/*for Adapter*/
#define APICDB1_ADAPTER_GETCOUNT			0
#define APICDB1_ADAPTER_GETINFO				(APICDB1_ADAPTER_GETCOUNT+1)
#define APICDB1_ADAPTER_GETCONFIG			(APICDB1_ADAPTER_GETCOUNT+2)
#define APICDB1_ADAPTER_SETCONFIG			(APICDB1_ADAPTER_GETCOUNT+3)
#define APICDB1_ADAPTER_MAX					(APICDB1_ADAPTER_GETCOUNT+4)

/*for LD*/
#define APICDB1_LD_CREATE					0
#define APICDB1_LD_GETMAXSIZE				(APICDB1_LD_CREATE+1)
#define APICDB1_LD_GETINFO					(APICDB1_LD_CREATE+2)
#define APICDB1_LD_GETTARGETLDINFO			(APICDB1_LD_CREATE+3)
#define APICDB1_LD_DELETE					(APICDB1_LD_CREATE+4)
#define APICDB1_LD_GETSTATUS				(APICDB1_LD_CREATE+5)
#define APICDB1_LD_GETCONFIG				(APICDB1_LD_CREATE+6)
#define APICDB1_LD_SETCONFIG				(APICDB1_LD_CREATE+7)
#define APICDB1_LD_STARTREBUILD				(APICDB1_LD_CREATE+8)
#define APICDB1_LD_STARTCONSISTENCYCHECK	(APICDB1_LD_CREATE+9)
#define APICDB1_LD_STARTINIT				(APICDB1_LD_CREATE+10)
#define APICDB1_LD_STARTMIGRATION			(APICDB1_LD_CREATE+11)
#define APICDB1_LD_BGACONTROL				(APICDB1_LD_CREATE+12)
#define APICDB1_LD_WIPEMDD					(APICDB1_LD_CREATE+13)
#define APICDB1_LD_GETSPARESTATUS           (APICDB1_LD_CREATE+14)
#define APICDB1_LD_SETGLOBALSPARE			(APICDB1_LD_CREATE+15)
#define APICDB1_LD_SETLDSPARE				(APICDB1_LD_CREATE+16)
#define APICDB1_LD_REMOVESPARE              (APICDB1_LD_CREATE+17)
#define APICDB1_LD_HD_SETSTATUS				(APICDB1_LD_CREATE+18)
#define APICDB1_LD_SHUTDOWN					(APICDB1_LD_CREATE+19)
#define APICDB1_LD_HD_FREE_SPACE_INFO		(APICDB1_LD_CREATE+20)
#define APICDB1_LD_HD_GETMBRINFO			(APICDB1_LD_CREATE+21)
#define APICDB1_LD_MAX						(APICDB1_LD_CREATE+22)

/*for PD*/
#define APICDB1_PD_GETHD_INFO				0
#define APICDB1_PD_GETEXPANDER_INFO			(APICDB1_PD_GETHD_INFO+1)
#define APICDB1_PD_GETPM_INFO				(APICDB1_PD_GETHD_INFO+2)
#define APICDB1_PD_GETSETTING				(APICDB1_PD_GETHD_INFO+3)
#define APICDB1_PD_SETSETTING				(APICDB1_PD_GETHD_INFO+4)
#define APICDB1_PD_BSL_DUMP					(APICDB1_PD_GETHD_INFO+5)
#define APICDB1_PD_HD_MPCHECK				(APICDB1_PD_GETHD_INFO+6)
#define APICDB1_PD_HD_GETMPSTATUS			(APICDB1_PD_GETHD_INFO+7)
#define APICDB1_PD_GETSTATUS				(APICDB1_PD_GETHD_INFO+8)
#define APICDB1_PD_MAX						(APICDB1_PD_GETHD_INFO+9)

// Sub command for APICDB1_PD_SETSETTING
#define APICDB4_PD_SET_WRITE_CACHE_OFF		0
#define APICDB4_PD_SET_WRITE_CACHE_ON		1
#define APICDB4_PD_SET_SMART_OFF			2
#define APICDB4_PD_SET_SMART_ON				3
#define APICDB4_PD_SMART_RETURN_STATUS		4

/*for Block*/
#define APICDB1_BLOCK_GETINFO				0
#define APICDB1_BLOCK_HD_BLOCKIDS			(APICDB1_BLOCK_GETINFO+1)
#define APICDB1_BLOCK_MAX					(APICDB1_BLOCK_GETINFO+2)

/*for event*/
#define APICDB1_EVENT_GETEVENT				0
#define APICDB1_EVENT_MAX					(APICDB1_EVENT_GETEVENT + 1)

/*for DBG*/
#define APICDB1_DBG_PDWR					0
#define APICDB1_DBG_MAP						(APICDB1_DBG_PDWR+1)
#define APICDB1_DBG_MAX						(APICDB1_DBG_PDWR+2)

/*for FLASH*/
#define APICDB1_FLASH_BIN					0

#endif

