/*
 * @(#) ipsec_snprintf() function
 *
 * Copyright (C) 1998, 1999, 2000, 2001  Richard Guy Briggs <rgb@freeswan.org>
 *                                 2001  Michael Richardson <mcr@freeswan.org>
 * Copyright (C) 2005 Michael Richardson <mcr@xelerance.com>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * Split out from ipsec_proc.c.
 */

#ifndef AUTOCONF_INCLUDED
#include <linux/config.h>
#endif
#include <linux/version.h>
#define __NO_VERSION__
#include <linux/module.h>
#include <linux/kernel.h> /* printk() */

#include "openswan/ipsec_kversion.h"
#include "openswan/ipsec_param.h"

#include <net/ip.h>

#include "openswan/radij.h"

#include "openswan/ipsec_life.h"
#include "openswan/ipsec_stats.h"
#include "openswan/ipsec_sa.h"

#include "openswan/ipsec_encap.h"
#include "openswan/ipsec_radij.h"
#include "openswan/ipsec_xform.h"
#include "openswan/ipsec_tunnel.h"
#include "openswan/ipsec_xmit.h"

#include "openswan/ipsec_rcv.h"
#include "openswan/ipsec_ah.h"
#include "openswan/ipsec_esp.h"
#include "openswan/ipsec_kern24.h"

#ifdef CONFIG_KLIPS_IPCOMP
#include "openswan/ipcomp.h"
#endif /* CONFIG_KLIPS_IPCOMP */

#include "openswan/ipsec_proto.h"

#include <openswan/pfkeyv2.h>
#include <openswan/pfkey.h>

/* ipsec_snprintf: like snprintf except
 * - size is signed and a negative value is treated as if it were 0
 * - the returned result is never negative --
 *   an error generates a "?" or null output (depending on space).
 *   (Our callers are too lazy to check for an error return.)
 * 
 * @param buf String buffer
 * @param size Size of the string
 * @param fmt printf string
 * @param ... Variables to be displayed in fmt
 * @return int Return code
 */
int ipsec_snprintf(char *buf, ssize_t size, const char *fmt, ...)
{
       va_list args;
       int i;
       size_t possize = size < 0? 0 : size;
       va_start(args, fmt);
       i = vsnprintf(buf,possize,fmt,args);
       va_end(args);
       if (i < 0) {
           /* create empty output in place of error */
           i = 0;
           if (size > 0) {
               *buf = '\0';
           }
       }
       return i;
}


void ipsec_dmp_block(char *s, caddr_t bb, int len)
{
	int i;
	unsigned char *b = bb;

	printk("klips_dmp: "
	       "at %s, len=%d, ptr=%p\n", s, len, b);
	
        //if (len>512) len = 512;
  
	for(i = 0; i < len; i++ /*, c++*/) {
		if(!(i % 16)) {
			printk("klips_debug:   @%03x:",
			       i);
		}
		printk(" %02x", b[i]);
		if(!((i + 1) % 16)) {
			printk("\n");
		}
	}
	if(i % 16) {
		printk("\n");
	}
}
		
/*
 *
 * $Log: ipsec_snprintf.c,v $
 * Revision 1.1  2008-05-20 12:26:18  evantu
 * from freescale BSP: ltib-mpc8548cds-20071214
 *
 *  Modified Files:
 *  	Kconfig Makefile ipv4/af_inet.c
 *  Added Files:
 *  	ipsec/Kconfig ipsec/Makefile ipsec/Makefile.ver
 *  	ipsec/README-zlib ipsec/addrtoa.c ipsec/addrtot.c
 *  	ipsec/addrtypeof.c ipsec/adler32.c ipsec/anyaddr.c
 *  	ipsec/datatot.c ipsec/defconfig ipsec/deflate.c
 *  	ipsec/deflate.h ipsec/goodmask.c ipsec/infblock.c
 *  	ipsec/infblock.h ipsec/infcodes.c ipsec/infcodes.h
 *  	ipsec/inffast.c ipsec/inffast.h ipsec/inffixed.h
 *  	ipsec/inflate.c ipsec/inftrees.c ipsec/inftrees.h
 *  	ipsec/infutil.c ipsec/infutil.h ipsec/initaddr.c
 *  	ipsec/ipcomp.c ipsec/ipsec_ah.c ipsec/ipsec_alg.c
 *  	ipsec/ipsec_alg_cryptoapi.c ipsec/ipsec_esp.c
 *  	ipsec/ipsec_init.c ipsec/ipsec_ipcomp.c ipsec/ipsec_ipip.c
 *  	ipsec/ipsec_kern24.c ipsec/ipsec_life.c ipsec/ipsec_mast.c
 *  	ipsec/ipsec_md5c.c ipsec/ipsec_ocf.c ipsec/ipsec_ocf.h
 *  	ipsec/ipsec_proc.c ipsec/ipsec_radij.c ipsec/ipsec_rcv.c
 *  	ipsec/ipsec_sa.c ipsec/ipsec_sha1.c ipsec/ipsec_snprintf.c
 *  	ipsec/ipsec_tunnel.c ipsec/ipsec_xform.c ipsec/ipsec_xmit.c
 *  	ipsec/match586.S ipsec/match686.S ipsec/pfkey_v2.c
 *  	ipsec/pfkey_v2_build.c ipsec/pfkey_v2_debug.c
 *  	ipsec/pfkey_v2_ext_bits.c ipsec/pfkey_v2_ext_process.c
 *  	ipsec/pfkey_v2_parse.c ipsec/pfkey_v2_parser.c ipsec/prng.c
 *  	ipsec/radij.c ipsec/rangetoa.c ipsec/satot.c ipsec/subnetof.c
 *  	ipsec/subnettoa.c ipsec/sysctl_net_ipsec.c ipsec/trees.c
 *  	ipsec/trees.h ipsec/ultoa.c ipsec/ultot.c ipsec/version.c
 *  	ipsec/zutil.c ipsec/aes/Makefile ipsec/aes/aes-i586.S
 *  	ipsec/aes/aes.c ipsec/aes/aes_cbc.c ipsec/aes/aes_xcbc_mac.c
 *  	ipsec/aes/ipsec_alg_aes.c ipsec/alg/Config.alg_aes.in
 *  	ipsec/alg/Config.alg_cryptoapi.in ipsec/alg/Config.in
 *  	ipsec/alg/Makefile.alg_aes ipsec/alg/Makefile.alg_cryptoapi
 *  	ipsec/alg/ipsec_alg_cryptoapi.c
 *  	ipsec/alg/scripts/mk-static_init.c.sh ipsec/des/COPYRIGHT
 *  	ipsec/des/INSTALL ipsec/des/Makefile ipsec/des/README
 *  	ipsec/des/README.freeswan ipsec/des/VERSION
 *  	ipsec/des/cbc_enc.c ipsec/des/des.doc ipsec/des/des_enc.c
 *  	ipsec/des/des_opts.c ipsec/des/dx86unix.S ipsec/des/ecb_enc.c
 *  	ipsec/des/ipsec_alg_3des.c ipsec/des/set_key.c
 *  	ipsec/des/asm/des-586.pl ipsec/des/asm/des686.pl
 *  	ipsec/des/asm/desboth.pl ipsec/des/asm/readme
 *
 * Revision 1.3  2005/04/29 05:10:22  mcr
 * 	removed from extraenous includes to make unit testing easier.
 *
 * Revision 1.2  2005/04/15 00:32:01  mcr
 * 	added ipsec_dmp_block routine.
 *
 *
 * Local Variables:
 * c-file-style: "linux"
 * End:
 *
 */

