/*
 * Definitions relevant to IPSEC lifetimes
 * Copyright (C) 2001  Richard Guy Briggs  <rgb@freeswan.org>
 *                 and Michael Richardson  <mcr@freeswan.org>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: ipsec_life.h,v 1.1 2008-05-20 09:52:53 evantu Exp $
 *
 * This file derived from ipsec_xform.h on 2001/9/18 by mcr.
 *
 */

/* 
 * This file describes the book keeping fields for the 
 *   IPsec Security Association Structure. ("ipsec_sa")
 *
 * This structure is never allocated directly by kernel code,
 * (it is always a static/auto or is part of a structure)
 * so it does not have a reference count.
 *
 */

#ifndef _IPSEC_LIFE_H_

/*
 *  _count is total count.
 *  _hard is hard limit (kill SA after this number)
 *  _soft is soft limit (try to renew SA after this number)
 *  _last is used in some special cases.
 *
 */

struct ipsec_lifetime64
{
	__u64           ipl_count;
	__u64           ipl_soft;
	__u64           ipl_hard;
	__u64           ipl_last;  
};

struct ipsec_lifetimes
{
	/* number of bytes processed */
	struct ipsec_lifetime64 ipl_bytes;

	/* number of packets processed */
	struct ipsec_lifetime64 ipl_packets;

	/* time since SA was added */
	struct ipsec_lifetime64 ipl_addtime;

	/* time since SA was first used */
	struct ipsec_lifetime64 ipl_usetime;

	/* from rfc2367:  
         *         For CURRENT, the number of different connections,
         *         endpoints, or flows that the association has been
         *          allocated towards. For HARD and SOFT, the number of
         *          these the association may be allocated towards
         *          before it expires. The concept of a connection,
         *          flow, or endpoint is system specific.
	 *
	 * mcr(2001-9-18) it is unclear what purpose these serve for FreeSWAN.
	 *          They are maintained for PF_KEY compatibility. 
	 */
	struct ipsec_lifetime64 ipl_allocations;
};

enum ipsec_life_alive {
	ipsec_life_harddied = -1,
	ipsec_life_softdied = 0,
	ipsec_life_okay     = 1
};

enum ipsec_life_type {
	ipsec_life_timebased = 1,
	ipsec_life_countbased= 0
};

#define _IPSEC_LIFE_H_
#endif /* _IPSEC_LIFE_H_ */


/*
 * $Log: ipsec_life.h,v $
 * Revision 1.1  2008-05-20 09:52:53  evantu
 * code from freescale BSP: ltib-mpc8548cds-20071214
 *
 *  Modified Files:
 *  	linux/miscdevice.h linux/rio_drv.h linux/rio.h linux/skbuff.h
 *  Added Files:
 *  	linux/ctswic.h linux/debugfs_circular.h mast.h crypto/aes.h
 *  	crypto/aes_cbc.h crypto/aes_xcbc_mac.h crypto/cbc_generic.h
 *  	crypto/des.h crypto/ocf_assist.h des/des_locl.h des/des_ver.h
 *  	des/podd.h des/sk.h des/spr.h opencrypto/crypto.h
 *  	opencrypto/cryptodev.h opencrypto/cryptoprof.h
 *  	openswan/ipcomp.h openswan/ipsec_ah.h openswan/ipsec_alg.h
 *  	openswan/ipsec_alg_3des.h openswan/ipsec_auth.h
 *  	openswan/ipsec_debug.h openswan/ipsec_encap.h
 *  	openswan/ipsec_eroute.h openswan/ipsec_errs.h
 *  	openswan/ipsec_esp.h openswan/ipsec_ipcomp.h
 *  	openswan/ipsec_ipe4.h openswan/ipsec_ipip.h
 *  	openswan/ipsec_kern24.h openswan/ipsec_kversion.h
 *  	openswan/ipsec_life.h openswan/ipsec_md5h.h
 *  	openswan/ipsec_param.h openswan/ipsec_policy.h
 *  	openswan/ipsec_proto.h openswan/ipsec_radij.h
 *  	openswan/ipsec_rcv.h openswan/ipsec_sa.h openswan/ipsec_sha1.h
 *  	openswan/ipsec_stats.h openswan/ipsec_tunnel.h
 *  	openswan/ipsec_xform.h openswan/ipsec_xmit.h
 *  	openswan/passert.h openswan/pfkey.h openswan/pfkey_debug.h
 *  	openswan/pfkeyv2.h openswan/radij.h
 *
 * Revision 1.4  2004/04/05 19:55:05  mcr
 * Moved from linux/include/freeswan/ipsec_life.h,v
 *
 * Revision 1.3  2002/04/24 07:36:46  mcr
 * Moved from ./klips/net/ipsec/ipsec_life.h,v
 *
 * Revision 1.2  2001/11/26 09:16:14  rgb
 * Merge MCR's ipsec_sa, eroute, proc and struct lifetime changes.
 *
 * Revision 1.1.2.1  2001/09/25 02:25:58  mcr
 * 	lifetime structure created and common functions created.
 *
 *
 * Local variables:
 * c-file-style: "linux"
 * End:
 *
 */
