/*
 * @(#) definition of ipsec_errs structure
 *
 * Copyright (C) 2001  Richard Guy Briggs  <rgb@freeswan.org>
 *                 and Michael Richardson  <mcr@freeswan.org>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: ipsec_errs.h,v 1.1 2008-05-20 09:52:53 evantu Exp $
 *
 */

/* 
 * This file describes the errors/statistics that FreeSWAN collects.
 *
 */

struct ipsec_errs {
	__u32		ips_alg_errs;	       /* number of algorithm errors */
	__u32		ips_auth_errs;	       /* # of authentication errors */
	__u32		ips_encsize_errs;      /* # of encryption size errors*/
	__u32		ips_encpad_errs;       /* # of encryption pad  errors*/
	__u32		ips_replaywin_errs;    /* # of pkt sequence errors */
};

/*
 * $Log: ipsec_errs.h,v $
 * Revision 1.1  2008-05-20 09:52:53  evantu
 * code from freescale BSP: ltib-mpc8548cds-20071214
 *
 *  Modified Files:
 *  	linux/miscdevice.h linux/rio_drv.h linux/rio.h linux/skbuff.h
 *  Added Files:
 *  	linux/ctswic.h linux/debugfs_circular.h mast.h crypto/aes.h
 *  	crypto/aes_cbc.h crypto/aes_xcbc_mac.h crypto/cbc_generic.h
 *  	crypto/des.h crypto/ocf_assist.h des/des_locl.h des/des_ver.h
 *  	des/podd.h des/sk.h des/spr.h opencrypto/crypto.h
 *  	opencrypto/cryptodev.h opencrypto/cryptoprof.h
 *  	openswan/ipcomp.h openswan/ipsec_ah.h openswan/ipsec_alg.h
 *  	openswan/ipsec_alg_3des.h openswan/ipsec_auth.h
 *  	openswan/ipsec_debug.h openswan/ipsec_encap.h
 *  	openswan/ipsec_eroute.h openswan/ipsec_errs.h
 *  	openswan/ipsec_esp.h openswan/ipsec_ipcomp.h
 *  	openswan/ipsec_ipe4.h openswan/ipsec_ipip.h
 *  	openswan/ipsec_kern24.h openswan/ipsec_kversion.h
 *  	openswan/ipsec_life.h openswan/ipsec_md5h.h
 *  	openswan/ipsec_param.h openswan/ipsec_policy.h
 *  	openswan/ipsec_proto.h openswan/ipsec_radij.h
 *  	openswan/ipsec_rcv.h openswan/ipsec_sa.h openswan/ipsec_sha1.h
 *  	openswan/ipsec_stats.h openswan/ipsec_tunnel.h
 *  	openswan/ipsec_xform.h openswan/ipsec_xmit.h
 *  	openswan/passert.h openswan/pfkey.h openswan/pfkey_debug.h
 *  	openswan/pfkeyv2.h openswan/radij.h
 *
 * Revision 1.4  2004/04/05 19:55:05  mcr
 * Moved from linux/include/freeswan/ipsec_errs.h,v
 *
 * Revision 1.3  2002/04/24 07:36:46  mcr
 * Moved from ./klips/net/ipsec/ipsec_errs.h,v
 *
 * Revision 1.2  2001/11/26 09:16:13  rgb
 * Merge MCR's ipsec_sa, eroute, proc and struct lifetime changes.
 *
 * Revision 1.1.2.1  2001/09/25 02:25:57  mcr
 * 	lifetime structure created and common functions created.
 *
 *
 * Local variables:
 * c-file-style: "linux"
 * End:
 *
 */
