#ifndef _LINEAR_H
#define _LINEAR_H

#include <linux/raid/md.h>

struct dev_info {
	mdk_rdev_t	*rdev;
#ifdef MD_BACK_PORTING
	sector_t	num_sectors;
	sector_t	start_sector;
#else
	sector_t        size;
	sector_t        offset;
#endif
};

typedef struct dev_info dev_info_t;

struct linear_private_data
{
	struct linear_private_data *prev;	/* earlier version */
	dev_info_t		**hash_table;
	sector_t		hash_spacing;
#ifdef MD_BACK_PORTING
	sector_t		array_sectors;
#else
    sector_t                array_size;
#endif
	int			preshift; /* shift before dividing by hash_spacing */
	dev_info_t		disks[0];
};


typedef struct linear_private_data linear_conf_t;

#define mddev_to_conf(mddev) ((linear_conf_t *) mddev->private)

#endif
