/*
 * Copyright (C) 2005-2007 Freescale Semiconductor, Inc. All rights reserved.
 *
 * Author: Razvan Ionescu, razvan.ionescu@freescale.com, May 2005
 *
 * This file is part of the Linux kernel
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of  the GNU General  Public License as published by
 * the Free Software Foundation;  either version 2 of the  License, or
 * (at your option) any later version.
 *
 */
#ifndef CT_SWIC_H_
#define CT_SWIC_H_

#define CT_TASK_CREATE    (0x2a100000)
#define CT_TASK_ENTER     (0x2a200000)
#define CT_TASK_DELETE    (0x2a300000)
#define CT_TASK_EXIT      (0x2a400000)
#define CT_ISR_ENTER      (0x2a500000)
#define CT_ISR_EXIT       (0x2a600000)

#define CT_TASK_NAMES     (0x00020000)
#define CT_TASK_IDS       (0x00010000)

/* 
 * u32 type must be defined by the header user before inclusion
 */

typedef struct Q_Tag {
	u32 tag ;
	u32 a_time ;
} Q_Tag ;

#define HOOK_BUFFER_SIZE  2048  /* must be a power of two */

struct Hook_Buffer {
	int head ;
	volatile int tail ;
	Q_Tag buffer[HOOK_BUFFER_SIZE] ;
} ;

#endif
