/*
 * Freescale MPC83xx DMA XOR Engine support
 *
 * Copyright (C) 2008 Freescale Semiconductor, Inc. All rights reserved.
 *
 * Author:
 *   Dipen Dudhat <Dipen.Dudhat@freescale.com>, Nov 2008
 *   Surender Kumar <R66464@freescale.com>, Feb 2008
 *   Vishnu Suresh <Vishnu@freescale.com>, Feb  2008
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

#ifndef DMAXOR_H
#define DMAXOR_H

#include <linux/module.h>
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/cache.h>
#include <linux/device.h>
#include <linux/dmaengine.h>
#include <linux/dma-mapping.h>
#include <linux/dmapool.h>
#include "../crypto/t23x/common/xwcRMinterface.h"
#include "../crypto/t23x/common/t23.h"

#ifndef BOOLEAN
#define BOOLEAN uint16_t
#endif

#define INITIAL_FSL_DESC_COUNT 0x200
#define NUM_SRC_DWORD (TOTAL_PAIRS - 1)
#define XOR_MAX_PAGE_SIZE (0xFFFFu)
#define MAX_DPD_FIFO 24

#ifdef DEBUG
#warning Debug On
#endif

struct fsl_xor_xwc_msg {
	struct list_head node;
	RMexecMessage exec_msg;
	T2DPD dpd[MAX_DPD_FIFO];
	struct fsl_xor_desc *dpd_desc[MAX_DPD_FIFO];
};

struct fsl_xor_xwc_device {
	RMinterfaceCtx *if_ctx;
	struct list_head free_list;
	struct list_head in_process_list;
	struct list_head pending_list;
	spinlock_t msg_q_lock;	/* Lock for the queues of message */
};

struct fsl_xor_desc {
	struct dma_async_tx_descriptor async_tx;
	struct list_head node;
	dma_addr_t dest;
	dma_addr_t src_list[NUM_SRC_DWORD];
	uint16_t count;
	uint16_t size;
	void (*release_hdl) (void *);
	void *release_arg;
	dma_addr_t next_ld_desc;
	struct fsl_xor_chan *cur_chan;
	int32_t status;
};

struct fsl_xor_dma_device {
	struct device *dev;
	struct dma_device common;
	struct fsl_xor_chan *chan;
};

struct fsl_xor_chan {
	dma_cookie_t completed_cookie;	/* The maximum cookie completed */
	dma_cookie_t submitted_cookie;
	spinlock_t desc_lock;	/* lock for tx queue */
	struct list_head tx_desc_q;
	struct list_head free_desc;
	struct fsl_xor_dma_device *device;
	struct dma_chan common;
	struct dma_async_tx_descriptor *cur_tx;
	struct dma_pool *desc_pool;
	int32_t id;		/* Raw id of this channel */
	struct device *chan_dev;
};

int32_t fsl_xor_xwc_request(struct fsl_xor_desc *desc);
void fsl_xor_xwc_alloc_resource(void);
void fsl_xor_xwc_free_resource(void);
int32_t fsl_xor_xwc_init(void);
void fsl_xor_xwc_exit(void);

#endif /* DMAXOR_H */
