# This flags will be used only by the Marvell arch files compilation.

ARCHI=$(shell echo $(ARCH) | /usr/bin/tr [a-z] [A-Z])

# General definitions
CPU_ARCH    = $(ARCHI)
CHIP        = 88FXX81
#CHIP_DEFINE = 88F5181
VENDOR      = Marvell
ifeq ($(CONFIG_CPU_BIG_ENDIAN_BSP),y)
ENDIAN      = BE
else
ENDIAN      = LE
endif

# Internal definitions
MV_DEFINE = -DMV_LINUX -DMV_CPU_$(ENDIAN) -DMV_$(CPU_ARCH) 

EXTRA_CFLAGS 	+= $(MV_DEFINE)

ifeq ($(CONFIG_SATA_DEBUG_ON_ERROR_BSP),y)
EXTRA_CFLAGS    += -DMV_LOG_ERROR
endif

ifeq ($(CONFIG_SATA_FULL_DEBUG_BSP),y)
EXTRA_CFLAGS    += -DMV_LOG_DEBUG
endif

ifeq ($(CONFIG_MV_SATA_SUPPORT_ATAPI_BSP),y)
EXTRA_CFLAGS    += -DMV_SUPPORT_ATAPI
endif

ifeq ($(CONFIG_MV_SATA_ENABLE_1MB_IOS_BSP),y)
EXTRA_CFLAGS    += -DMV_SUPPORT_1MBYTE_IOS
endif

ifeq ($(CONFIG_MV88F5182),y)
EXTRA_CFLAGS    += -DMV_88F5182 -DUSB_UNDERRUN_WA
endif

ifeq ($(CONFIG_MV88F5082),y)
EXTRA_CFLAGS    += -DMV_88F5082 -DUSB_UNDERRUN_WA
endif

ifeq ($(CONFIG_MV88F5181),y)
EXTRA_CFLAGS    += -DMV_88F5181
endif

ifeq ($(CONFIG_MV88F5180N),y)
EXTRA_CFLAGS    += -DMV_88F5180N
endif

ifeq ($(CONFIG_MV88F1181),y)
EXTRA_CFLAGS    += -DMV_88F1181
endif

ifeq ($(CONFIG_MV88F1281),y)
EXTRA_CFLAGS    += -DMV_88F1281
endif


ifeq ($(CONFIG_MV88F6082),y)
EXTRA_CFLAGS    += -DMV_88F6082
endif


ifeq ($(CONFIG_MV88F5181L),y)
EXTRA_CFLAGS    += -DMV_88F5181L -DUSB_UNDERRUN_WA
endif

ifeq ($(CONFIG_MV88W8660),y)
EXTRA_CFLAGS    += -DMV_88W8660
endif


