#ifndef TALITOS_XWC_H 
#define TALITOS_XWC_H

#include "../cryptodev.h"
#include "../ocf-compat.h"
#include "../../../drivers/crypto/t23x/t23xrm/t23xrmInternal.h"

/*
 * Holds data specific to a single talitos device.
 */
struct talitos_softc {
	softc_device_decl	sc_cdev;
	int32_t		sc_cid;			/* crypto tag */
	int32_t		sc_num;			/* if we have multiple chips */
	int			sc_nsessions;
	struct talitos_session	*sc_sessions;
    int         sc_num_channels;/* number of crypto channels */
    int         sc_chfifo_len;  /* channel fetch fifo len */
    int         sc_exec_units;  /* execution units mask */
    int         sc_desc_types;  /* descriptor types mask */
	RMinterfaceCtx *interface;
};

struct talitos_session {
	u_int32_t	ses_used;
	u_int32_t	ses_klen;		/* key length in bits */
	u_int32_t	ses_key[8];		/* DES/3DES/AES key */
	u_int32_t	ses_hmac[5];		/* hmac inner state */
	u_int32_t	ses_hmac_len;		/* hmac length */
	u_int32_t	ses_iv[4];		/* DES/3DES/AES iv */
	u_int32_t	ses_mlen;		/* desired hash result len (12=ipsec or 16) */
};

#define	TALITOS_SESSION(sid)	((sid) & 0x0fffffff)
#define	TALITOS_SID(crd, sesn)	(((crd) << 28) | ((sesn) & 0x0fffffff))

#endif
