#!/bin/sh
synofam=comcerto2k
synolxa=3.2.40
synolva=25426

doOptional=false
useDebianSource=false

gitam() {
  p=$1
  b=`basename $p`
  echo $b
  git am < $p
}

. ./build-env.sh

if [ "X$1" != "X" ]; then
  synolva=$1
fi

synolxa=${lxsocva}
if [ "${synolxa:0:5}" = "3.10." ]; then
  if [ ${synolva} -gt 15152 ]; then
    synolxa=3.10.105
  elif [ ${synolva} -gt 8451 ]; then
    synolxa=3.10.102
  elif [ ${synolva} -gt 5644 ]; then
    synolxa=3.10.77
  elif [ ${synolva} -gt 5004 ]; then
    synolxa=3.10.35
  fi

  if [ ${synolva} -lt 5644 ]; then
    synofam=x64
  else
    synofam=armada38x
  fi
fi

if [ ${synolva} -lt 3200 ]; then
  synolxa=3.2.11
elif [ ${synolva} -lt 3700 ]; then
  synolxa=3.2.30
fi

if [ ${synolva} -lt 3203 ]; then
  synofam=x64
elif [ ${synolva} -lt 4450 ]; then
  synofam=armada370
fi

synofaa=${synofam}
if [ "X$2" != "X" ]; then
  synofam=$2
fi

if [ ${synolva} -lt 2636 -o ${synofam} = 88f628x -o ${synofam} = qoriq -o ${synofam} = 853x ]; then
  synolxa=2.6.32
  synofaa=88f628x
fi

if [ -e build-env-${synofam}.sh ]; then
  echo "Using build-env-${synofam}.sh"
  . ./build-env-${synofam}.sh
fi

export ARCH=arm64
if [ "X${BSP_ARCH}" = "Xarmhf" ]; then
  export ARCH=arm
  export CROSS_COMPILE=arm-linux-gnueabihf-

elif [ "X${BSP_ARCH}" = "Xamd64" ]; then
  export ARCH=x86
  export CROSS_COMPILE=x86_64-linux-gnu-

elif [ "X${BSP_ARCH}" = "Xi686" ]; then
  export ARCH=x86
  export CROSS_COMPILE=i686-linux-gnu-
elif [ "X${BSP_ARCH}" = "Xpowerpc" ]; then
  export ARCH=powerpc
  export CROSS_COMPILE=powerpc-linux-gnu-
fi

if [ "${synolxa:0:5}" = "3.10." -a $ARCH = x86 ]; then
  if [ ${synolva} = 5644 ]; then
    synofaa=braswell
  else
    synofaa=x64
  fi
fi

synolxt=${synolxa}
if [ ${synolxa} = "2.6.32" ]; then
  synolxt=${synolxa}.12
fi

synotag=${synolxt}-${synolva}-${synofam}
if [ -e patches/${synofam}/linux-${synolxa}-${synolva}-${synofaa}-to-${synofam}.patch -o \
     -e patches/${synofam}/linux-${synolxa}-${synolva}-${synofaa}-to-${synofam}-no-change.txt ]; then
  synotag=${synolxt}-${synolva}-${synofaa}
fi

#echo "synofaa $synofaa BSP_ARCH $BSP_ARCH"
lxmmmkb=`echo ${lxdebkb} | cut -d '.' -f 1-2`
lxbranch=dsx14j-${lxmmmkb}.y-comcerto2k
if [ $synofaa = 88f628x ]; then
  #echo ${lxdebkb}
  lxmmmkb=${lxdebkb}
  lxbranch=dsgpl-${lxmmmkb}.y-${synofaa}
elif [ $synofaa =  armada38x ]; then
  #echo ${lxdebkb}
  if [ $BSP_ARCH = amd64 ]; then
    synofaa=x64
  fi
  lxbranch=dsgpl-${lxmmmkb}.y-${synofaa}
elif [ $synofaa =  braswell ]; then
  lxbranch=dsgpl-${lxmmmkb}.y-x64
elif [ $synofaa =  x64 -a ${synolva} -lt 5510 ]; then
  true
elif [ $synofaa =  x64 -a ${synolva} -lt 5644 ]; then
  #echo ${lxdebkb}
  lxbranch=dsgpl-${lxmmmkb}.y-armada38x
elif [ $synofaa =  x64 ]; then
  #echo ${lxdebkb}
  lxbranch=dsgpl-${lxmmmkb}.y-${synofaa}
fi
#echo "synofaa $synofaa BSP_ARCH $BSP_ARCH lxbranch $lxbranch"
#exit 1

if [ ! -e linux-dsgpl-${lxmmmkb}.y ]; then
  git clone -b ${lxbranch} https://github.com/scpcom/linux linux-dsgpl-${lxmmmkb}.y
fi

#if false ; then
if [ -e linux ]; then
  exit 1
fi

echo "Copying files from linux-dsgpl-${lxmmmkb}.y git..."
mkdir linux && \
cp -apP linux-dsgpl-${lxmmmkb}.y/. linux/ && \
cd linux
#else
#cd linux
#fi

echo ${synolxt}-${synolva}-${synofam}

git checkout $synotag
#git checkout b0ff105aba973670317a56ca4385aec91790b087
#git checkout 33ca0cba94a95d8727458a2d2300441f563f3866

#git checkout -b ${lxbranch}-merged

if false ; then
git apply ../patches/linux-3.10.35-armada38x-5644-to-7321-restore-identical.patch
git add .
git commit -m "3.10.35-armada38x-5644-to-7321-restore-identical"

git merge -s recursive -X ours -X renormalize -X no-renames v3.10.77 | tee ../merge-3.10.77.log

git apply ../patches/linux-3.10.77-armada38x-5644-to-7321-new-identical.patch
git add .
git commit -m "3.10.77-armada38x-5644-to-7321-new-identical"

git apply ../patches/linux-3.10.77-armada38x-5644-to-7321-fix-merge.patch
git add .
git commit -m "3.10.77-armada38x-5644-to-7321-fix-merge"
fi

if false ; then
git apply ../patches/linux-3.10.77-armada38x-8451-to-15047-restore-identical.patch
git add .
git commit -m "3.10.77-armada38x-8451-to-15047-restore-identical"

git merge -s recursive -X ours -X renormalize -X no-renames v3.10.102 | tee ../merge-3.10.102.log

git apply ../patches/linux-3.10.102-armada38x-8451-to-15047-new-identical.patch
git add .
git commit -m "3.10.102-armada38x-8451-to-15047-new-identical"

git apply ../patches/linux-3.10.102-armada38x-8451-to-15047-fix-merge.patch
git add .
git commit -m "3.10.102-armada38x-8451-to-15047-fix-merge"
fi

if false ; then
git apply ../patches/linux-3.10.105-armada38x-15152-to-22259-remove-defines.patch
git add .
git commit -m "3.10.105-armada38x-15152-to-22259-remove-defines"

git apply ../patches/linux-3.10.102-armada38x-15152-to-22259-restore-identical.patch
git add .
git commit -m "3.10.102-armada38x-15152-to-22259-restore-identical"

git merge -s recursive -X ours -X renormalize -X no-renames v3.10.105 | tee ../merge-3.10.105.log

git apply ../patches/linux-3.10.105-armada38x-15152-to-22259-new-identical.patch
git add .
git commit -m "3.10.105-armada38x-15152-to-22259-new-identical"

git apply ../patches/linux-3.10.105-armada38x-15152-to-22259-fix-merge.patch
git add .
git commit -m "3.10.105-armada38x-15152-to-22259-fix-merge"
fi

if false ; then
git apply ../patches/x64/linux-3.10.35-x64-5644-to-7321-restore-identical.patch
git add .
git commit -m "3.10.35-x64-5644-to-7321-restore-identical"

git merge -s recursive -X ours -X renormalize -X no-renames v3.10.77 | tee ../merge-3.10.77.log

git apply ../patches/x64/linux-3.10.77-x64-5644-to-7321-new-identical.patch
git add .
git commit -m "3.10.77-x64-5644-to-7321-new-identical"

git apply ../patches/x64/linux-3.10.77-x64-5644-to-7321-fix-merge.patch
git add .
git commit -m "3.10.77-x64-5644-to-7321-fix-merge"
fi

if false ; then
git apply ../patches/x64/linux-3.10.77-x64-8451-to-15047-restore-identical.patch
git add .
git commit -m "3.10.77-x64-8451-to-15047-restore-identical"

git merge -s recursive -X ours -X renormalize -X no-renames v3.10.102 | tee ../merge-3.10.102.log

#git apply ../patches/x64/linux-3.10.102-x64-8451-to-15047-new-identical.patch
#git add .
#git commit -m "3.10.102-x64-8451-to-15047-new-identical"

git apply ../patches/x64/linux-3.10.102-x64-8451-to-15047-fix-merge.patch
git add .
git commit -m "3.10.102-x64-8451-to-15047-fix-merge"
fi

if false ; then
#git apply ../patches/x64/linux-3.10.105-x64-15152-to-22259-remove-defines.patch
#git add .
#git commit -m "3.10.105-x64-15152-to-22259-remove-defines"

git apply ../patches/x64/linux-3.10.102-x64-15152-to-22259-restore-identical.patch
git add .
git commit -m "3.10.102-x64-15152-to-22259-restore-identical"

git merge -s recursive -X ours -X renormalize -X no-renames v3.10.105 | tee ../merge-3.10.105.log

git apply ../patches/x64/linux-3.10.105-x64-15152-to-22259-new-identical.patch
git add .
git commit -m "3.10.105-x64-15152-to-22259-new-identical"

git apply ../patches/x64/linux-3.10.105-x64-15152-to-22259-fix-merge.patch
git add .
git commit -m "3.10.105-x64-15152-to-22259-fix-merge"
fi

git checkout -b ${lxbranch}-patched

VERSION=`cat Makefile | grep -E '^VERSION.=' | cut -d "=" -f 2- | tr -d " \t\n\r"`
PATCHLEVEL=`cat Makefile | grep PATCHLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
SUBVERSION=`cat Makefile | grep SUBLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`

if [ -e ../patches/series-nas5xx ]; then
  mkdir -p patches
  mkdir -p patches/platform

  for f in `cat ../patches/series-nas5xx | grep -E '^platform/' | cut -d / -f 2-` ; do
    cp -p ../patches/${f} patches/platform/
  done

  cat ../patches/series-nas5xx >> patches/series

  #cp -p ../patches/stmmac_platform_mac_addr_set.patch patches/
  #echo "stmmac_platform_mac_addr_set.patch" >> patches/series

  quilt push -a
fi


VERSION=`cat Makefile | grep -E '^VERSION.=' | cut -d "=" -f 2- | tr -d " \t\n\r"`
PATCHLEVEL=`cat Makefile | grep PATCHLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
SUBVERSION=`cat Makefile | grep SUBLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`


if [ -e ../patches/${synofaa}/linux-${synolxa}-${synolva}-${synofaa}-more-defs.patch ]; then
  git apply ../patches/${synofaa}/linux-${synolxa}-${synolva}-${synofaa}-more-defs.patch
  if [ -e ../patches/${synofaa}/linux-${synolxa}-${synolva}-${synofaa}-more-defs-part2.patch ]; then
    git apply ../patches/${synofaa}/linux-${synolxa}-${synolva}-${synofaa}-more-defs-part2.patch
    git apply ../patches/${synofaa}/linux-${synolxa}-${synolva}-${synofaa}-more-defs-part3.patch
  fi
  git add .
  git commit -m  "${synolxa}-${synolva}-${synofaa}-more-defs"
fi

if [ -e ../patches/${synofam}/linux-${synolxa}-${synolva}-${synofaa}-to-${synofam}.patch -a \
   ! -e ../patches/${synofam}/linux-${synolxa}-${synolva}-${synofaa}-to-${synofam}-no-change.txt ]; then
  if [ -e ../patches/${synofam}/linux-${synolxa}-${synolva}-${synofaa}-to-${synofam}-whitespace.patch ]; then
    git apply  ../patches/${synofam}/linux-${synolxa}-${synolva}-${synofaa}-to-${synofam}-whitespace.patch
  fi
  if [ -e ../patches/${synofam}/linux-${synolxa}-${synolva}-${synofaa}-to-${synofam}-fix.patch ]; then
    git apply ../patches/${synofam}/linux-${synolxa}-${synolva}-${synofaa}-to-${synofam}-fix.patch
  fi

  #if [ -e ../patches/${synofaa}/linux-${synolxa}-${synolva}-${synofaa}-more-defs-part2.patch ]; then
  #  patch --no-backup-if-mismatch -p1 -R < ../patches/${synofaa}/linux-${synolxa}-${synolva}-${synofaa}-more-defs-part2.patch
  #fi

  git apply ../patches/${synofam}/linux-${synolxa}-${synolva}-${synofaa}-to-${synofam}.patch

  if grep -q pfe_ctrl ../patches/${synofam}/linux-${synolxa}-${synolva}-${synofaa}-to-${synofam}.patch ; then
    patch --no-backup-if-mismatch -p1 -R < ../patches/pfe/linux-3.2.40-5004-comcerto2k-remove-pfe.patch
  fi

  if false ; then
  if ! grep -q pfe drivers/Makefile ; then
    if [ -e drivers/pfe ]; then
      git rm -r -f drivers/pfe
      git rm -r -f drivers/pfe_ctrl
    fi
    if [ -e firmware/class_c2000.elf ]; then
      git rm firmware/class_c2000.elf
      git rm firmware/pmu.elf
      git rm firmware/tmu_c2000.elf
      git rm firmware/util_c2000.elf
      git rm firmware/util_c2000_revA0.elf
    fi
  fi
  fi
  git add .
  git commit -m  "${synolxa}-${synolva}-${synofaa}-to-${synofam}"
fi

if [ -e ../patches/${synofam}/linux-${synolxa}-${synolva}-${synofaa}-to-${synofam}-extra.patch ]; then
  git apply ../patches/${synofam}/linux-${synolxa}-${synolva}-${synofaa}-to-${synofam}-extra.patch
  git add .
  git commit -m  "${synolxa}-${synolva}-${synofaa}-to-${synofam}-extra"
fi


# 2.6.32.y start
if false; then

gitam ../patches/compiler/linux-2.6.32-0001-kernel-add-support-for-gcc-5-6-7.patch
gitam ../patches/compiler/linux-2.6.32-0002-pagemap-fix-variable-set-but-not-used.patch
gitam ../patches/compiler/linux-2.6.32-0003-add-glue.h-numa.h-and-syno_autoconf.h-to-Kbuild.patch

gitam ../patches/compiler/linux-2.6.32-0004-arch-x86-percpu.h-fix-set-but-not-used.patch
gitam ../patches/compiler/linux-2.6.32-0005-irq.h-fix-set-but-not-used.patch
gitam ../patches/compiler/linux-2.6.32-0006-arch-x86-vdso-fix-m-compiler-flag.patch
if [ ${synolva} -lt 5004 ]; then
  gitam ../patches/compiler/linux-2.6.32-0007-remove-syno_autoconf.h-from-Kbuild.patch
fi
if [ ${synolva} -lt 4418 ]; then
  gitam ../patches/compiler/linux-2.6.32-0008-add-syno_acl.h-to-Kbuild.patch
fi

gitam ../patches/compiler/0011-kernel-timeconst-fix-perl-error.patch

if [ ${synolva} -gt 5644 ]; then
  gitam ../patches/compiler/0021-arch-powerpc-fix-mixed-targets-7321.patch
else
  gitam ../patches/compiler/0021-arch-powerpc-fix-mixed-targets.patch
fi
gitam ../patches/compiler/0022-arch-powerpc-add-cache.h-and-page_64.h-to-Kbuild.patch
gitam ../patches/compiler/0023-arch-powerpc-align-fix-set-but-not-used.patch
gitam ../patches/compiler/0024-arch-powerpc-signal_32-fix-set-but-not-used.patch
gitam ../patches/compiler/0025-arch-powerpc-ptrace-workaround-array-bounds-error.patch
gitam ../patches/compiler/0026-arch-powerpc-mem-fix-set-but-not-used.patch

if [ ${synolva} -gt 5644 ]; then
  if grep -q SYNO_QORIQ_EN_DEEP_WAKE_PIN arch/powerpc/sysdev/synology-gpio.c ; then
    gitam ../patches/compiler/0027-arch-powerpc-synology-gpio-fix-setbut-not-used-SYNO_QORIQ_EN_DEEP_WAKE_PIN.patch
  elif grep -A3 'return 0;' arch/powerpc/sysdev/synology-gpio.c | grep -q MY_DEF_HERE ; then
    gitam ../patches/compiler/0027-arch-powerpc-synology-gpio-fix-setbut-not-used-MY_DEF_HERE.patch
  else
    gitam ../patches/compiler/0027-arch-powerpc-synology-gpio-fix-setbut-not-used-MY_ABC_HERE.patch
  fi
elif [ ${synolva} -gt 3203 ]; then
  gitam ../patches/compiler/0027-arch-powerpc-synology-gpio-fix-setbut-not-used-SYNO_CHECK_HDD_PRESENT.patch
elif [ ${synolva} -gt 2636 ]; then
  gitam ../patches/compiler/0027-arch-powerpc-synology-gpio-fix-setbut-not-used.patch
elif [ ${synolva} -gt 2198 ]; then
  gitam ../patches/compiler/0027-arch-powerpc-synology-gpio-fix-setbut-not-used-EXPORT_SYMBOL.patch
fi

if [ ${synolva} -gt 2198 -a ${synolva} -lt 7321 ]; then  
  gitam ../patches/compiler/0028-drivers-net-gianfar_qoriq-fix-function-body-not-avai.patch
fi

if [ ${synolva} -gt 2198 ]; then
  if grep -q 'if 0 || defined(1)' include/linux/syno.h ; then
    gitam ../patches/compiler/0029-syno.h-fix-defined-1.patch
  fi
fi

fi
# 2.6.32.y end


# 3.2.y start
if false ; then

# 3203 and 3776
if [ ${synolva} -lt 4418 ]; then
  # 3203 and 3776
  gitam ../patches/compiler/0001-kernel-add-support-for-gcc-5-6-7.patch
else
  # 4418 and higher
  gitam ../patches/compiler/0001-kernel-add-support-for-gcc-5-6-7-4418.patch
fi

if [ ${synolva} -lt 3200 ]; then
  true
elif [ ${synolva} -lt 5004 ]; then
  gitam ../patches/compiler/0002-arch-arm-armada-fix-syno_mv_net_shutdown-prototype.patch
elif [ ${synolva} -lt 25426 ]; then
  if grep -q SYNO_NET_MV_WOL_WITH_UP arch/arm/plat-armada/mv_drivers_lsp/mv_neta/net_dev/mv_netdev.c ; then
    gitam ../patches/compiler/0002-arch-arm-armada-fix-syno_mv_net_shutdown-prototype-5004-SYNO_NET_MV_WOL_WITH_UP.patch
  elif grep -q CONFIG_SYNO_ARMADA_ARCH arch/arm/plat-armada/mv_drivers_lsp/mv_neta/net_dev/mv_netdev.c ; then
    gitam ../patches/compiler/0002-arch-arm-armada-fix-syno_mv_net_shutdown-prototype-5004-CONFIG_SYNO_ARMADA_ARCH.patch
  elif grep -q MY_DEF_HERE arch/arm/mach-armada370/core.c ; then
    gitam ../patches/compiler/0002-arch-arm-armada-fix-syno_mv_net_shutdown-prototype-5004.patch
  else
    gitam ../patches/compiler/0002-arch-arm-armada-fix-syno_mv_net_shutdown-prototype-5004-MY_ABC_HERE.patch
  fi
else
  if grep -B2 'void syno_mv_net_shutdown' arch/arm/mach-armada370/core.c | grep -q CONFIG_SYNO_ARMADA_ARCH ; then
    gitam ../patches/compiler/0002-arch-arm-armada-fix-syno_mv_net_shutdown-prototype-25426.patch
  elif grep -B2 'void syno_mv_net_shutdown' arch/arm/mach-armada370/core.c | grep -q MY_DEF_HERE ; then
    gitam ../patches/compiler/0002-arch-arm-armada-fix-syno_mv_net_shutdown-prototype-25426-MY_DEF_HERE.patch
  else
    gitam ../patches/compiler/0002-arch-arm-armada-fix-syno_mv_net_shutdown-prototype-25426-MY_ABC_HERE.patch
  fi
fi

gitam ../patches/compiler/0003-arch-arm-kernel-fix-early_egiga-return-type.patch

if [ ${synolva} -lt 3200 ]; then
  true
else
  gitam ../patches/compiler/0004-arch-arm-armada-mv_cesa-fix-cesadev_ioctl-return-typ.patch
  gitam ../patches/compiler/0005-arch-arm-armada-mv_neta-fix-mv_eth_tool_get_rxnfc-de.patch
fi

gitam ../patches/compiler/0006-drivers-mtd-m25p80-fix-lock_chip-declaration.patch

if [ ${synolva} -lt 25426 ]; then
  if grep -q SYNO_FLASH_MEMORY_SIZE drivers/mtd/maps/synomap.c ; then
    gitam ../patches/compiler/0007-drivers-mtd-synomap-fix-pMtdPartition-incompatible-p-SYNO_FLASH_MEMORY_SIZE.patch
  elif grep -q 'Select static partition definitions' drivers/mtd/maps/synomap.c ; then
    gitam ../patches/compiler/0007-drivers-mtd-synomap-fix-pMtdPartition-incompatible-p-with-comment.patch
  else
    gitam ../patches/compiler/0007-drivers-mtd-synomap-fix-pMtdPartition-incompatible-p.patch
  fi
else
  gitam ../patches/compiler/0007-drivers-mtd-synomap-fix-pMtdPartition-incompatible-p-25426.patch
fi

if [ ${synolva} -lt 3200 ]; then
  true
else
  gitam ../patches/compiler/0008-drivers-mtd-fix-uiTemp-incompatible-pointer-type.patch
fi

# 4458 and below
if [ ${synolva} -lt 3200 ]; then
  true
elif [ ${synolva} -lt 5004 ]; then
  if grep -q 'The following asm.. prevents the compiler from' fs/ext4/ialloc.c ; then
    gitam ../patches/compiler/0009-fs-ext4-fix-div_u64_rem64-incompatible-pointer-type-with-comment.patch
  else
    gitam ../patches/compiler/0009-fs-ext4-fix-div_u64_rem64-incompatible-pointer-type.patch
  fi
fi

if [ ${synolva} -lt 3200 ]; then
  gitam ../patches/compiler/0010-add-syno_acl.h-2636.patch
else
  gitam ../patches/compiler/0010-add-syno_acl.h.patch
fi

# Only in 3203
if [ ${synolva} -lt 3776 ]; then
  gitam ../patches/compiler/0011-kernel-timeconst-fix-perl-error.patch
fi

gitam ../patches/compiler/0012-arch-arm-add-more-headers.patch
gitam ../patches/compiler/0013-scripts-package-builddeb-fix-arch.patch

# 4418 and 4458
if [ ${synolva} -lt 5004 -a ${synolva} -gt 3776 ]; then
  gitam ../patches/compiler/0014-fs-fuse-backport-fuse_buffered_write-fix.patch
fi

# 4418 and higher
# 4418 block begin
if [ ${synolva} -gt 3776 ]; then

if [ ${synolva} -lt 5004 ]; then
  if ! grep -q CONFIG_SYNO_COMCERTO net/netfilter/nf_conntrack_core.c ; then
    gitam ../patches/compiler/0015-net-partially-restore-SYNO_COMCERTO.patch
  fi
else
  if grep CONFIG_COMCERTO_FP net/netfilter/nf_conntrack_core.c | grep -q MY_DEF_HERE ; then
    gitam ../patches/compiler/0015-net-partially-restore-SYNO_COMCERTO-5004-MY_DEF_HERE.patch
  elif ! grep -q CONFIG_SYNO_COMCERTO net/netfilter/nf_conntrack_core.c ; then
    gitam ../patches/compiler/0015-net-partially-restore-SYNO_COMCERTO-5004.patch
  fi
fi

gitam ../patches/compiler/0016-arch-arm-add-pgtable-2level.h.patch
gitam ../patches/compiler/0017-remove-syno_acl.h.patch

if grep -q 'No mac addr specified' arch/arm/mach-comcerto/comcerto-2000.c ; then
  gitam ../patches/compiler/0018-arch-arm-comcerto-fix-mac_addr_setup-return-type-with-comment.patch
else
  gitam ../patches/compiler/0018-arch-arm-comcerto-fix-mac_addr_setup-return-type.patch
fi

if [ ${synolva} -lt 5004 ]; then
  gitam ../patches/compiler/0019-arch-arm-comcerto-fix-missing-cpu1_hotplug-type.patch
else
  gitam ../patches/compiler/0019-arch-arm-comcerto-fix-missing-cpu1_hotplug-type-5004.patch
fi

# 4418 and 4458
if [ ${synolva} -lt 5004 -a ${synolva} -gt 3776 ]; then
  gitam ../patches/compiler/0020-arch-arm-comcerto-fix-hotplug_cpu1_die-return-type.patch
  gitam ../patches/compiler/0021-crypto-ocf-m86xxx-fix-src-illegal-pointer-type.patch
fi

if [ ${synolva} -lt 5004 ]; then
  gitam ../patches/compiler/0022-crypto-ocf-m86xxx-fix-mising-type-declarations.patch
else
  if grep -q CONFIG_SYNO_COMCERTO crypto/ocf/m86xxx/m86xxx_var.h ; then
    gitam ../patches/compiler/0022-crypto-ocf-m86xxx-fix-mising-type-declarations-5004-CONFIG_SYNO_COMCERTO.patch
  elif grep -B1 '"../ocf-compat.h"' crypto/ocf/m86xxx/m86xxx_var.h | grep -q MY_DEF_HERE ; then
    gitam ../patches/compiler/0022-crypto-ocf-m86xxx-fix-mising-type-declarations-5004-MY_DEF_HERE.patch
  else
    gitam ../patches/compiler/0022-crypto-ocf-m86xxx-fix-mising-type-declarations-5004.patch
  fi
fi

gitam ../patches/compiler/0023-drivers-dma-c2k_dma-fix-comcerto_xor_set_desc-protot.patch
gitam ../patches/compiler/0024-drivers-gpio-gpio-c2k-fix-c2k_init_gpio-return-type.patch
gitam ../patches/compiler/0025-drivers-i2c-chips-eeprom-fix-illegal-pointer-type.patch
gitam ../patches/compiler/0026-drivers-mtd-m25p80_mindspeed-fix-lock_chip-prototype.patch

fi
# 4418 block end

if [ ${synolva} -gt 3203 ]; then
  gitam ../patches/compiler/0027-drivers-net-usb-declare-qmi_wwan_syno-as-broken.patch
fi

if [ ${synolva} -gt 3776 ]; then
  gitam ../patches/compiler/0028-drivers-usb-dwc_otg-fix-missing-type-declarations.patch
  if [ ${synolva} -lt 5004 ]; then
    gitam ../patches/compiler/0029-drivers-usb-dwc_otg-fix-dwc_otg_driver_remove-return.patch
  else
    gitam ../patches/compiler/0029-drivers-usb-dwc_otg-fix-dwc_otg_driver_remove-return-5004.patch
  fi
fi

# 4418 and 4458
if [ ${synolva} -lt 5004 -a ${synolva} -gt 3776 ]; then
  gitam ../patches/compiler/0030-kernel-ksysfs-fix-comcerto-_store-prototypes.patch
fi

# 4458 and higher
if [ ${synolva} -gt 4418 ]; then
  gitam ../patches/compiler/0031-arch-arm-vfp-fix-missing-macro.patch
fi

# 5004 and higher
if [ ${synolva} -gt 4458 ]; then
  gitam ../patches/compiler/0032-arch-arm-comcerto-comcerto-vwd-fix-comcerto_wifi_rx_.patch
  gitam ../patches/compiler/0033-drivers-dma-dw-fix-dwc_prep_slave_sg-prototype.patch
  gitam ../patches/compiler/0034-add-syno_autoconf.h.patch
fi

if [ ${synolva} -lt 3200 ]; then
  gitam ../patches/compiler/0035-drivers-ata-libata-scsi-fix-syno_port_thaw_show-prot.patch
fi

# 5004 and higher
if [ ${synolva} -gt 4458 ]; then
  gitam ../patches/compiler/0036-fs-btrfs-fix-btrfs_feature_visible-prototype.patch
fi

# 5004 and higher
if [ ${synolva} -gt 4458 ]; then
  if grep -q ' CONFIG_MV_PP2_TXDONE_ISR ' arch/arm/plat-armada-v2/mv_drivers_lsp/mv_pp2/net_dev/mv_netdev.h ; then
    gitam ../patches/compiler/0040-arch-arm-armada375-mv_pp2-fix-mv_pp2_interrupts_mask-with-comment.patch
  else
    gitam ../patches/compiler/0040-arch-arm-armada375-mv_pp2-fix-mv_pp2_interrupts_mask.patch
  fi

  #if grep -q ' CONFIG_OF ' arch/arm/mach-armada375/core.c ; then
  if grep -q ' CONFIG_OF ' arch/arm/plat-armada-v2/mv_drivers_lsp/mv_pp2/net_dev/mv_netdev.c ; then
    if grep -B1 'void syno_mv_net_shutdown' arch/arm/mach-armada375/core.c | grep -q SYNO_NET_MV_WOL_WITH_UP ; then
      gitam ../patches/compiler/0042-arch-arm-armada375-fix-syno_mv_net_shutdown-prototyp-5004-SYNO_NET_MV_WOL_WITH_UP-with-comment.patch
    elif grep -B2 'void syno_mv_net_shutdown' arch/arm/mach-armada375/core.c | grep -q CONFIG_SYNO_ARMADA_ARCH_V2 ; then
      gitam ../patches/compiler/0042-arch-arm-armada375-fix-syno_mv_net_shutdown-prototyp-5004-CONFIG_SYNO_ARMADA_ARCH_V2-with-comment.patch
    else
      gitam ../patches/compiler/0042-arch-arm-armada375-fix-syno_mv_net_shutdown-prototyp-5004-MY_ABC_HERE-with-comment.patch
    fi
  elif grep -B2 'void syno_mv_net_shutdown' arch/arm/mach-armada375/core.c | grep -q CONFIG_SYNO_ARMADA_ARCH_V2 ; then
    gitam ../patches/compiler/0042-arch-arm-armada375-fix-syno_mv_net_shutdown-prototyp-5004-CONFIG_SYNO_ARMADA_ARCH_V2.patch
  elif grep -B2 'void syno_mv_net_shutdown' arch/arm/mach-armada375/core.c | grep -q MY_DEF_HERE ; then
    gitam ../patches/compiler/0042-arch-arm-armada375-fix-syno_mv_net_shutdown-prototyp-5004-MY_DEF_HERE.patch
  else
    gitam ../patches/compiler/0042-arch-arm-armada375-fix-syno_mv_net_shutdown-prototyp-5004-MY_ABC_HERE.patch
  fi
  gitam ../patches/compiler/0044-arch-arm-armada375-mv_cesa-fix-cesadev_ioctl-return-.patch

  if [ ${synolva} -gt 5004 ]; then
    if grep -B1 'extern void syno_alpine_wol_set' arch/arm/mach-alpine/alpine_machine.c | grep -q SYNO_ALPINE_SUPPORT_WOL ; then
      gitam ../patches/compiler/0045-arch-arm-mach-alpine-fix-syno_alpine_wol_set-prototy-5510-SYNO_ALPINE_SUPPORT_WOL.patch
    elif grep -B1 'extern void syno_alpine_wol_set' arch/arm/mach-alpine/alpine_machine.c | grep -q MY_DEF_HERE ; then
      gitam ../patches/compiler/0045-arch-arm-mach-alpine-fix-syno_alpine_wol_set-prototy-5510-MY_DEF_HERE.patch
    else
      gitam ../patches/compiler/0045-arch-arm-mach-alpine-fix-syno_alpine_wol_set-prototy-5510.patch
    fi
  else
    gitam ../patches/compiler/0045-arch-arm-mach-alpine-fix-syno_alpine_wol_set-prototy.patch 
  fi
  gitam ../patches/compiler/0046-arch-arm-mach-alpine-alpine_cpu_pm-fix-missing-EXPOR.patch
  if grep -q '\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*' drivers/crypto/al/al_crypto_sysfs.c ; then
    gitam ../patches/compiler/0047-drivers-crypto-al-fix-function-prototypes-with-comments.patch
  else
    gitam ../patches/compiler/0047-drivers-crypto-al-fix-function-prototypes.patch
  fi
  if grep -q '\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*' drivers/dma/al/al_dma_sysfs.c ; then
    gitam ../patches/compiler/0048-drivers-dma-al-fix-function-prototypes-with-comments.patch
  else
    gitam ../patches/compiler/0048-drivers-dma-al-fix-function-prototypes.patch
  fi
fi

# 5565 and higher
if [ ${synolva} -gt 5004 ]; then
  if grep -B1 'int rps_sock_flow_init' net/core/sysctl_net_core.c | grep -q CONFIG_SYNO_ALPINE_TUNING_NETWORK_PERFORMANCE ; then
    gitam ../patches/compiler/0049-net-core-sysctl_net_core-fix-rps_sock_flow_init-prot.patch
  elif grep -B1 'int rps_sock_flow_init' net/core/sysctl_net_core.c | grep -q MY_DEF_HERE ; then
    gitam ../patches/compiler/0049-net-core-sysctl_net_core-fix-rps_sock_flow_init-prot-MY_DEF_HERE.patch
  elif grep -q 'int rps_sock_flow_init' net/core/sysctl_net_core.c ; then
    gitam ../patches/compiler/0049-net-core-sysctl_net_core-fix-rps_sock_flow_init-prot-MY_ABC_HERE.patch
  fi
fi

# 3776 and higher
if [ ${synolva} -gt 3203 ]; then
  gitam ../patches/compiler/0050-arch-arm-mach-armadaxp-fix-smp_resume-prototype.patch
  if grep -B1 syno_mv_net_shutdown arch/arm/mach-armadaxp/core.c | grep -q SYNO_NET_MV_WOL_WITH_UP ; then
    gitam ../patches/compiler/0052-arch-arm-armadaxp-fix-syno_mv_net_shutdown-prototype-SYNO_NET_MV_WOL_WITH_UP.patch
  elif grep -B2 'void syno_mv_net_shutdown' arch/arm/mach-armadaxp/core.c | grep -q CONFIG_SYNO_ARMADA_ARCH ; then
    gitam ../patches/compiler/0052-arch-arm-armadaxp-fix-syno_mv_net_shutdown-prototype.patch
  elif grep -B2 'void syno_mv_net_shutdown' arch/arm/mach-armadaxp/core.c | grep -q MY_DEF_HERE ; then
    gitam ../patches/compiler/0052-arch-arm-armadaxp-fix-syno_mv_net_shutdown-prototype-MY_DEF_HERE.patch
  else
    gitam ../patches/compiler/0052-arch-arm-armadaxp-fix-syno_mv_net_shutdown-prototype-MY_ABC_HERE.patch
  fi
fi

if [ ${synolva} -gt 3776 -a -e drivers/pfe ]; then
  gitam ../patches/pfe/0001-drivers-pfe-c2000-fix-wrong-spacing.patch
  gitam ../patches/pfe/0002-drivers-pfe-c2000-control_mc4-change-array-bounds-to.patch
  gitam ../patches/pfe/0003-drivers-pfe-c2000-control_mc6-change-array-bounds-to.patch
  gitam ../patches/pfe/0004-drivers-pfe-c2000-control_rtp_relay-fix-wrong-spacin.patch
  gitam ../patches/pfe/0005-drivers-pfe-c2000-control_tunnel-fix-compiler-errors.patch
  gitam ../patches/pfe/0006-drivers-pfe-c2000-fix-redefined-NUM_GEMAC_SUPPORT.patch
  if ! grep -q wifi_offload_dev include/linux/netdevice.h ; then
    gitam ../patches/pfe/0007-drivers-pfe-c2000-pfe_vwd-disable-wifi-offload-code.patch
  fi
  # 4418 and 4458
  if [ ${synolva} -lt 5004 ]; then
    gitam ../patches/pfe/0008-drivers-pfe-c2000-workariound-missing-original_dev_q.patch
  fi
  gitam ../patches/pfe/0009-drivers-pfe-c2000-depends-on-ARCH_COMCERTO.patch
fi

fi
# 3.2.y block end


# 3.10.y block start

gitam ../patches/compiler/linux-3.10.y-0001-arch-arm-remove-reduntdant-return_address.patch
if grep -B1 'void free_rename_path_list' fs/namei.c | grep -q CONFIG_SYNO_FS_NOTIFY ; then
  gitam ../patches/compiler/linux-3.10.y-0002-fs-namei-fix-undefined-reference-SYNO_FS_NOTIFY.patch
elif grep -q 'void free_rename_path_list' fs/namei.c ; then
  gitam ../patches/compiler/linux-3.10.y-0002-fs-namei-fix-undefined-reference.patch
fi
gitam ../patches/compiler/linux-3.10.y-0003-add-syno_autoconf.h-to-Kbuild.patch
if grep -q MY_ABC_HERE kernel/module_signing.c ; then
  gitam ../patches/compiler/linux-3.10.y-0004-kernel-modsign-restore-define-CONFIG_SYNO_KEY.patch
fi
gitam ../patches/compiler/linux-3.10.y-0005-lib-mpi-use-static-inline-instead-of-extern-inline.patch

synolxa=${VERSION}.${PATCHLEVEL}.${SUBVERSION}

if [ $synolxa = 3.10.35 ]; then
  gitam ../patches/compiler/620c41147d873223d8aac0aa64793882b6217f09.patch
  gitam ../patches/compiler/42abc5125d0cd1abba9d21133010dcea1f3a0e8f.patch
fi
if [ -e include/linux/compiler-gcc5.h ]; then
  gitam ../patches/compiler/a4a4f1cd733fe5b345db4e8cc19bb8868d562a8a.patch
fi

gitam ../patches/compiler/46d284b7ac7435478a7bc934256c736e4615885f.patch

gitam ../patches/compiler/linux-3.10.y-0006-disable-pie-when-gcc-has-it-enabled-by-default.patch

if grep -q 'extern inline bool intel_gmbus_is_forced_bit' drivers/gpu/drm/i915/i915_drv.h ; then
  #gitam ../patches/compiler/linux-3.10.y-0007-drm-i915-use-static-inline-instead-of-extern-inline.patch
  gitam ../patches/compiler/00ac0c1f0216d9ba96f06b7417cb8301ce0cfdbf.patch
fi

if ! grep -q 'define x86cpu_device_id' include/linux/mod_devicetable.h ; then
  gitam ../patches/compiler/d4d37e92e07e914642935865c6316afc3fe15a14.patch
fi

if grep -B1 'extern inline int dentry_cmp' include/linux/dcache.h | grep -q CONFIG_SYNO_FS_CASELESS_STAT ; then
  gitam ../patches/compiler/linux-3.10.y-0008-dcache-fix-undefined-reference.patch
elif grep -B1 'extern inline int dentry_cmp' include/linux/dcache.h | grep -q SYNO_ ; then
  gitam ../patches/compiler/linux-3.10.y-0008-dcache-fix-undefined-reference-bsp.patch
elif grep -B1 'extern inline int dentry_cmp' include/linux/dcache.h | grep -q MY_ABC_HERE ; then
  gitam ../patches/compiler/linux-3.10.y-0008-dcache-fix-undefined-reference-MY_ABC_HERE.patch
else
  gitam ../patches/compiler/linux-3.10.y-0008-dcache-fix-undefined-reference-no-comments.patch
fi

if grep -B1 'extern bool ramdisk_check_failed' fs/namespace.c | grep -q MY_ABC_HERE ; then
  gitam ../patches/compiler/linux-3.10.y-0009-restore-define-CONFIG_SYNO_RAMDISK_INTEGRITY_CHECK.patch
fi

if grep -q '^inline int hub_is_superspeed' drivers/usb/core/hub.c ; then
  if grep -B1 'extern u32 syno_pch_lpc_gpio_pin' drivers/usb/core/port.c | grep -q MY_DEF_HERE ; then
    gitam ../patches/compiler/linux-3.10.y-0010-drivers-usb-core-fix-hub_is_superspeed-undefined-MY_DEF_HERE.patch
  elif grep -B1 'extern u32 syno_pch_lpc_gpio_pin' drivers/usb/core/port.c | grep -q MY_ABC_HERE ; then
    gitam ../patches/compiler/linux-3.10.y-0010-drivers-usb-core-fix-hub_is_superspeed-undefined-MY_ABC_HERE.patch
  else
    gitam ../patches/compiler/linux-3.10.y-0010-drivers-usb-core-fix-hub_is_superspeed-undefined.patch
  fi
fi

if ! grep -q '^#define HW_RS4017xsp' include/linux/synobios.h ; then
  if [ ${synolva} = 8451 ]; then
    gitam ../patches/compiler/linux-3.10.y-0011-add-define-HW_RS4017xsp.patch
  fi
fi

# 3.10.y block end


#cp -p ../patches/*_defconfig arch/${ARCH}/configs/

synofac=${synofam}
if [ ! -e synoconfigs/${synofam} ]; then
  if [ ${synofam} = 88f628x ]; then
    synofac=88f6281
  elif [ ${synofam} = 853x ]; then
    synofac=ppc8533
  elif [ ${synofam} = 854x ]; then
    synofac=ppc854x
  elif [ ${synofam} = qoriq ]; then
    synofac=ppcQorIQ
  elif [ ${synofam} = x64 ]; then
    synofac=x86_64
  fi
fi
if [ -e synoconfigs/${synofac} -a ! -e arch/${ARCH}/configs/${BSP_CONFIG}_defconfig ]; then
  echo "Using synoconfigs/${synofac}"
  cp -p synoconfigs/${synofac} arch/${ARCH}/configs/${BSP_CONFIG}_defconfig
fi

if [ ${ARCH} = arm ]; then
  if [ -e synoconfigs/${synofam} -a ! -e arch/${ARCH}/configs/${BSP_CONFIG}_defconfig ]; then
    echo "Using synoconfigs/${synofam}"
    cp -p synoconfigs/${synofam} arch/${ARCH}/configs/${BSP_CONFIG}_defconfig
  fi
  if [ -e synoconfigs/comcerto2k -a ! -e arch/${ARCH}/configs/${BSP_CONFIG}_defconfig ]; then
    echo "Using synoconfigs/comcerto2k"
    cp -p synoconfigs/comcerto2k arch/${ARCH}/configs/${BSP_CONFIG}_defconfig
  fi
  if [ -e synoconfigs/armada370 -a ! -e arch/${ARCH}/configs/${BSP_CONFIG}_defconfig ]; then
    echo "Using synoconfigs/armada370"
    cp -p synoconfigs/armada370 arch/${ARCH}/configs/${BSP_CONFIG}_defconfig
  fi
  if [ -e synoconfigs/88f6281 -a ! -e arch/${ARCH}/configs/${BSP_CONFIG}_defconfig ]; then
    echo "Using synoconfigs/88f6281"
    cp -p synoconfigs/88f6281 arch/${ARCH}/configs/${BSP_CONFIG}_defconfig
  fi

elif [ ${ARCH} = x86 ]; then
  if [ -e synoconfigs/x86_64 -a ! -e arch/${ARCH}/configs/${BSP_CONFIG}_defconfig ]; then
    echo "Using synoconfigs/x86_64"
    cp -p synoconfigs/x86_64 arch/${ARCH}/configs/${BSP_CONFIG}_defconfig
  fi
fi

if [ -e arch/${ARCH}/configs/${BSP_CONFIG}_defconfig ]; then
  git add arch/${ARCH}/configs/${BSP_CONFIG}_defconfig
  git commit -m "arch: ${ARCH}: add ${BSP_CONFIG}_defconfig"
fi

cd ..

#cp -p ../nas540-kernel-build/linux/firmware/pmu.elf linux/firmware/
#cp -p ../nas540-kernel-build/linux/firmware/*_c2000.elf linux/firmware/
#cp -p ../nas540-kernel-build/linux/firmware/*_c2000_*.elf linux/firmware/

echo OK
