#!bin/sh
synofam=x64

gitapply() {
  echo `basename $1` >> ../prepare-branch.log
  echo `basename $1`
  git apply $1
}

if [ ! -e linux-dsgpl-3.10.y -a ! -e linux-dsgpl-3.10.35-unpatched ]; then
  git clone -b mainline-3.10 https://github.com/scpcom/linux linux-dsgpl-3.10.y

  cd linux-dsgpl-3.10.y
  git fetch
  git pull origin
  git checkout mainline-3.10
  # Linux 3.10.35
  git checkout v3.10.35
  cd ..

  mv linux-dsgpl-3.10.y linux-dsgpl-3.10.35-unpatched
  #mkdir linux-dsgpl-3.10.35-unpatched
  #cp -apP linux-dsgpl-3.10.y/. linux-dsgpl-3.10.35-unpatched/
fi

if [ ! -e linux-dsgpl-3.10.y ]; then
  echo "Copying linux-dsgpl-3.10.y-armada38x ..."
  mkdir linux-dsgpl-3.10.y
  cp -apP linux-dsgpl-3.10.y-armada38x/. linux-dsgpl-3.10.y/
fi

if [ -e linux-dsgpl-3.10.y ]; then
  cd linux-dsgpl-3.10.y

  #git checkout v3.10.35
  #git checkout -b mainline-3.10.35

  git checkout 3.10.35-5565-${synofam}

  git checkout -b dsgpl-3.10.y-${synofam}

  #exit 1

  VERSION=`cat Makefile | grep -E '^VERSION.=' | cut -d "=" -f 2- | tr -d " \t\n\r"`
  PATCHLEVEL=`cat Makefile | grep PATCHLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
  SUBVERSION=`cat Makefile | grep SUBLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
  EXTRAVERSION=`cat Makefile | grep EXTRAVERSION.= | cut -d "=" -f 2- | tr -d " \t\n\r"`

  synooxa=${VERSION}.${PATCHLEVEL}.${SUBVERSION}
  synooam=${synofam}
  synoova=none
  synoovb=none
  synolxa=${VERSION}.${PATCHLEVEL}.${SUBVERSION}
  synofam=x64
  #synolva=mainline
  synolva=5565
  #synolvb=1373
  #synolvb=5510
  synolvb=5644
  synolvt=v${VERSION}.${PATCHLEVEL}.${SUBVERSION}${EXTRAVERSION}
  synosbh=none

  rm -f ../prepare-branch.log

  echo "${synolvt}" >> ../prepare-branch.log
  #echo git tag -a ${VERSION}.${PATCHLEVEL}.${SUBVERSION}${EXTRAVERSION}-${synolvb}-${synofam} -m "dsgpl ${synolvb} branch ${synofam}"

  while read p; do
    #echo "${p}" >> ../prepare-branch.log
    #echo "X${p}Z"
    if [ "X${p}" = "X" ]; then
      continue
    fi

    VERSION=`cat Makefile | grep -E '^VERSION.=' | cut -d "=" -f 2- | tr -d " \t\n\r"`
    PATCHLEVEL=`cat Makefile | grep PATCHLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
    SUBVERSION=`cat Makefile | grep SUBLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
    EXTRAVERSION=`cat Makefile | grep EXTRAVERSION.= | cut -d "=" -f 2- | tr -d " \t\n\r"`

    synooxa=${synolxa}
    synooam=${synofam}
    synoova=${synolva}
    synoovb=${synolvb}
    #synolxa=${VERSION}.${PATCHLEVEL}.${SUBVERSION}
    synolxa=`echo $p | sed s/'\.patch$'/''/g | cut -d '-' -f 2`
    synofam=`echo $p | sed s/'\.patch$'/''/g | cut -d '-' -f 3`
    synolva=`echo $p | sed s/'\.patch$'/''/g | cut -d '-' -f 4`
    synolvb=`echo $p | sed s/'\.patch$'/''/g | cut -d '-' -f 6`

    q=`echo $p | sed s/'\.patch$'/''/g | cut -d '-' -f 1-6`
    if [ $synolxa != $synooxa ]; then
      echo "should merge v$synolxa" >> ../prepare-branch.log
    fi
    
    if [ $synolva != $synoova -o $synolvb != $synoovb ]; then
      #echo "$synolva != $synoova -o $synolvb != $synoovb"
      synolvt=${VERSION}.${PATCHLEVEL}.${SUBVERSION}${EXTRAVERSION}-${synoovb}-${synooam}
      echo "${synolvt}" >> ../prepare-branch.log
      git tag -a ${synolvt} -m "dsgpl ${synoovb} branch ${synofam}"
      echo ""
    fi

    #echo $p
    m=`echo $p | sed s/'\.patch$'/''/g | sed s/'-v.$'/''/g | cut -d '-' -f 7- | tr '-' ' '`
    l=$m
    if [ "X$m" = "X" ]; then
      m="changes"
    elif [ "X$m" = "Xextra" -o "X$m" = "Xmerge extra" ]; then
      m="add/remove files"
    fi

    patchdir=../patches
    if [ -e ${patchdir}/${synofam}/$p ]; then
      patchdir=${patchdir}/${synofam}
    fi

    if [ "X$m" = "Xremove comments" ]; then
      w=`echo $p | cut -d '-' -f 1-6`-v2-revert-identical.patch
      if [ -e ${patchdir}/$w ]; then
        gitapply ${patchdir}/$w
      fi
      w=`echo $p | cut -d '-' -f 1-6`-v2-revert-identical-extra.patch
      if [ -e ${patchdir}/$w ]; then
        gitapply ${patchdir}/$w
      fi
    fi

    if [ "X$m" = "Xchanges" ]; then
      s=`echo $p | cut -d '-' -f 1-6 | sed s/'\.patch$'/''/g`-synobios.patch
      synoobh=$synosbh
      synosbh=$s
      if [ -e ${patchdir}/${synoobh} -a -e ${patchdir}/${synosbh} ]; then
        echo "${synoobh}"
        gitapply ${patchdir}/${synoobh}
        echo "${synosbh}"
        gitapply ${patchdir}/${synosbh}
      fi

      echo ${patchdir}/${q}-revert-identical.patch
      if [ -e ${patchdir}/${q}-revert-identical.patch ]; then
        gitapply ${patchdir}/${q}-revert-identical.patch
      fi
      #exit 1
    fi

    if [ "X$m" = "Xadd/remove files" ]; then
      if [ -e ${patchdir}/${synoobh} -a -e ${patchdir}/${synosbh} ]; then
        echo "${synosbh} reverse 1"
        patch -p1 -R < ${patchdir}/${synosbh}
      fi
    fi

    if [ "X$m" = "Xmerge" ]; then
      if [ "v$synolxa" = "v3.10.77" ]; then
        #gitapply ${patchdir}/linux-3.10.35-x64-5565-to-5644-restore-identical.patch
	gitapply ${patchdir}/linux-3.10.35-x64-5644-to-7321-restore-identical.patch
      elif [ "v$synolxa" = "v3.10.102" ]; then
        gitapply ${patchdir}/linux-3.10.77-x64-8451-to-15047-restore-identical.patch
      else
        gitapply ${patchdir}/linux-3.10.102-x64-15152-to-22259-restore-identical.patch
      fi
      git add .
      git commit -m "`echo $p | sed s/'\.patch$'/''/g | cut -d '-' -f 4-6`: prepare merge"

      echo "merge v$synolxa"
      echo "merge v$synolxa" >> ../prepare-branch.log
      git merge -s recursive -X ours -X renormalize -X no-renames v${synolxa} | tee ../merge-${synolxa}.log

      if [ -e ${patchdir}/${q}-new-identical-no-change.txt ]; then
        true
      else
        gitapply ${patchdir}/${q}-new-identical.patch
        #git add .
        #git commit -m "`echo $p | sed s/'\.patch$'/''/g | cut -d '-' -f 4-6`: new identical"
      fi

      gitapply ${patchdir}/${q}-fix-merge.patch
      git add .
      git commit -m "`echo $p | sed s/'\.patch$'/''/g | cut -d '-' -f 4-6`: fix merge"

      gitapply ${patchdir}/${q}-merge.patch
      #git add .
      #git commit -m "`echo $p | sed s/'\.patch$'/''/g | cut -d '-' -f 4-6`: changes"
      m="changes"

      #merge-extra.patch
    else
      gitapply ${patchdir}/$p
    fi

    if [ "X$m" = "Xadd/remove files" ]; then
      if [ -e ${patchdir}/${synosbh} -a ! -e ${patchdir}/${synoobh} ]; then
        if [ "X$l" != "Xmerge extra" ]; then
          echo "${synosbh} reverse 2"
          patch -p1 -R < ${patchdir}/${synosbh}
        fi
      fi
    fi

    if [ "X$m" = "Xremove comments" ]; then
      w=`echo $p | cut -d '-' -f 1-6`-whitespace.patch
      gitapply ${patchdir}/$w
      w=`echo $p | cut -d '-' -f 1-6`-v3-whitespace.patch
      if [ -e ${patchdir}/$w ]; then
        gitapply ${patchdir}/$w
      fi
      w=`echo $p | cut -d '-' -f 1-6`-v3-revert-identical.patch
      if [ -e ${patchdir}/$w ]; then
        gitapply ${patchdir}/$w
      fi
      w=`echo $p | cut -d '-' -f 1-6`-v3-revert-identical-extra.patch
      if [ -e ${patchdir}/$w ]; then
        gitapply ${patchdir}/$w
      fi
    elif [ "X$m" = "Xchange revisions" ]; then
      i=`echo $p | cut -d '-' -f 1-6`-restore-identical.patch
      if [ -e ${patchdir}/$i ]; then
        echo $i
        gitapply ${patchdir}/$i
        gitapply ${patchdir}/linux-3.10.35-x64-5644-to-7321-restore-identical.patch
      else
        echo X$i
        exit 1	      
      fi
    fi

    rm -f include/linux/version.h

    git add .
    git commit -m "`echo $p | sed s/'\.patch$'/''/g | cut -d '-' -f 4-6`: $m"
  done <<<$(cat ../patches/series-${synooam} | grep patch | grep -v -E '^#')

  VERSION=`cat Makefile | grep -E '^VERSION.=' | cut -d "=" -f 2- | tr -d " \t\n\r"`
  PATCHLEVEL=`cat Makefile | grep PATCHLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
  SUBVERSION=`cat Makefile | grep SUBLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
  EXTRAVERSION=`cat Makefile | grep EXTRAVERSION.= | cut -d "=" -f 2- | tr -d " \t\n\r"`

  if [ $synoova != none ]; then
    synoova=${synolva}
    synoovb=${synolvb}
    synooam=${synofam}
    synolvt=${VERSION}.${PATCHLEVEL}.${SUBVERSION}${EXTRAVERSION}-${synoovb}-${synooam}
    echo "${synolvt}" >> ../prepare-branch.log
    git tag -a ${synolvt} -m "dsgpl ${synoovb} branch ${synofam}"
  fi

  cd ..
fi

echo OK
