#!/bin/sh
#synofam=88f628x
synofam=armada38x
synolst=diff-branches.txt

if [ "X$1" != "X" ]; then
  synofam=$1
fi
if [ -e diff-branches-${synofam}.txt ]; then
  synolst=diff-branches-${synofam}.txt
fi

#a=/mnt/N3/linux-ds211-3.10-22259
a=/mnt/N3/linux-ds216j-3.10.105-22259
#t=3.2.30-3201-x64
if [ ${synofam} = x64 ]; then
  a=/mnt/N3/linux-ds1511plus-3.10.105-22259
fi
echo "dsgpl-3.10.y-${synofam} using ${synolst}"

for t in `cat ${synolst}` ; do
  u=linux-`echo $t | cut -d '-' -f 1 | cut -d . -f 1-3`-`echo $t | cut -d '-' -f 2`-unpatched
  m=linux-dsgpl-`echo $t | cut -d '-' -f 1`-unpatched
  echo $t
  if [ ! -e $m ]; then
    echo $m
    exit 1
  fi
  if [ ! -e $a/$u ]; then
    echo $u
  fi
  cd linux-dsgpl-3.10.y
  ##git checkout dsgpl-3.10.y-${synofam}
  git checkout $t
  cd ..
  if [ ! -e _${t}_u_g.patch ]; then
  echo "Generating _${t}_u_g.patch ..."
  diff -wbBur $a/$u linux-dsgpl-3.10.y > _${t}_u_g.patch || true
  fi
  if [ ! -e _${t}-identical-files.txt ]; then
    if [ ! -e _${t}-identical.txt ]; then
      echo "Generating _${t}-identical.txt ..."
      diff --exclude=.git -wbBqrs ${m} linux-dsgpl-3.10.y > _${t}-identical.txt || true
    fi
    echo "Generating _${t}-identical-files.txt ..."
    grep -E '^Dateien .* und .* sind identisch.$' _${t}-identical.txt | sed "s|$a/$u|u|g" |cut -d ' ' -f 2 | cut -d / -f 2- > _${t}-identical-files.txt
    rm _${t}-identical.txt
  fi
done
cd linux-dsgpl-3.10.y
git checkout dsgpl-3.10.y-${synofam}
cd ..

cat  _3.10*.patch | grep -v -E '#ifndef MY_ABC_HERE$|#define MY_ABC_HERE$|#endif$|^\+\+\+|^---|\$Id: |\$Log: |\$Revision: |\$Date: |\$Header: |\$Id\$|Revision 1.1.1.1| log message|CONFIG_CROSS_COMPILE' | grep -E '^\+|^-' | sort | uniq
echo ""
cat _3.10.*_u_g.patch | grep '^Nur in ' |grep -v -E 'gitignore|y: .git|y/arch/arm/boot/dts/include: dt-bindings|y/arch/microblaze/boot/dts: system.dts'

echo OK
