#!/bin/sh

. ./build-env.sh

synofam=comcerto2k
if [ ${BSP_CONFIG} = ds211 ]; then
  synofam=88f628x
elif [ ${BSP_CONFIG} = ds216j ]; then
  synofam=armada38x
fi

if false ; then
if [ ! -e linux/arch/arm/configs/${BSP_CONFIG}_defconfig ]; then
  if [ -e linux/arch/x86/configs/ds214play_defconfig ]; then
    synofam=evansport
  elif [ -e linux/arch/arm/configs/ds214_defconfig ]; then
    synofam=armadaxp
  elif [ -e linux/arch/arm/configs/ds214se_defconfig ]; then
    synofam=armada370
  elif [ -e linux/arch/arm/configs/ds215j_defconfig ]; then
    synofam=armada375
  elif [ -e linux/arch/arm/configs/ds216j_defconfig ]; then
    synofam=armada38x
  elif [ -e linux/arch/arm/configs/ds2015xs_defconfig ]; then
    synofam=alpine
  elif [ -e linux/arch/arm/configs/usbstation2_defconfig ]; then
    synofam=88f6180
  elif [ -e linux/arch/powerpc/configs/ds208_defconfig ]; then
    synofam=854x
  elif [ -e linux/arch/powerpc/configs/ds210plus_defconfig ]; then
    synofam=853x
  elif [ -e linux/arch/powerpc/configs/ds213plus_defconfig ]; then
    synofam=qoriq
  elif [ -e linux/arch/x86/configs/ds1515plus_defconfig ]; then
    synofam=avoton
  elif [ -e linux/arch/x86/configs/ds3611xs_defconfig ]; then
    synofam=bromolow
  elif [ -e linux/arch/x86/configs/ds1512plus_defconfig ]; then
    synofam=cedarview
  else
    synofam=x64
  fi
fi
fi

for e in build-env-*.sh ; do
  . ./${e}
  if [ -e linux/arch/arm/configs/${BSP_CONFIG}_defconfig -o \
       -e linux/arch/arm64/configs/${BSP_CONFIG}_defconfig -o \
       -e linux/arch/powerpc/configs/${BSP_CONFIG}_defconfig -o \
       -e linux/arch/x86/configs/${BSP_CONFIG}_defconfig ]; then
    f=`echo ${e} | cut -d '.' -f 1 | cut -d '-' -f 3`
    if [ "X${f}" != "X" ]; then
      synofam=${f}
    fi
    echo $e
    break
  fi
done

if [ -e build-env-${synofam}.sh ]; then
  echo "Using build-env-${synofam}.sh"
  . ./build-env-${synofam}.sh
else
  . ./build-env.sh
fi

export ARCH=arm64
if [ "X${BSP_ARCH}" = "Xarmhf" ]; then
  export ARCH=arm
  export CROSS_COMPILE=arm-linux-gnueabihf-

elif [ "X${BSP_ARCH}" = "Xamd64" ]; then
  export ARCH=x86
  export CROSS_COMPILE=x86_64-linux-gnu-

elif [ "X${BSP_ARCH}" = "Xi686" ]; then
  export ARCH=x86
  export CROSS_COMPILE=i686-linux-gnu-

elif [ "X${BSP_ARCH}" = "Xpowerpc" ]; then
  export ARCH=powerpc
  export CROSS_COMPILE=powerpc-linux-gnu-
fi

ldcfg=3.x-generic.config
lxcfg=.config

cd linux

VERSION=`cat Makefile | grep -E '^VERSION.=' | cut -d "=" -f 2- | tr -d " \t\n\r"`
PATCHLEVEL=`cat Makefile | grep PATCHLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
SUBVERSION=`cat Makefile | grep SUBLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`

ldcfg=${VERSION}.${PATCHLEVEL}-${BSP_CONFIG}.config

echo "Configuring ${VERSION}.${PATCHLEVEL}.${SUBVERSION}..."

export LOCALVERSION="+${BSP_MODEL}"

ARMADA_PLAT_PJ=plat-armada
ARMADA_PLAT=arch/arm/$ARMADA_PLAT_PJ

BuildArmada375Link()
{
	#check if link to v2
	if [ ! -L "$ARMADA_PLAT" ] ; then
		mv $ARMADA_PLAT ${ARMADA_PLAT}-v1
		ln -s ${ARMADA_PLAT_PJ}-v2 $ARMADA_PLAT
	fi
}

if [ "$synofam" = "armada375" ] ; then
	echo "ARMADA375 platform found..."
	BuildArmada375Link
fi

make LOCALVERSION="${LOCALVERSION}" ARCH=${ARCH} CROSS_COMPILE=${CROSS_COMPILE} defconfig

if [ ! -e config-0 ]; then
  cp -p .config config-0
fi

if [ -e arch/${ARCH}/configs/${BSP_CONFIG}_defconfig ]; then
  echo "Using ${BSP_CONFIG}_defconfig"

  make LOCALVERSION="${LOCALVERSION}" ARCH=${ARCH} CROSS_COMPILE=${CROSS_COMPILE} ${BSP_CONFIG}_defconfig

  cp -p .config $ldcfg
fi

lxcfg=.config
cp -p $ldcfg $lxcfg

sed -i 's|^CONFIG_LOCALVERSION_AUTO=.*|# CONFIG_LOCALVERSION_AUTO is not set|g' $lxcfg
sed -i 's|^CONFIG_DEFAULT_HOSTNAME=.*|CONFIG_DEFAULT_HOSTNAME="(none)"|g' $lxcfg

sed -i 's|^CONFIG_CMDLINE=.*|CONFIG_CMDLINE=""|g' $lxcfg
sed -i 's|^CONFIG_INITRAMFS_SOURCE=.*|CONFIG_INITRAMFS_SOURCE=""|g' $lxcfg

sed -i 's|^CONFIG_DEBUG_INFO=y|# CONFIG_DEBUG_INFO is not set|g' $lxcfg

sed -i 's|^CONFIG_STMMAC_ETH=m|CONFIG_STMMAC_ETH=y|g' $lxcfg
sed -i 's|^CONFIG_STMMAC_PLATFORM=m|CONFIG_STMMAC_PLATFORM=y|g' $lxcfg
sed -i 's|^CONFIG_DWMAC_GENERIC=m|CONFIG_DWMAC_GENERIC=y|g' $lxcfg
sed -i 's|^CONFIG_DWMAC_IPQ806X=m|CONFIG_DWMAC_IPQ806X=y|g' $lxcfg
sed -i 's|^CONFIG_DWMAC_MESON=m|CONFIG_DWMAC_MESON=y|g' $lxcfg
sed -i 's|^CONFIG_DWMAC_ROCKCHIP=m|CONFIG_DWMAC_ROCKCHIP=y|g' $lxcfg
sed -i 's|^CONFIG_DWMAC_SUNXI=m|CONFIG_DWMAC_SUNXI=y|g' $lxcfg

sed -i s/'^CONFIG_SYNO_KEY=.*'/'# CONFIG_SYNO_KEY is not set'/g $lxcfg
sed -i s/'^CONFIG_SYNO_RAMDISK_INTEGRITY_CHECK=.*'/'# CONFIG_SYNO_RAMDISK_INTEGRITY_CHECK is not set'/g $lxcfg

make LOCALVERSION="${LOCALVERSION}" ARCH=${ARCH} CROSS_COMPILE=${CROSS_COMPILE} oldconfig

cd ..

echo OK
