#!/bin/sh

. ./build-env.sh

synofam=comcerto2k
if [ ${BSP_CONFIG} = ds211 ]; then
  synofam=88f628x
elif [ ${BSP_CONFIG} = ds216j ]; then
  synofam=armada38x
fi

if false ; then
if [ ! -e linux/arch/arm/configs/${BSP_CONFIG}_defconfig ]; then
  if [ -e linux/arch/x86/configs/ds214play_defconfig ]; then
    synofam=evansport
  elif [ -e linux/arch/arm/configs/ds214_defconfig ]; then
    synofam=armadaxp
  elif [ -e linux/arch/arm/configs/ds214se_defconfig ]; then
    synofam=armada370
  elif [ -e linux/arch/arm/configs/ds215j_defconfig ]; then
    synofam=armada375
  elif [ -e linux/arch/arm/configs/ds216j_defconfig ]; then
    synofam=armada38x
  elif [ -e linux/arch/arm/configs/ds2015xs_defconfig ]; then
    synofam=alpine
  elif [ -e linux/arch/arm/configs/usbstation2_defconfig ]; then
    synofam=88f6180
  elif [ -e linux/arch/powerpc/configs/ds208_defconfig ]; then
    synofam=854x
  elif [ -e linux/arch/powerpc/configs/ds210plus_defconfig ]; then
    synofam=853x
  elif [ -e linux/arch/powerpc/configs/ds213plus_defconfig ]; then
    synofam=qoriq
  elif [ -e linux/arch/x86/configs/ds1515plus_defconfig ]; then
    synofam=avoton
  elif [ -e linux/arch/x86/configs/ds3611xs_defconfig ]; then
    synofam=bromolow
  elif [ -e linux/arch/x86/configs/ds1512plus_defconfig ]; then
    synofam=cedarview
  else
    synofam=x64
  fi
fi
fi

for e in build-env-*.sh ; do
  . ./${e}
  if [ -e linux/arch/arm/configs/${BSP_CONFIG}_defconfig -o \
       -e linux/arch/arm64/configs/${BSP_CONFIG}_defconfig -o \
       -e linux/arch/powerpc/configs/${BSP_CONFIG}_defconfig -o \
       -e linux/arch/x86/configs/${BSP_CONFIG}_defconfig ]; then
    f=`echo ${e} | cut -d '.' -f 1 | cut -d '-' -f 3`
    if [ "X${f}" != "X" ]; then
      synofam=${f}
    fi
    break
  fi
done

if [ -e build-env-${synofam}.sh ]; then
  echo "Using build-env-${synofam}.sh"
  . ./build-env-${synofam}.sh
else
  . ./build-env.sh
fi

export ARCH=arm64
export KBUILD_IMAGE=Image
if [ "X${BSP_ARCH}" = "Xarmhf" ]; then
  export ARCH=arm
  export CROSS_COMPILE=arm-linux-gnueabihf-
  export KBUILD_IMAGE=Image

elif [ "X${BSP_ARCH}" = "Xamd64" ]; then
  export ARCH=x86
  export CROSS_COMPILE=x86_64-linux-gnu-
  export KBUILD_IMAGE=bzImage

elif [ "X${BSP_ARCH}" = "Xi686" ]; then
  export ARCH=x86
  export CROSS_COMPILE=i686-linux-gnu-
  export KBUILD_IMAGE=bzImage

elif [ "X${BSP_ARCH}" = "Xpowerpc" ]; then
  export ARCH=powerpc
  export CROSS_COMPILE=powerpc-linux-gnu-
  export KBUILD_IMAGE=zImage
fi

cd linux/

if [ ! -e .builddate ]; then
  LANG=C date -u > .builddate
fi

VERSION=`cat Makefile | grep -E '^VERSION.=' | cut -d "=" -f 2- | tr -d " \t\n\r"`
PATCHLEVEL=`cat Makefile | grep PATCHLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
SUBVERSION=`cat Makefile | grep SUBLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
BUILDVERSION=1
BUILDTIMESTAMP=`cat .builddate`
export LOCALVERSION="+${BSP_MODEL}"
export KBUILD_BUILD_TIMESTAMP=${BUILDTIMESTAMP}
export KBUILD_BUILD_VERSION=${BUILDVERSION}
export KBUILD_DEBARCH=${BSP_ARCH}
export KDEB_PKGVERSION="${VERSION}.${PATCHLEVEL}.${SUBVERSION}-20210804-${BSP_MODEL}"

echo "Building ${KDEB_PKGVERSION}..."

kmake() {
  echo ""
  echo "make $*"

  #KBUILD_IMAGE="Image"
    fakeroot make $* KDEB_PKGVERSION="${KDEB_PKGVERSION}" LOCALVERSION="${LOCALVERSION}" ARCH=${ARCH} CROSS_COMPILE=${CROSS_COMPILE} \
  KBUILD_BUILD_TIMESTAMP="${KBUILD_BUILD_TIMESTAMP}" KBUILD_BUILD_VERSION=${KBUILD_BUILD_VERSION} \
  KBUILD_DEBARCH=${KBUILD_DEBARCH} \
  DEBFULLNAME="SCP" \
  DEBEMAIL="scsupport@detc.local"
}

kmake -j4 $KBUILD_IMAGE modules

if [ "X${BSP_ARCH:0:3}" = "Xarm" -a ${VERSION} -gt 2 ]; then
  kmake dtbs
fi

kmake headers_check 
kmake scripts

kmake -j1 deb-pkg 
#kmake -j1 bindeb-pkg

cd ..

echo linux-image-${KDEB_PKGVERSION}-${KBUILD_DEBARCH}.zip
zip linux-image-${KDEB_PKGVERSION}-${KBUILD_DEBARCH}.zip install-linux.sh install-dtb.sh install-image.sh install-uinitrd.sh linux-*_${KDEB_PKGVERSION}_*.deb

